package jp.wda.gpss.system;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;

import jp.wda.gpss.Progress;
import jp.wda.gpss.Socklet;
import jp.wda.gpss.SockletDeployInfo;
import jp.wda.gpss.SockletDeployingException;
import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;

/**
 * <FONT SIZE=2><I><B>
 * [ OProject GPSS for FlashMX ] FlashMXpėp\PbgT[o
 * </B></I></FONT><BR>
 * \Pbg҂CT[oNX<BR>
 * java.nioutil.concurrentgłB<BR>
 * ڑtƃf[^t͑SăCXbhōs܂B<BR>
 * Mf[^̏̓v[ꂽXbhŎs܂<BR>
 * <BR>
 *
 * @version	6		2004/03/06
 * @since		0		2003/12/18
 * @author	amoi, TakenoriAdachi(TheCoolMuseum)
 */
public class MainReactor extends ExecutableBase {
	// RXgN^ ///////////////////////////////////////////////////////////////////
	//                                                                    Constructors //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 *	ftHg̐ݒpăIuWFNg\zRXgN^
	 */
	public MainReactor(Configuration config) {
		super(config);

		this.terminator = false;
	}

	/* ***********************************************************************>> */;
	/**
	 * JVMKx[WRN^ɂČĂ΂AIB<BR>
	 * zĂSĂSocklet̏IsȂ܂B<BR>
	 * IĂꍇ́AɉsȂ܂B
	 */
	protected void finalize() {
		if (this.terminator) {
			return;
		}

		Iterator it = getSocklets();
		while (it.hasNext()) {
			Socklet app = (Socklet)it.next();
			app.destroy();
		}
	}

	// tB[h` ///////////////////////////////////////////////////////////////
	//                                                                          Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/**
	 * T[o[`l
	 */
	private ServerSocketChannel serverChannel;
	/**
	 * ZN^[
	 */
	private Selector selector;

	/**
	 * T[oIXCb`
	 */
	private boolean terminator = false;

	/**
	 * obt@̃GR[_[EfR[_[
	 */
	private Charset coder = null;
	/**
	 * obt@p̃R[_[擾
	 * @return T[o[̃R[_[
	 */
	Charset getCodec() {
		return coder;
	}

	/**
	 * R}hpXbhv[
	 */
	private PooledExecutor pool;
	/**
	 * T[o[̃Xbhv[擾
	 * @return
	 */
	PooledExecutor getPool() {
		return pool;
	}

	/**
	 * ؒf郆[U[̃Xg
	 */
	private ArrayList closeClients;

	// \bh /////////////////////////////////////////////////////////////////////
	//                                                                 Private Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * T[oJnAڑEf[^󂯕t܂B
	 * @see jp.wda.gpss.system.ExecutableBase#accept()
	 */
	public void accept() {
		System.out.println("Starting server...");

		int n = 0;
		SleeperSweeper sweeper = null;
		ServerSocket serverSocket = null;

		coder = Charset.forName(getEncoding());

		pool = makeThreadPool(); //Xbhv[̍쐬
		try {

			try {
				closeClients = new ArrayList();

				serverChannel = ServerSocketChannel.open();
				serverSocket = serverChannel.socket();
				selector = Selector.open();

				serverSocket.bind(new InetSocketAddress(getPort()));
				serverChannel.configureBlocking(false);

				SelectionKey acceptKey =
					serverChannel.register(selector, SelectionKey.OP_ACCEPT);
				acceptKey.attach(new AcceptHandler(acceptKey, this));

				sweeper = new SleeperSweeper(selector);
				new Thread(sweeper, "Sweeper").start();

			} catch (IOException ioe) {
				getProgress().errlog("T[o[\Pbg̐Ɏs܂", ioe);
				return;
			}
			// T[oNĂԂ́BBB
			while (true) {
				try {
					//ItO`FbN
					if (terminator) {
						break; //I
					}

					//getProgress().log("debuglogger", "selecting...");
					n = selector.select(10000);
					//getProgress().log("debuglogger", n + " selected");

					//ZNgĂȂ
					if (n != 0) {

						//L[̃Ce[^[쐬
						Set selected = selector.selectedKeys();
						Iterator it = selected.iterator();

						//SẴL[ɃV[N
						while (!terminator && it.hasNext()) {
							//IXgL[擾
							SelectionKey key = (SelectionKey)it.next();
							//getProgress().log("debuglogger", "key: " + key);

							//L[IXg폜
							it.remove();

							//L[ɃA^b`ꂽIuWFNg̃ANVN
							dispatch(key);
						}
						//selected.clear();
					}
					closeClientConnections();
				} catch (ClosedSelectorException cse) {
					//  ZN^[N[YĂ
					getProgress().errlog("ZN^[̓N[YĂ܂", cse);
					break;
				} catch (IOException ioe) {
					getProgress().errlog("o̓G[܂B", ioe);
					break;
					//} catch (ClosedChannelException cce) {
					//	//  `lN[YĂ
					//	getProgress().errlog("`l̓N[YĂ܂", cce);
					//	break;
				} catch (RuntimeException e) {
					//̗O͗vEE
					getProgress().errlog("^CG[܂B", e);
				} catch (Throwable e) {
					getProgress().errlog("O܂", e);
					break;
				}
			}
		} finally {
			closeClientConnections();
			//T[o[`lƃZN^[N[Y
			try {
				if (serverChannel != null) {
					serverChannel.close();
				}
				if (selector != null) {
					selector.close();
				}
			} catch (Exception e) {
				;
			}
			if (sweeper != null) {
				sweeper.terminate();
			}
			if (pool != null) {
				pool.shutdownNow();
			}

			getProgress().syslog("Shutdown successfully!");

			this.terminator = false;
		}
	}

	/**
	 * ZNVL[ɃA^b`ꂽIuWFNgrun()\bhs܂B
	 * @param key
	 */
	private void dispatch(SelectionKey key) {
		//long t = System.currentTimeMillis();
		Runnable handler = (Runnable) (key.attachment());
		if (handler != null) {
			try {
				handler.run();
			} catch (Exception e) {
				getProgress().errlog("Exception:", e);
			}
		}
		//System.out.println("read:"+ (System.currentTimeMillis()-t) + "ms");
	}

	/**
	 * [J[Xbh쐬đҋ@܂
	 * el͐ݒt@Cǂ߂قB
	 */
	private PooledExecutor makeThreadPool() {
		PooledExecutor pool = new PooledExecutor(new BoundedBuffer(100), 30);
		//ő30Xbh R}hL[100
		pool.setMinimumPoolSize(5); //ŏ5Xbh
		pool.setKeepAliveTime(5 * 60 * 1000); //^CAEg5
		pool.waitWhenBlocked(); //EFCg[hݒ
		pool.createThreads(5); //5XbhŊJn
		return pool;
	}

	/**
	 * N[Y郆[U[N[YXgɒǉ܂
	 * @param client
	 */
	void closeClient(SocketProcessorImplReactor client) {
		synchronized (closeClients) {
			closeClients.add(client);
		}
	}
	/**
	 * N[YXg̃[U[̃`lN[Y܂
	 */
	private void closeClientConnections() {
		synchronized (closeClients) {
			while (closeClients.size() > 0) {
				((SocketProcessorImplReactor) (closeClients.remove(0)))
					.closeConnection();
			}
		}
	}

	// SystemCommandSockletp\bh ///////////////////////////////////////////////////
	//                                                Methods for SystemCommandSocklet //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * T[oI܂B
	 * @param sys ĂяoSystemCommandSocklet
	 * @see jp.wda.gpss.ExecutableBase#shutdown(SystemCommandSocklet)
	 */
	void shutdown(SystemCommandSocklet sys) {
		if (terminator || !checkSystemCommandSocklet(sys)) {
			return;
		}

		getProgress().syslog("Shutdown server...");

		// ڑ̑SNCAgؒf
		Iterator it = getSocklets();
		while (it.hasNext()) {
			Socklet app = (Socklet)it.next();
			app.disconnectAllClients("Good by...");
			app.destroy();
		}

		//ItOZbg
		terminator = true;

		//System.out.println("selector.wakeup()");
		selector.wakeup();

	}

	/* ***********************************************************************>> */;
	/**
	 * T[oċN܂B
	 * @param sys ĂяoSystemCommandSocklet
	 * @see jp.wda.gpss.ExecutableBase#restart(SystemCommandSocklet)
	 */
	void restart(SystemCommandSocklet sys) {
		if (!checkSystemCommandSocklet(sys)) {
			return;
		}

		setRestartAfterShutdown();
		shutdown(sys);
	}

	/* ***********************************************************************>> */;
	/**
	 * w肵zSockletċN܂
	 * 
	 * @param sys ĂяoSystemCommandSocklet
	 * @param name Sockletz
	 * @return ċNɐ^
	 * @see jp.wda.gpss.ExecutableBase#restartSocklet(SystemCommandSocklet, String)
	 */
	boolean restartSocklet(SystemCommandSocklet sys, String name) {
		if (!checkSystemCommandSocklet(sys)) {
			return false;
		}

		getProgress().syslog("Restart socklet \"" + name + "\"");
		Socklet socklet = this.getSocklet(name);
		SockletDeployInfo info = null;
		String scriptExt = null;
		File scriptFile = null;
		SockletLoader loader = null;
		if (socklet != null && socklet instanceof ScriptSocklet) {
			scriptExt = ((ScriptSocklet)socklet).getExtention();
			scriptFile = ((ScriptSocklet)socklet).getScriptFile();
			ScriptInfo scrinfo = getScriptInfomation(scriptExt);

			if (scrinfo != null && scriptFile != null && scriptFile.exists()) {
				info = getScriptSockletInformation(name);
				info.addInitParam("source", scriptFile.getAbsolutePath());
				info.addInitParam("sourceEncoding", scrinfo.getEncoding());
				info.setClassname(scrinfo.getJSClass().getName());
			}

			loader = this.scriptLoader;
		} else {
			info = getSockletInformation(name);
		}

		if (info == null) {
			getProgress().syslog(
				"Socket \"" + name + "\"'s infomation is not found.",
				Progress.ERROR);
			return false;
		}

		// Socklet̒~
		terminateSocklet(socklet, "Good by...");

		getProgress().syslog(
			"Socklet\"" + info.getName() + "\"(" + info.getClassname() + ")z܂B");
		try {
			socklet = deployNewSocklet(info, DEPLOY_BY_SYSTEM, loader);
			if (socklet instanceof ScriptSocklet) {
				((ScriptSocklet)socklet).setExtention(scriptExt);
				((ScriptSocklet)socklet).setScriptFile(scriptFile);
			}
		} catch (SockletDeployingException e) {
			getProgress().errlog("Socklet̔zɎs܂B", e);
			return false;
		}
		return true;
	}

	/* ***********************************************************************>> */;
	/**
	 * ݒt@CēǍ܂B
	 * @param sys ĂяoSystemCommandSocklet
	 * @return ēǍɐ^
	 * @see jp.wda.gpss.ExecutableBase#reloadCongif(SystemCommandSocklet)
	 */
	boolean reloadConfig(SystemCommandSocklet sys) {
		if (!checkSystemCommandSocklet(sys)) {
			return false;
		}

		System.out.println("Reload config...");
		try {
			loadConfig();
		} catch (ConfigurationError e) {
			getProgress().errlog("ݒt@C̍ēǍɎs܂B", e);
			return false;
		}

		reloadSystemCommandInfo();

		System.out.println("Reload config successfully!");
		return true;
	}

	// NX ///////////////////////////////////////////////////////////////////////
	//                                                                   Inner Classes //
	/////////////////////////////////////////////////////////////////////////////////////

	/**
	 * ZN^[ACCEPTv邽߂̃NXłB
	 */
	private class AcceptHandler implements Runnable {
		SelectionKey key;
		MainReactor main;

		public AcceptHandler(SelectionKey key, MainReactor main) {
			this.key = key;
			this.main = main;
		}

		/**
		 * NCAgIuWFNg쐬܂B
		 */
		public void run() {
			SocketProcessorImplReactor client = null;
			try {
				ServerSocketChannel server = (ServerSocketChannel)key.channel();

				SocketChannel channel = server.accept();
				if (channel != null) {

					Socket socket = channel.socket();

					getProgress().syslog(
						"Create Client... "
							+ socket.getInetAddress().getHostAddress());

					channel.configureBlocking(false);
					SelectionKey clientKey =
						channel.register(key.selector(), SelectionKey.OP_READ);
					//NCAgIuWFNg̐
					client =
						new SocketProcessorImplReactor(
							main,
							channel,
							clientKey,
							getEncoding(),
							getMessagesBufferSize());
					clientKey.attach(client);

					//socket.setSoTimeout(getInitialTimeout());
					client.setTimeout(getInitialTimeout());

					//ڑZLeBeXg
					if (getSecurityController().enter(client)) {
						getProgress().syslog(
							"Welcome "
								+ client.getIPAddress()
								+ "! (ID:"
								+ client.getClientID()
								+ ")");
					} else {
						getProgress().syslog(
							"Connection Rejected... " + client.getIPAddress());
						client.terminate();
					}
				}
			} catch (InterruptedIOException e) {
				getProgress().errlog("^CAEgݒɎs܂B:" + client.getClientID(), e);
				return;
			} catch (IOException e) {
				//getProgress().log("debuglogger", e);
				getProgress().errlog("ڑɗO܂B:" + client.getClientID(), e);
				return;
			} catch (Exception e) {
				//getProgress().log("debuglogger", e);
				getProgress().errlog("ڑɗO܂B:" + client.getClientID(), e);
				return;
			}

			return;
		}
	}

	/* ***********************************************************************>> */;
	/**
	 * ^CAEgؒfNX
	 */
	private final class SleeperSweeper implements Runnable {
		Selector selector;
		boolean terminator;

		public SleeperSweeper(Selector selector) {
			this.selector = selector;
			this.terminator = false;
		}

		/**
		 * ĎXbh~
		 */
		public synchronized void terminate() {
			terminator = true;
			notify();
		}

		/**
		 * IɃNCAg̃^CAEgoؒf
		 * @see java.lang.Runnable#run()
		 */
		public synchronized void run() {
			while (true) {
				if (terminator) {
					break;
				}
				Object[] keyArray;
				try {
					keyArray = new ArrayList(selector.keys()).toArray();
				} catch (ClosedSelectorException cse) {
					break;
				} catch (ConcurrentModificationException e) {
					try {
						wait(10000);
					} catch (Throwable ie) {
						getProgress().errlog("SweeperError create list", e);
					}
					continue;
				}
				for (int i = 0; keyArray.length > i; i++) {
					try {
						Object obj = ((SelectionKey)keyArray[i]).attachment();
						if (obj == null) {
							getProgress().errlog(
								"SweeperError key has no attachment");
						}
						if (obj instanceof SocketProcessorImplReactor) {
							SocketProcessorImplReactor client =
								(SocketProcessorImplReactor)obj;
							client.terminateIfInactive();
						}
					} catch (Throwable e) {
						getProgress().errlog("SweeperError sweep clients", e);
					}
					Thread.yield();
				}
				keyArray = null;
				try {
					wait(10000);
				} catch (Throwable e) {
					;
				}
			}
		}
	}
}
/**
 * <FONT SIZE=2><I><B>
 * [ OProject GPSS for FlashMX ] FlashMXpėp\PbgT[o
 * </B></I></FONT><BR>
 *	NCAg\PbgC^[tF[X̎
 *
 *	@author	amoi, TakenoriAdachi(TheCoolMuseum)
 */
final class SocketProcessorImplReactor
	extends SocketProcessorBase
	implements Runnable {
	// RXgN^ ///////////////////////////////////////////////////////////////////
	//                                                                    Constructors //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 *	CT[oƃ\Pbgw肵ăIuWFNg\z܂B
	 *
	 * @param main CT[o
	 * @param socket \Pbg
	 */
	public SocketProcessorImplReactor(
		MainReactor server,
		SocketChannel channel,
		SelectionKey key,
		String encoding,
		int buffersize)
		throws IOException {
		super(
			server,
			encoding,
			buffersize,
			channel.socket().getInetAddress().getHostAddress());
		this.server = server;
		this.channel = channel;
		this.key = key;
		this.codec = server.getCodec();
		this.buffer = ByteBuffer.allocate(BUFFER_SIZE);
		this.messageBuffer = new ByteBufferList(BUFFER_SIZE);

		recordActive();
	}

	// tB[h` ///////////////////////////////////////////////////////////////
	//                                                                          Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * \Pbg`l
	 */
	private SocketChannel channel;
	private SelectionKey key;
	/**
	 * byteBufferGR[_[
	 */
	private Charset codec;

	/**
	 * bZ[Wobt@
	 */
	private ByteBuffer buffer;
	private ByteBufferList messageBuffer;
	private static final int BUFFER_SIZE = 4096;
	private static final int BUFFER_POOL_SIZE = 16;

	/**
	 * ҂󂯃T[o[
	 */
	private MainReactor server;

	private Object executeLock = new Object();

	//-------------------------------
	//^CAEg
	//nioł@ł傤EE
	//-------------------------------
	/**
	 * ^CAEg
	 */
	private long timeout = 0;
	/**
	 * ŏI
	 */
	private long lastAct = System.currentTimeMillis();
	/**
	 * ^CAEgԂ~bŐݒ<BR>
	 * ݒ莞0Ŗ<BR>
	 * @param timeout
	 */
	void setTimeout(long timeout) {
		this.timeout = timeout;
	}
	/**
	 * ^CAEgĂ邩ǂ`FbN
	 * @return
	 */
	boolean isInactive() {
		if (timeout == 0) {
			return false;
		}
		return System.currentTimeMillis() > timeout + lastAct;
	}
	/**
	 * ŏIL^
	 */
	void recordActive() {
		lastAct = System.currentTimeMillis();
	}

	/**
	 * ^CAEgĂȂI
	 */
	void terminateIfInactive() {
		if (isInactive() && !terminator) {
			terminate("Connection timeout..");
		}
	}

	// vpeB ///////////////////////////////////////////////////////////////////////
	//                                                                      Properties //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * ItO
	 */
	private boolean terminator = false;
	/**
	 * ItOmF
	 */
	public boolean isTerminated() {
		return terminator;
	}

	// CX^X\bh /////////////////////////////////////////////////////////////
	//                                                                Instance Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * \PbgR}hMAAvP[ṼC^v^ɗ܂B
	 *	@see java.lang.Runnable#run()
	 */
	public void run() {
		int length = -1;
		byte b = 0;

		buffer.clear();

		try {
			while (!terminator && (length = channel.read(buffer)) > 0) {
				recordActive(); //L^ @͂Ƃŕς邩
				buffer.flip(); //obt@ǂݏo\
				while (buffer.hasRemaining()) {
					b = buffer.get(); //1oCg擾
					if (b != 0) {
						messageBuffer.put(b); //bZ[Wobt@ɒ~
					} else {
						try {
							//[J[XbhŃR}h
							server.getPool().execute(
								new CommandProcessor(this, messageBuffer));
							//new CommandProcessor(this, messageBuffer).run();
						} catch (InterruptedException ie) {
							;
						}
						//obt@̃NA
						messageBuffer.clear();
					}
				}
				buffer.clear(); //obt@̃NA
			}
		} catch (ClosedChannelException e) {
			getProgress().errlog("\Pbg͊ɃN[YĂ܂B:" + getClientID(), e);
			if (!terminator) {
				terminate();
			}
			return;
		} catch (IOException ioe) {
			getProgress().errlog("̓G[܂B:" + getClientID(), ioe);
			if (!terminator) {
				terminate();
			}
			return;
		} catch (Exception e) {
			getProgress().errlog("G[܂B:" + getClientID(), e);
			if (!terminator) {
				terminate();
			}
			return;
		}

		//\PbgN[YEǂݏoG[
		if (length < 0 && !terminator) {
			terminate(); //NCAgI
		}
	}

	/**
	 * NCAg̐ڑ
	 * @param mesage
	 */
	private void onInitialize(String message) {
		if (terminator) {
			return;
		}
		synchronized (executeLock) {
			try {
				doInitialCommand(message);

				// Sockletݒ肳ĂȂꍇ͒ɏIB
				if (getApplication() == null) {
					terminate();
					return;
				}

				// NCAg̐ڑsAʂʒm܂B
				// ʒmbZ[WMɎsꍇ͒ɏIB
				if (!getApplication().checkConnection(this)) {
					terminate();
					return;
				}

				terminator = false;

				// ^CAEgԂݒ
				//channel.socket().setSoTimeout(getApplication().getTimeout());
				setTimeout(getApplication().getTimeout());

				//} catch (SocketException ioe) {
				//	getProgress().errlog(ioe.getMessage() + ":" + getClientID());
				//	terminate();
			} catch (Throwable e) {
				getProgress().errlog("NCAgɗO܂B" + getClientID(), e);
				terminate();
			}
		}
	}

	/**
	 * NCAg̃R}h̏
	 * @param message
	 */
	private void onCommand(String message) {
		if (terminator) {
			return;
		}
		synchronized (executeLock) {
			try {
				if (!getApplication().doCommand(this, message)) {
					if (!terminator) {
						terminate();
					}
				}
			} catch (Throwable e) {
				getProgress().errlog(message);
				getProgress().errlog("R}hɗO܂B" + getClientID(), e);

			}
		}
	}

	/* ***********************************************************************>> */;
	/**
	 * NCAgɃbZ[W𑗂܂B<BR>
	 * bZ[Wnull"\0"I[Ƃ܂B<BR>
	 * ̃\bhł́AMp̕ʃXbhgp܂B<BR>
	 * NCAgɃbZ[WM̂҂܂B<BR>
	 *
	 * @param message NCAgɑ郁bZ[W
	 * @return Mɐꍇ͐^Asꍇ͋U
	 */
	public boolean send(String message) {
		//System.out.println("send: " + message + "\n to " + getClientID());
		if (terminator) {
			return false;
		}
		if (this.channel == null) {
			getProgress().errlog("C^r܂B" + getClientID());
			if (!terminator) {
				terminate();
			}
			return false;
		}
		//ByteBuffer buffer = codec.encode(message + "\0");
		ByteBuffer buffer = Charset.forName(getEncoding()).encode(message + "\0");
		try {
			channel.write(buffer);
			return true;
		} catch (Exception e) {
			getProgress().errlog("MɎs܂B" + getClientID() + "\n" + message, e);
			if (!terminator) {
				terminate();
			}
			return false;
		}
	}

	/* ***********************************************************************>> */;
	/**
	 * NCAgIɏI܂B
	 * @see jp.wda.gpss.SocketProcessor#terminate()
	 */
	public void terminate() {
		synchronized (this) {
			if (this.terminator) {
				return;
			}
			this.terminator = true;
		}
		// fobOpóB
		//getProgress().log("debuglogger", "disconnect [" + getClientID() + "]");

		//ڑZLeBJ
		server.getSecurityController().exit(this);

		try {
			// AvP[V炱̃NCAg폜
			if (getApplication() != null) {
				getApplication().preRemoveClient(this);
				getApplication().removeClient(this);
				notifyToSystemCommandSocklet();
			}
		} catch (Throwable e) {
			getProgress().errlog("IɗO܂B" + getClientID(), e);
		}

		// \Pbg
		server.closeClient(this);
		key.selector().wakeup();
	}

	/**
	 * NCAgɏIbZ[WoANCAg\PbgI܂B
	 * @param message IbZ[W
	 * @see jp.wda.gpss.SocketProcessor#terminate(String)
	 */
	public void terminate(String message) {
		send(message);
		terminate();
	}

	/**
	 * `l
	 */
	public void closeConnection() {
		if (channel != null) {
			try {
				channel.close();
			} catch (IOException e) {
				getProgress().errlog("`lIɗO܂B" + getClientID(), e);
			}
		}
		channel = null;
	}

	/**
	 * R}hXbhŎs邽߂̓NX 
	 */
	private class CommandProcessor implements Runnable {
		private ByteBuffer command;
		private SocketProcessorImplReactor client;

		/**
		 * R}hIuWFNg̃RXgN^
		 * @param client
		 * @param command
		 */
		private CommandProcessor(
			SocketProcessorImplReactor client,
			ByteBufferList command) {
			this.command = command.toByteBuffer();
			this.client = client;
		}

		/**
		 * R}hIuWFNg̎s
		 * [LOXbhs܂B
		 * @see java.lang.Runnable#run()
		 */
		public void run() {
			if (!client.isTerminated()) {
				//long t = System.currentTimeMillis();

				//obt@𕶎ɕϊ
				//String com = codec.decode(command).toString();
				String com =
					Charset.forName(getEncoding()).decode(command).toString();

				//R}hs
				if (client.getApplication() != null) {
					client.onCommand(com);
				} else {
					client.onInitialize(com);
				}

				//System.out.println("process:"+ (System.currentTimeMillis()-t) + "ms");
			}
		}
	}

	/**
	 * bZ[Wobt@p̓NX 
	 */
	private class ByteBufferList {
		private ArrayList list;
		private ByteBuffer current;
		private int bufferLength;

		/**
		 * RXgN^
		 * @param length
		 */
		public ByteBufferList(int length) {
			list = new ArrayList();
			bufferLength = length;
			current = null;
		}
		/**
		 * obt@1oCgǉ
		 * @param b
		 */
		public void put(byte b) {
			if (current == null || current.position() == current.limit()) {
				current = ByteBuffer.allocate(bufferLength);
				list.add(current);
			}
			current.put(b);
		}
		/**
		 * obt@Ɉꊇǉ
		 * @param bb
		 */
		public void put(ByteBuffer bb) {
			while (bb.hasRemaining()) {
				put(bb.get());
			}
		}
		/**
		 * eoCgobt@
		 * @return
		 */
		public ByteBuffer toByteBuffer() {
			ByteBuffer buf = ByteBuffer.allocate(bufferLength * list.size());
			Iterator itr = list.iterator();
			while (itr.hasNext()) {
				ByteBuffer tmpBuf = (ByteBuffer)itr.next();
				tmpBuf.flip();
				buf.put(tmpBuf);
			}
			buf.flip();
			return buf;
		}
		/**
		 * obt@̃NA
		 */
		public void clear() {
			list.clear();
			current = null;
		}
	}
}
