/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.deployer;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.CyclicReferenceRuntimeException;
import org.seasar.framework.container.deployer.AbstractComponentDeployer;
import org.seasar.framework.hotswap.Hotswap;
import org.seasar.framework.hotswap.HotswapProxy;
import org.seasar.framework.hotswap.HotswapTargetFactory;

public class SingletonComponentDeployer
extends AbstractComponentDeployer
implements HotswapTargetFactory {
    private Object component;
    private Object hotswapTarget;
    private Hotswap hotswap;
    private boolean instantiating = false;

    public SingletonComponentDeployer(ComponentDef componentDef) {
        super(componentDef);
    }

    public synchronized Object deploy() {
        if (this.component == null) {
            this.assemble();
        }
        return this.component;
    }

    public void injectDependency(Object component) {
        throw new UnsupportedOperationException("injectDependency");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assemble() {
        if (this.instantiating) {
            throw new CyclicReferenceRuntimeException(this.getComponentDef().getComponentClass());
        }
        this.instantiating = true;
        try {
            Object o = this.getConstructorAssembler().assemble();
            if (this.hotswap != null) {
                this.hotswapTarget = o;
                if (this.component == null) {
                    this.component = HotswapProxy.create(this.getComponentDef().getComponentClass(), this, Thread.currentThread().getContextClassLoader());
                }
            } else {
                this.component = o;
            }
        }
        finally {
            this.instantiating = false;
        }
        this.getPropertyAssembler().assemble(this.getTarget());
        this.getInitMethodAssembler().assemble(this.getTarget());
    }

    protected Object getTarget() {
        return this.hotswapTarget != null ? this.hotswapTarget : this.component;
    }

    public void init() {
        this.hotswap = this.getComponentDef().getHotswap();
        if (this.hotswap != null && !this.isAppliedHotswap()) {
            this.hotswap = null;
        }
        this.deploy();
    }

    protected boolean isAppliedHotswap() {
        Class clazz = this.getComponentDef().getComponentClass();
        if (clazz == null) {
            return false;
        }
        Class<?>[] itfs = clazz.getInterfaces();
        if (itfs == null) {
            return false;
        }
        for (int i = 0; i < itfs.length; ++i) {
            if (itfs[i].getMethods().length <= 0) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
        if (this.component == null) {
            return;
        }
        this.getDestroyMethodAssembler().assemble(this.getTarget());
        this.component = null;
        this.hotswapTarget = null;
    }

    public synchronized Object updateTarget() {
        if (this.hotswap.isModified()) {
            this.assemble();
        }
        return this.hotswapTarget;
    }
}

