/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.system;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import jp.wda.gpss.SocketProcessor;
import jp.wda.gpss.Socklet;
import jp.wda.gpss.SockletDeployInfo;
import jp.wda.gpss.system.ScriptSocklet;
import jp.wda.gpss.system.SynchronizedFunction;
import jp.wda.gpss.util.Finder;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.ToolErrorReporter;

public class RhinoJsSocklet
extends ScriptSocklet {
    private Context cx;
    private ScriptableObject scope;
    private String encoding;
    private String debug;
    static /* synthetic */ Class class$0;

    public void init(List linkedSocklets) {
        try {
            this.cx = Context.enter(null);
            this.scope = new ImporterTopLevel(this.cx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.encoding = this.getInitParam("sourceEncoding");
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        this.debug = this.getInitParam("debug");
        if (this.debug == null) {
            this.debug = "normal";
        }
        String fileName = this.getInitParam("source");
        String script = "";
        if (fileName != null) {
            try {
                script = this.loadFile(fileName, this.encoding);
                System.out.println("  \u30b9\u30af\u30ea\u30d7\u30c8'" + fileName + "'\u3092\u521d\u671f\u5316\u4e2d\u3067\u3059\u3002");
            }
            catch (Exception e) {
                System.out.println("  \u30b9\u30af\u30ea\u30d7\u30c8'" + fileName + "'\u3092\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3002");
            }
        }
        try {
            this.scope.put("application", (Scriptable)this.scope, (Object)this);
            String[] names = new String[]{"sync"};
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jp.wda.gpss.system.RhinoJsSocklet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.scope.defineFunctionProperties(names, (Class)clazz, 2);
            this.cx.evaluateString((Scriptable)this.scope, script, fileName, 1, null);
            if (!(this.get("onInit") instanceof Function)) {
                System.out.println("      onInit\u304c\u672a\u5b9a\u7fa9\u3067\u3059\u3002");
                this.cx.evaluateString((Scriptable)this.scope, "function onInit(){}", fileName, 1, null);
            }
            if (!(this.get("onConnect") instanceof Function)) {
                System.out.println("      onConnect\u304c\u672a\u5b9a\u7fa9\u3067\u3059\u3002");
                this.cx.evaluateString((Scriptable)this.scope, "function onConnect(client){client.send(\"+OK\");return true;}", fileName, 1, null);
            }
            if (!(this.get("onDisconnect") instanceof Function)) {
                System.out.println("      onDisconnect\u304c\u672a\u5b9a\u7fa9\u3067\u3059\u3002");
                this.cx.evaluateString((Scriptable)this.scope, "function onDisconnect(client){}", fileName, 1, null);
            }
            if (!(this.get("onCommand") instanceof Function)) {
                System.out.println("      onCommand\u304c\u672a\u5b9a\u7fa9\u3067\u3059\u3002");
                this.cx.evaluateString((Scriptable)this.scope, "function onCommand(client,command){application.sendToAllClients(command);return true;}", fileName, 1, null);
            }
            if (!(this.get("onDestroy") instanceof Function)) {
                this.cx.evaluateString((Scriptable)this.scope, "function onDestroy(){}", fileName, 1, null);
            }
            if (!(this.get("onSockletLink") instanceof Function)) {
                this.cx.evaluateString((Scriptable)this.scope, "function onSockletLink(from){return false;}", fileName, 1, null);
            }
            this.call("onInit", new Object[]{linkedSocklets});
            Context.exit();
        }
        catch (Exception e) {
            this.reportError(e);
            Context.exit();
        }
    }

    public boolean checkConnection(SocketProcessor client) {
        try {
            Context.enter();
            Object result = this.call("onConnect", new Object[]{client});
            Context.exit();
            return "true".equals(result.toString());
        }
        catch (Exception e) {
            this.reportError(e);
            Context.exit();
            return false;
        }
    }

    public void preRemoveClient(SocketProcessor client) {
        try {
            Context.enter();
            this.call("onDisconnect", new Object[]{client});
        }
        catch (Exception e) {
            this.reportError(e);
        }
        Context.exit();
    }

    public boolean doCommand(SocketProcessor client, String command) {
        try {
            Context.enter();
            Object result = this.call("onCommand", new Object[]{client, command});
            Context.exit();
            return "true".equals(result.toString());
        }
        catch (Exception e) {
            this.reportError(e);
            Context.exit();
            return false;
        }
    }

    public void destroy() {
        try {
            Context.enter();
            this.call("onDestroy", new Object[0]);
        }
        catch (Exception e) {
            this.reportError(e);
        }
        this.cx = null;
        this.scope = null;
        Context.exit();
    }

    public boolean allowAccessFromOtherSocklet(Socklet from) {
        try {
            Context.enter();
            Object result = this.call("onSockletLink", new Object[]{from});
            Context.exit();
            return "true".equals(result.toString());
        }
        catch (Exception e) {
            this.reportError(e);
            Context.exit();
            return false;
        }
    }

    public boolean importSource(String fileName) {
        String script = this.loadFile(fileName, this.encoding);
        try {
            this.cx.evaluateString((Scriptable)this.scope, script, fileName, 1, null);
            return true;
        }
        catch (Exception e) {
            this.reportError(e);
            return false;
        }
    }

    public void addSocklet(List links, String sockletName, String className) {
        SockletDeployInfo appinfo = this.copyInfo(sockletName, className);
        links.add(appinfo);
    }

    public void addScriptSocklet(List links, String sockletName, String fileName) {
        SockletDeployInfo appinfo = this.copyInfo(sockletName, "jp.wda.gpss.system.RhinoJsSocklet");
        appinfo.setInitParam("source", fileName);
        links.add(appinfo);
    }

    public Object call(String functionName, Object[] args) {
        try {
            Object func = this.scope.get(functionName, (Scriptable)this.scope);
            if (func instanceof Function) {
                return ((Function)func).call(this.cx, (Scriptable)this.scope, (Scriptable)this.scope, args);
            }
        }
        catch (Exception e) {
            this.reportError(e);
        }
        return null;
    }

    public Object get(String variableName) {
        try {
            return this.scope.get(variableName, (Scriptable)this.scope);
        }
        catch (Exception e) {
            this.reportError(e);
            return null;
        }
    }

    public void send(String message) {
        this.sendToAllClients(message);
    }

    public void send(String message, String condition) {
        this.sendToClients(message, condition);
    }

    public void send(String message, Finder finder) {
        this.sendToClients(message, finder);
    }

    public void send(String message, SocketProcessor client) {
        client.send(message);
    }

    public void send(String message, Object[] clients) {
        int i = 0;
        while (i < clients.length) {
            if (clients[i] instanceof SocketProcessor) {
                ((SocketProcessor)clients[i]).send(message);
            }
            ++i;
        }
    }

    public Object[] getUsers() {
        return this.getAllClients().toArray();
    }

    public Object[] getUsers(String condition) {
        return this.getClients(condition).toArray();
    }

    public Object[] getUsers(Finder finder) {
        return this.getClients(finder).toArray();
    }

    public static Object sync(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length == 1 && args[0] instanceof Function) {
            return new SynchronizedFunction((Scriptable)((Function)args[0]));
        }
        if (args.length == 2 && args[0] instanceof Function) {
            return new SynchronizedFunction((Scriptable)((Function)args[0]), args[1]);
        }
        throw RhinoJsSocklet.reportRuntimeError("msg.sync.args");
    }

    static RuntimeException reportRuntimeError(String msgId) {
        String message = ToolErrorReporter.getMessage((String)msgId);
        return Context.reportRuntimeError((String)message);
    }

    private String loadFile(String fileName, String encoding) {
        String result = "";
        try {
            BufferedReader fr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), encoding));
            String inLine = fr.readLine();
            while (inLine != null) {
                result = String.valueOf(result) + inLine + "\n";
                inLine = fr.readLine();
            }
            fr.close();
        }
        catch (Exception e) {
            this.reportError(e);
        }
        return result;
    }

    private void reportError(Exception e) {
        if (this.debug.equals("stacktrace")) {
            e.printStackTrace();
        } else {
            System.out.println(e);
        }
    }
}

