/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.util;

import java.util.ArrayList;
import jp.wda.gpss.util.Finder;
import jp.wda.gpss.util.FinderCreatingException;

public class FinderConditionInterpreter {
    private static final ArrayList CONNECTORS = new ArrayList();
    private static final ArrayList EQUALS;

    static {
        CONNECTORS.add("&");
        CONNECTORS.add("|");
        EQUALS = new ArrayList();
        EQUALS.add("==");
        EQUALS.add("!=");
    }

    public static Finder interpret(Finder ret, String connector, String condition) throws FinderCreatingException {
        if (ret == null || condition == null || condition.length() == 0) {
            return ret;
        }
        if ((condition = condition.trim()).charAt(0) == '(') {
            return FinderConditionInterpreter.setGroup(ret, connector, condition);
        }
        return FinderConditionInterpreter.next(ret, FinderConditionInterpreter.setCondition(ret, connector, condition), 0);
    }

    private static String setCondition(Finder ret, String connector, String condition) throws FinderCreatingException {
        if (condition == null || condition.length() == 0) {
            throw new FinderCreatingException("\u8ffd\u52a0\u3059\u308b\u6761\u4ef6\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002:" + condition);
        }
        if (connector == null) {
            connector = "&";
        }
        if (!connector.equals("&") && !connector.equals("|")) {
            throw new FinderCreatingException("\u63a5\u7d9a\u8a5e\u306b\u306f\"&\"\u307e\u305f\u306f\"|\"\u4ee5\u5916\u306e\u6587\u5b57\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002:" + connector);
        }
        int eqidx = FinderConditionInterpreter.getNextDelimiter(condition, 0, EQUALS);
        if (eqidx < 0) {
            throw new FinderCreatingException("\u7b49\u53f7\"==\"\u307e\u305f\u306f\u4e0d\u7b49\u53f7\"!=\"\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002:" + condition);
        }
        boolean not = condition.charAt(eqidx) == '=';
        String column = condition.substring(0, eqidx).trim();
        condition = condition.substring(eqidx + 2).trim();
        String value = null;
        if (condition.indexOf("null") == 0) {
            value = null;
            condition = condition.substring(4);
        } else {
            if (condition.charAt(0) != '\"') {
                throw new FinderCreatingException("null\u4ee5\u5916\u306e\u5024\u3092\u691c\u7d22\u3057\u305f\u3044\u5834\u5408\u306f\u3001\u691c\u7d22\u5024\u3092\"\"\u3067\u62ec\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002:" + condition);
            }
            int quot = condition.indexOf(34, 1);
            if (quot < 0) {
                throw new FinderCreatingException("\u691c\u7d22\u5024\u306e\u7d42\u308f\u308a\u304c\u3042\u308a\u307e\u305b\u3093\u3002:" + condition);
            }
            value = condition.substring(1, quot);
            value = value.replaceAll("&quot;", "\"");
            condition = condition.substring(quot + 1).trim();
        }
        ret.setNextFinder("&".equals(connector), not, column, value);
        return condition;
    }

    private static Finder setGroup(Finder ret, String connector, String condition) throws FinderCreatingException {
        int lst = FinderConditionInterpreter.lastIndexOfParen(condition);
        ret.addGroup("&".equals(connector), FinderConditionInterpreter.interpret(ret.createNewFinder(), "&", condition.substring(1, lst)));
        if (lst >= condition.length() - 1) {
            return ret;
        }
        return FinderConditionInterpreter.next(ret, condition, lst + 1);
    }

    private static int lastIndexOfParen(String condition) throws FinderCreatingException {
        int counter = 0;
        int i = 1;
        while (i < condition.length()) {
            if (condition.charAt(i) == '(') {
                ++counter;
            } else if (condition.charAt(i) == ')') {
                if (counter == 0) {
                    return i;
                }
                --counter;
            }
            ++i;
        }
        throw new FinderCreatingException("()\u304c\u9589\u3058\u3066\u3044\u307e\u305b\u3093\u3002:" + condition);
    }

    private static Finder next(Finder ret, String condition, int start) throws FinderCreatingException {
        int idx = FinderConditionInterpreter.getNextDelimiter(condition, start, CONNECTORS);
        if (idx < 0) {
            return ret;
        }
        String connector = condition.substring(idx, idx + 1);
        condition = condition.substring(idx + 1).trim();
        return FinderConditionInterpreter.interpret(ret, connector, condition);
    }

    private static int getNextDelimiter(String condition, int start, ArrayList delimiters) {
        int idxQ = condition.indexOf(34, start);
        int stidx = -1;
        if (idxQ >= 0) {
            stidx = condition.indexOf(34, idxQ + 1);
        }
        int idx = condition.indexOf((String)delimiters.get(0), start);
        if (idxQ >= 0 && idxQ < idx) {
            idx = condition.indexOf((String)delimiters.get(0), stidx);
        }
        int i = 1;
        while (i < delimiters.size()) {
            int idx2 = condition.indexOf((String)delimiters.get(i), start);
            if (idxQ >= 0 && idxQ < idx2) {
                idx2 = condition.indexOf((String)delimiters.get(i), stidx);
            }
            if (idx < 0 || idx2 >= 0 && idx2 < idx) {
                idx = idx2;
            }
            ++i;
        }
        return idx;
    }

    private FinderConditionInterpreter() {
    }
}

