/*
 * Decompiled with CFR 0.152.
 */
package FESI.ClassFile;

import FESI.ClassFile.ClassFile;
import java.io.DataOutputStream;
import java.io.IOException;

abstract class ConstantPoolEntry {
    static final byte CONSTANT_UTF8 = 1;
    static final byte CONSTANT_UNICODE = 2;
    static final byte CONSTANT_INTEGER = 3;
    static final byte CONSTANT_FLOAT = 4;
    static final byte CONSTANT_LONG = 5;
    static final byte CONSTANT_DOUBLE = 6;
    static final byte CONSTANT_CLASS = 7;
    static final byte CONSTANT_STRING = 8;
    static final byte CONSTANT_FIELDREF = 9;
    static final byte CONSTANT_METHODREF = 10;
    static final byte CONSTANT_INTERFACEMETHODREF = 11;
    static final byte CONSTANT_NAMEANDTYPE = 12;
    private byte tag;
    private ClassFile classFile;
    private short index = (short)-1;

    ConstantPoolEntry(byte by, ClassFile classFile) {
        this.tag = by;
        this.classFile = classFile;
    }

    byte getTag() {
        return this.tag;
    }

    short getConstantPoolIndex() {
        if (this.index == -1) {
            this.index = this.classFile.addConstantPoolEntry(this);
        }
        return this.index;
    }

    ClassFile getClassFile() {
        return this.classFile;
    }

    abstract void write(DataOutputStream var1) throws IOException;

    public abstract boolean equals(Object var1);

    protected void addToConstantPool() {
        if (this.index == -1) {
            this.index = this.classFile.addConstantPoolEntry(this);
        }
    }

    protected static boolean debug() {
        return ClassFile.debug();
    }
}

