/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ESBoolean;
import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.Evaluator;

class BooleanPrototype
extends ESObject {
    protected ESBoolean value = ESBoolean.makeBoolean(false);

    BooleanPrototype(ESObject eSObject, Evaluator evaluator) {
        super(eSObject, evaluator);
    }

    public String getESClassName() {
        return "Boolean";
    }

    public String toString(Evaluator evaluator) throws EcmaScriptException {
        return this.value.toString();
    }

    public double doubleValue() throws EcmaScriptException {
        return this.value.doubleValue();
    }

    public ESValue toESBoolean() throws EcmaScriptException {
        return this.value;
    }

    public boolean booleanValue() {
        return this.value.booleanValue();
    }

    public Object toJavaObject() {
        return new Boolean(this.value.booleanValue());
    }

    public String toDetailString() {
        return "ES:[Object: builtin " + this.getClass().getName() + ":" + (this.value == null ? "null" : this.value.toString()) + "]";
    }

    public boolean isBooleanValue() {
        return true;
    }
}

