/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.AST.ASTFormalParameterList;
import FESI.AST.ASTStatementList;
import FESI.AST.EcmaScriptTreeConstants;
import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ConstructedFunctionObject;
import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.EcmaScriptParseException;
import FESI.Interpreter.EcmaScriptVariableVisitor;
import FESI.Interpreter.EvaluationSource;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.FunctionEvaluationSource;
import FESI.Interpreter.StringEvaluationSource;
import FESI.Parser.EcmaScript;
import FESI.Parser.ParseException;
import java.io.StringReader;
import java.util.Vector;

public class FunctionObject
extends BuiltinFunctionObject
implements EcmaScriptTreeConstants {
    static boolean debugParse;

    FunctionObject(ESObject eSObject, Evaluator evaluator) {
        super(eSObject, evaluator, "Function", 1);
    }

    public String getESClassName() {
        return "Function";
    }

    public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
        return this.doConstruct(eSObject, eSValueArray);
    }

    public ESObject doConstruct(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
        EcmaScript ecmaScript;
        StringReader stringReader;
        String string;
        this.evaluator.getFunctionPrototype();
        ConstructedFunctionObject constructedFunctionObject = null;
        ASTFormalParameterList aSTFormalParameterList = null;
        ASTStatementList aSTStatementList = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = eSValueArray.length;
        int n2 = 0;
        while (n2 < n - 1) {
            if (n2 > 0) {
                stringBuffer.append(",");
            }
            string = eSValueArray[n2].toString();
            stringBuffer.append(string);
            ++n2;
        }
        string = eSValueArray[n2].toString();
        String string2 = stringBuffer.toString().trim();
        String string3 = "function anonymous (" + string2 + ") {" + string.toString() + "}";
        if (string2.length() == 0) {
            aSTFormalParameterList = new ASTFormalParameterList(33);
        } else {
            stringReader = new StringReader(string2);
            ecmaScript = new EcmaScript(stringReader);
            try {
                aSTFormalParameterList = (ASTFormalParameterList)ecmaScript.FormalParameterList();
                stringReader.close();
            }
            catch (ParseException parseException) {
                if (debugParse) {
                    System.out.println("[[PARSING ERROR DETECTED: (debugParse true)]]");
                    System.out.println(parseException.getMessage());
                    System.out.println("[[BY ROUTINE:]]");
                    parseException.printStackTrace();
                    System.out.println();
                }
                throw new EcmaScriptParseException(parseException, new StringEvaluationSource(string3, null));
            }
        }
        stringReader = new StringReader(string.toString());
        ecmaScript = new EcmaScript(stringReader);
        try {
            aSTStatementList = (ASTStatementList)ecmaScript.StatementList();
            stringReader.close();
        }
        catch (ParseException parseException) {
            if (debugParse) {
                System.out.println("[[PARSING ERROR DETECTED: (debugParse true)]]");
                System.out.println(parseException.getMessage());
                System.out.println("[[BY ROUTINE:]]");
                parseException.printStackTrace();
                System.out.println();
            }
            throw new EcmaScriptParseException(parseException, new StringEvaluationSource(string3, null));
        }
        FunctionEvaluationSource functionEvaluationSource = new FunctionEvaluationSource(new StringEvaluationSource(string3, null), "<anonymous function>");
        EcmaScriptVariableVisitor ecmaScriptVariableVisitor = this.evaluator.getVarDeclarationVisitor();
        Vector vector = ecmaScriptVariableVisitor.processVariableDeclarations(aSTStatementList, (EvaluationSource)functionEvaluationSource);
        constructedFunctionObject = ConstructedFunctionObject.makeNewConstructedFunction(this.evaluator, "anonymous", functionEvaluationSource, string3, aSTFormalParameterList.getArguments(), vector, aSTStatementList);
        return constructedFunctionObject;
    }

    public String toString() {
        return "<Function>";
    }
}

