/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESBoolean;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.GlobalObject;
import FESI.Data.ObjectObject;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.EcmaScriptParseException;
import FESI.Extensions.BasicIOInterface;
import FESI.Extensions.Extension;
import FESI.Interpreter.Evaluator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class BasicIO
extends Extension
implements BasicIOInterface {
    private Evaluator evaluator;
    private ESObject document;
    private ESObject window;

    public ESObject getDocument() {
        return this.document;
    }

    public void initializeExtension(Evaluator evaluator) throws EcmaScriptException {
        this.evaluator = evaluator;
        GlobalObject globalObject = evaluator.getGlobalObject();
        this.document = ObjectObject.createObject(evaluator);
        this.window = ObjectObject.createObject(evaluator);
        FunctionPrototype functionPrototype = (FunctionPrototype)evaluator.getFunctionPrototype();
        globalObject.putHiddenProperty("document", this.document);
        this.document.putHiddenProperty("write", new GlobalObjectWrite("write", evaluator, functionPrototype));
        this.document.putHiddenProperty("writeln", new GlobalObjectWriteln("writeln", evaluator, functionPrototype));
        this.document.putHiddenProperty("open", new GlobalObjectNoop("open", evaluator, functionPrototype));
        this.document.putHiddenProperty("close", new GlobalObjectNoop("close", evaluator, functionPrototype));
        this.document.putHiddenProperty("URL", new ESString("file://<unknown>"));
        globalObject.putHiddenProperty("window", this.window);
        this.window.putHiddenProperty("alert", new GlobalObjectAlert("alert", evaluator, functionPrototype));
        this.window.putHiddenProperty("prompt", new GlobalObjectPrompt("prompt", evaluator, functionPrototype));
        this.window.putHiddenProperty("confirm", new GlobalObjectConfirm("confirm", evaluator, functionPrototype));
        globalObject.putHiddenProperty("write", new GlobalObjectWrite("write", evaluator, functionPrototype));
        globalObject.putHiddenProperty("writeln", new GlobalObjectWriteln("writeln", evaluator, functionPrototype));
        globalObject.putHiddenProperty("alert", new GlobalObjectAlert("alert", evaluator, functionPrototype));
        globalObject.putHiddenProperty("prompt", new GlobalObjectPrompt("prompt", evaluator, functionPrototype));
        globalObject.putHiddenProperty("confirm", new GlobalObjectConfirm("confirm", evaluator, functionPrototype));
        globalObject.putHiddenProperty("exit", new GlobalObjectExit("exit", evaluator, functionPrototype));
        globalObject.putHiddenProperty("load", new GlobalObjectLoad("load", evaluator, functionPrototype));
    }

    class GlobalObjectWrite
    extends BuiltinFunctionObject {
        GlobalObjectWrite(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            BasicIO.this = BasicIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            int n = 0;
            while (n < eSValueArray.length) {
                System.out.print(eSValueArray[n].toString());
                ++n;
            }
            return ESUndefined.theUndefined;
        }
    }

    class GlobalObjectWriteln
    extends BuiltinFunctionObject {
        GlobalObjectWriteln(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            BasicIO.this = BasicIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            int n = 0;
            while (n < eSValueArray.length) {
                System.out.print(eSValueArray[n].toString());
                ++n;
            }
            System.out.println();
            return ESUndefined.theUndefined;
        }
    }

    class GlobalObjectAlert
    extends BuiltinFunctionObject {
        GlobalObjectAlert(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            BasicIO.this = BasicIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            System.err.print("[[ALERT]] ");
            int n = 0;
            while (n < eSValueArray.length) {
                System.err.print(eSValueArray[n].toString());
                ++n;
            }
            System.err.println();
            return ESUndefined.theUndefined;
        }
    }

    class GlobalObjectPrompt
    extends BuiltinFunctionObject {
        GlobalObjectPrompt(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 2);
            BasicIO.this = BasicIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            String string = "";
            String string2 = "?";
            if (eSValueArray.length > 0) {
                string2 = eSValueArray[0].toString();
            }
            if (eSValueArray.length > 1) {
                string = eSValueArray[1].toString();
            }
            System.out.print(String.valueOf(string2) + " [" + string + "] ? ");
            System.out.flush();
            String string3 = null;
            try {
                string3 = new BufferedReader(new InputStreamReader(System.in)).readLine();
            }
            catch (IOException iOException) {}
            if (string3 == null || string3.equals("")) {
                string3 = string;
            }
            return new ESString(string3);
        }
    }

    class GlobalObjectConfirm
    extends BuiltinFunctionObject {
        GlobalObjectConfirm(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 2);
            BasicIO.this = BasicIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            String string = "?";
            if (eSValueArray.length > 0) {
                string = eSValueArray[0].toString();
            }
            System.out.print(String.valueOf(string) + " [y/n] ? ");
            System.out.flush();
            String string2 = null;
            try {
                string2 = new BufferedReader(new InputStreamReader(System.in)).readLine();
            }
            catch (IOException iOException) {}
            if (string2 != null & string2.trim().toLowerCase().startsWith("y")) {
                return ESBoolean.makeBoolean(true);
            }
            return ESBoolean.makeBoolean(false);
        }
    }

    class GlobalObjectExit
    extends BuiltinFunctionObject {
        GlobalObjectExit(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            BasicIO.this = BasicIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            int n = 0;
            if (eSValueArray.length > 0) {
                n = eSValueArray[0].toInt32();
            }
            System.exit(n);
            return null;
        }
    }

    class GlobalObjectNoop
    extends BuiltinFunctionObject {
        GlobalObjectNoop(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            BasicIO.this = BasicIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            return ESUndefined.theUndefined;
        }
    }

    class GlobalObjectLoad
    extends BuiltinFunctionObject {
        GlobalObjectLoad(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            BasicIO.this = BasicIO.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESValue eSValue;
            String string = null;
            if (eSValueArray.length > 0) {
                string = eSValueArray[0].toString();
            }
            if (string == null) {
                throw new EcmaScriptException("Missing file name for load");
            }
            new File(string);
            try {
                eSValue = this.evaluator.evaluateLoadModule(string);
            }
            catch (EcmaScriptParseException ecmaScriptParseException) {
                ecmaScriptParseException.setNeverIncomplete();
                throw ecmaScriptParseException;
            }
            return eSValue;
        }
    }
}

