/*
 * Decompiled with CFR 0.152.
 */
package FESI.Interpreter;

import FESI.Data.ArrayPrototype;
import FESI.Data.ESLoader;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.ESWrapper;
import FESI.Data.GlobalObject;
import FESI.Data.ValueDescription;
import FESI.Exceptions.EcmaScriptException;
import FESI.Extensions.BasicIOInterface;
import FESI.Interpreter.Command;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.FileEvaluationSource;
import FESI.gui.Console;
import FESI.gui.GuiFactory;
import FESI.gui.InterpreterCommands;
import FESI.gui.MessageBox;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class Interpret
implements InterpreterCommands {
    protected static final InputStream originalIn = System.in;
    protected static final PrintStream originalOut = System.out;
    protected static final PrintStream originalErr = System.err;
    protected InputStream inputStream = System.in;
    protected PrintStream printStream = System.out;
    protected PrintStream errorStream = System.err;
    private boolean versionPrinted = false;
    protected boolean interactive = false;
    protected boolean windowOnly = false;
    protected boolean isAWT = true;
    protected boolean anyError = false;
    protected boolean anyMainTest = false;
    private static String eol = System.getProperty("line.separator", "\n");
    protected ESObject document;
    protected Evaluator evaluator = new Evaluator();
    protected DataInputStream lineReader;
    protected GuiFactory guiFactory;
    protected Console console;
    protected ESValue lastResult;
    protected long timeOfEval;
    protected long startTime;
    protected ESValue theValue = ESUndefined.theUndefined;
    protected String[] esArgs = new String[0];

    public Interpret() {
        this.setupCommands();
    }

    protected void errorExit() {
        System.exit(1);
    }

    public void exit() {
        System.exit(this.anyError ? 1 : 0);
    }

    void clearLastResult() {
        this.lastResult = null;
    }

    protected void loadCommonExtensions() {
        try {
            this.evaluator.addMandatoryExtension("FESI.Extensions.JavaAccess");
        }
        catch (EcmaScriptException ecmaScriptException) {
            this.errorStream.println("Cannot initialize JavaAccess - exiting: " + eol + ecmaScriptException);
            ecmaScriptException.printStackTrace();
            this.errorExit();
        }
        try {
            this.evaluator.addMandatoryExtension("FESI.Extensions.Database");
        }
        catch (EcmaScriptException ecmaScriptException) {
            this.errorStream.println("Cannot initialize Database - exiting: " + eol + ecmaScriptException);
            ecmaScriptException.printStackTrace();
            this.errorExit();
        }
        try {
            this.evaluator.addMandatoryExtension("FESI.Extensions.OptionalRegExp");
            return;
        }
        catch (EcmaScriptException ecmaScriptException) {
            this.errorStream.println("Cannot initialize OptionalRegExp - exiting: " + eol + ecmaScriptException);
            ecmaScriptException.printStackTrace();
            this.errorExit();
            return;
        }
    }

    protected void reset() throws EcmaScriptException {
        BasicIOInterface basicIOInterface;
        if (this.windowOnly && this.console != null) {
            if (this.isAWT) {
                System.setIn(originalIn);
                System.setOut(originalOut);
                System.setErr(originalErr);
                this.inputStream = originalIn;
                this.printStream = originalOut;
                this.errorStream = originalErr;
                this.console.dispose();
                this.console = null;
            } else {
                this.console.clear();
            }
        }
        this.evaluator.reset();
        if (this.windowOnly && this.isAWT) {
            basicIOInterface = null;
            try {
                basicIOInterface = (BasicIOInterface)this.evaluator.addMandatoryExtension("FESI.Extensions.BasicIOw");
            }
            catch (EcmaScriptException ecmaScriptException) {
                this.errorStream.println("Cannot initialize BasicIOw - exiting: " + eol + ecmaScriptException);
                ecmaScriptException.printStackTrace();
                this.errorExit();
            }
            this.document = basicIOInterface.getDocument();
        } else if (this.windowOnly && !this.isAWT) {
            basicIOInterface = null;
            try {
                basicIOInterface = (BasicIOInterface)this.evaluator.addMandatoryExtension("FESI.Extensions.BasicIOs");
            }
            catch (EcmaScriptException ecmaScriptException) {
                this.errorStream.println("Cannot initialize BasicIOs - exiting: " + eol + ecmaScriptException);
                ecmaScriptException.printStackTrace();
                this.errorExit();
            }
            this.document = basicIOInterface.getDocument();
        } else {
            basicIOInterface = null;
            try {
                basicIOInterface = (BasicIOInterface)this.evaluator.addMandatoryExtension("FESI.Extensions.BasicIO");
            }
            catch (EcmaScriptException ecmaScriptException) {
                this.errorStream.println("Cannot initialize BasicIO - exiting: " + eol + ecmaScriptException);
                ecmaScriptException.printStackTrace();
                this.errorExit();
            }
            this.document = basicIOInterface.getDocument();
        }
        this.loadCommonExtensions();
        if (this.windowOnly && this.interactive) {
            if (this.console == null) {
                try {
                    this.guiFactory = this.isAWT ? (GuiFactory)Class.forName("FESI.awtgui.AwtGuiFactory").newInstance() : (GuiFactory)Class.forName("FESI.swinggui.SwingGuiFactory").newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.errorStream.println("Cannot load GUI - exiting: " + eol + classNotFoundException);
                    classNotFoundException.printStackTrace();
                    this.errorExit();
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.errorStream.println("Cannot load GUI - exiting: " + eol + illegalAccessException);
                    illegalAccessException.printStackTrace();
                    this.errorExit();
                }
                catch (InstantiationException instantiationException) {
                    this.errorStream.println("Cannot load GUI - exiting: " + eol + instantiationException);
                    instantiationException.printStackTrace();
                    this.errorExit();
                }
            }
            this.console = this.guiFactory.makeConsole(this, this.getTitle(), 25, 80);
            this.inputStream = this.console.getConsoleIn();
            this.printStream = this.console.getConsoleOut();
            this.errorStream = this.console.getConsoleOut();
            this.lineReader = new DataInputStream(this.inputStream);
            System.setIn(this.inputStream);
            System.setOut(this.printStream);
            System.setErr(this.errorStream);
        } else if (this.interactive) {
            this.lineReader = new DataInputStream(this.inputStream);
        }
        try {
            this.evaluator.addMandatoryExtension("FESI.Extensions.FileIO");
        }
        catch (EcmaScriptException ecmaScriptException) {
            this.errorStream.println("Cannot initialize FileIO - exiting: " + eol + ecmaScriptException);
            ecmaScriptException.printStackTrace();
            this.errorExit();
        }
        if (this.interactive) {
            this.printVersion();
        }
    }

    protected void printVersion() {
        this.printStream.println(Evaluator.getWelcomeText());
        this.versionPrinted = true;
    }

    public void displayAboutText() {
        this.printAbout();
    }

    protected String getTitle() {
        return "FESI - EcmaScript interpreter";
    }

    protected void printAbout() {
        this.printVersion();
        this.printStream.println();
        this.printStream.println("Provided 'as is', use at your own risk, no support available.");
        this.printStream.println("Can be freely used and redistributed as long as this notice is included.");
        this.printStream.println("Feedback may be sent to 'jmlugrin@worldcom.ch', but I may not");
        this.printStream.println("be able (or willing) to answer all mails.");
    }

    protected void finalMessage(String string) {
        if (this.windowOnly && this.guiFactory != null) {
            MessageBox messageBox = this.guiFactory.displayMessageBox("FESI Error", string);
            messageBox.waitOK();
            return;
        }
        this.errorStream.println(string);
    }

    protected void usage() {
        this.errorStream.println("usage: fesi [-waivD] [-e ext] [-T file] [-h file] [-f file] [-m module] [-o outfile] file -A ...");
        this.errorStream.println("      -w  Use message box for alert and AWT GUI if interactive");
        this.errorStream.println("      -s  As -w, but use Swing instead of AWT");
        this.errorStream.println("      -i  Start interactive read-eval-print loop");
        this.errorStream.println("      -v  display version even if not interactive");
        this.errorStream.println("      -e ext   Load the extension class ext");
        this.errorStream.println("      -T file   Process an estest file, exit 1 if any failure");
        this.errorStream.println("      -h file   Expand the script in an html file");
        this.errorStream.println("      -D  turnon all debug flags");
        this.errorStream.println("      -f file   Load and execute the specified file");
        this.errorStream.println("      -m module Load and execute the specified module from FESI.path");
        this.errorStream.println("      -o file   Redirect standard output to that file");
        this.errorStream.println("      file  Load file in editor or interpret it");
        this.errorStream.println("      --  Standard input to load (loaded last if not present)");
        this.errorStream.println("      -A...  Remaining arguments are for EcmaScript args[]");
        this.errorStream.println("  By default silently interprets stdin");
        this.errorStream.println();
    }

    public void doWork(String[] stringArray) {
        char c;
        int n;
        boolean bl = false;
        int n2 = 0;
        block17: while (n2 < stringArray.length) {
            String string = stringArray[n2];
            if (string.startsWith("-")) {
                int n3 = 1;
                while (n3 < string.length()) {
                    n = string.charAt(n3);
                    if (n == 105) {
                        this.interactive = true;
                    } else if (n == 119) {
                        this.windowOnly = true;
                    } else if (n == 115) {
                        this.windowOnly = true;
                        this.isAWT = false;
                    } else if (n == 65) break block17;
                    ++n3;
                }
            }
            ++n2;
        }
        try {
            this.reset();
        }
        catch (EcmaScriptException ecmaScriptException) {
            this.errorStream.println("[[Error during initialization: " + ecmaScriptException.getMessage() + "]]");
            ecmaScriptException.printStackTrace();
            return;
        }
        int n4 = 0;
        block19: while (n4 < stringArray.length) {
            String string = stringArray[n4];
            if (string.startsWith("-") && !string.equals("--")) {
                n = 1;
                while (n < string.length()) {
                    c = string.charAt(n);
                    if (c == 'o') {
                        if (n < string.length() - 1) {
                            if (!this.windowOnly) {
                                this.usage();
                            }
                            this.finalMessage("-o must be last option in '-' string");
                            if (this.interactive) {
                                this.errorExit();
                            }
                            return;
                        }
                        if (n4 < stringArray.length) {
                            String string2 = stringArray[++n4];
                            File file = new File(string2);
                            try {
                                this.printStream = new PrintStream(new FileOutputStream(file));
                                System.setOut(this.printStream);
                                break;
                            }
                            catch (IOException iOException) {
                                this.finalMessage("[[IO Error creating output file' " + string2 + "']]" + eol + "[[IO Error: " + iOException.getMessage() + "]]");
                                if (this.interactive) {
                                    this.errorExit();
                                }
                                return;
                            }
                        }
                        if (!this.windowOnly) {
                            this.usage();
                        }
                        this.finalMessage("-o requires a file parameter");
                        if (this.interactive) {
                            this.errorExit();
                        }
                        return;
                    }
                    if (c != 'i') {
                        if (c == 'D') {
                            ESLoader.setDebugJavaAccess(true);
                            ESLoader.setDebugLoader(true);
                            ESWrapper.setDebugEvent(true);
                            this.evaluator.setDebugParse(true);
                        } else if (c == 'v') {
                            if (!this.versionPrinted) {
                                this.printVersion();
                            }
                        } else if (c != 'w' && c != 's') {
                            if (c == 'e') {
                                if (n < string.length() - 1) {
                                    if (!this.windowOnly) {
                                        this.usage();
                                    }
                                    this.finalMessage("-e must be last option in '-' string");
                                    if (this.interactive) {
                                        this.errorExit();
                                    }
                                    return;
                                }
                                if (n4 + 1 >= stringArray.length) {
                                    if (!this.windowOnly) {
                                        this.usage();
                                    }
                                    this.finalMessage("-e requires a file parameter");
                                    if (this.interactive) {
                                        this.errorExit();
                                    }
                                    return;
                                }
                                ++n4;
                                break;
                            }
                            if (c == 'T') {
                                if (n < string.length() - 1) {
                                    if (!this.windowOnly) {
                                        this.usage();
                                    }
                                    this.finalMessage("-T must be last option in '-' string");
                                    if (this.interactive) {
                                        this.errorExit();
                                    }
                                    return;
                                }
                                if (n4 + 1 >= stringArray.length) {
                                    if (!this.windowOnly) {
                                        this.usage();
                                    }
                                    this.finalMessage("-T requires a file parameter");
                                    if (this.interactive) {
                                        this.errorExit();
                                    }
                                    return;
                                }
                                ++n4;
                                break;
                            }
                            if (c == 'f') {
                                if (n < string.length() - 1) {
                                    if (!this.windowOnly) {
                                        this.usage();
                                    }
                                    this.finalMessage("-f must be last option in '-' string");
                                    if (this.interactive) {
                                        this.errorExit();
                                    }
                                    return;
                                }
                                if (n4 + 1 >= stringArray.length) {
                                    if (!this.windowOnly) {
                                        this.usage();
                                    }
                                    this.finalMessage("-f requires a file parameter");
                                    if (this.interactive) {
                                        this.errorExit();
                                    }
                                    return;
                                }
                                ++n4;
                                break;
                            }
                            if (c == 'm') {
                                if (n < string.length() - 1) {
                                    if (!this.windowOnly) {
                                        this.usage();
                                    }
                                    this.finalMessage("-m must be last option in '-' string");
                                    if (this.interactive) {
                                        this.errorExit();
                                    }
                                    return;
                                }
                                if (n4 + 1 >= stringArray.length) {
                                    if (!this.windowOnly) {
                                        this.usage();
                                    }
                                    this.finalMessage("-m requires a file parameter");
                                    if (this.interactive) {
                                        this.errorExit();
                                    }
                                    return;
                                }
                                ++n4;
                                break;
                            }
                            if (c == 'h') {
                                if (n < string.length() - 1) {
                                    if (!this.windowOnly) {
                                        this.usage();
                                    }
                                    this.finalMessage("-h must be last option in '-' string");
                                    if (this.interactive) {
                                        this.errorExit();
                                    }
                                    return;
                                }
                                if (n4 + 1 >= stringArray.length) {
                                    if (!this.windowOnly) {
                                        this.usage();
                                    }
                                    this.finalMessage("-h requires a file parameter");
                                    if (this.interactive) {
                                        this.errorExit();
                                    }
                                    return;
                                }
                                ++n4;
                                break;
                            }
                            if (c == 'A') {
                                if (n < string.length() - 1) {
                                    if (!this.windowOnly) {
                                        this.usage();
                                    }
                                    this.finalMessage("-A must be last option in '-' string");
                                    if (this.interactive) {
                                        this.errorExit();
                                    }
                                    return;
                                }
                                int n5 = stringArray.length - ++n4;
                                this.esArgs = new String[n5];
                                int n6 = 0;
                                while (n4 < stringArray.length) {
                                    this.esArgs[n6] = stringArray[n4];
                                    ++n4;
                                    ++n6;
                                }
                                break block19;
                            }
                            if (!this.windowOnly) {
                                this.usage();
                            }
                            this.finalMessage("Unrecognize option '" + c + "' on command line");
                            if (this.interactive) {
                                this.errorExit();
                            }
                            return;
                        }
                    }
                    ++n;
                }
            }
            ++n4;
        }
        try {
            ESObject eSObject = this.evaluator.getArrayPrototype();
            ArrayPrototype arrayPrototype = new ArrayPrototype(eSObject, this.evaluator);
            c = '\u0000';
            while (c < this.esArgs.length) {
                arrayPrototype.putProperty(c, new ESString(this.esArgs[c]));
                ++c;
            }
            GlobalObject globalObject = this.evaluator.getGlobalObject();
            String string = "args".intern();
            globalObject.putProperty(string, arrayPrototype, string.hashCode());
        }
        catch (EcmaScriptException ecmaScriptException) {}
        int n7 = 0;
        block23: while (n7 < stringArray.length) {
            String string = stringArray[n7];
            if (string.startsWith("-") && !stringArray.equals("--")) {
                int n8 = 1;
                while (n8 < string.length()) {
                    char c2 = string.charAt(n8);
                    if (c2 != 'i' && c2 != 'v' && c2 != 'w' && c2 != 's' && c2 != 'D') {
                        if (c2 == 'o') {
                            ++n7;
                        } else {
                            String string3;
                            if (c2 == 'T') {
                                string3 = stringArray[++n7];
                                bl = true;
                                this.doTest(string3);
                                this.anyMainTest = true;
                                break;
                            }
                            if (c2 == 'e') {
                                String string4 = stringArray[++n7];
                                try {
                                    this.evaluator.addMandatoryExtension(string4);
                                }
                                catch (EcmaScriptException ecmaScriptException) {
                                    this.errorStream.println("Cannot load extension extensionName - exiting: " + eol + ecmaScriptException);
                                    this.errorExit();
                                }
                                break;
                            }
                            if (c2 == 'f') {
                                string3 = stringArray[++n7];
                                bl = true;
                                this.doLoadFile(string3);
                                break;
                            }
                            if (c2 == 'm') {
                                string3 = stringArray[++n7];
                                bl = true;
                                this.doLoad(string3);
                                break;
                            }
                            if (c2 == 'h') {
                                string3 = stringArray[++n7];
                                bl = true;
                                this.doExpand(string3);
                                break;
                            }
                            if (c2 == 'A') break block23;
                        }
                    }
                    ++n8;
                }
            } else {
                String string5 = stringArray[n7];
                if (string5.equals("--")) {
                    if (this.interactive) {
                        this.errorStream.println("Argument '--' not allowed in interactive mode");
                        this.errorExit();
                    } else {
                        bl = true;
                        try {
                            this.evaluator.evaluate(new BufferedReader(new InputStreamReader(System.in)), null, new FileEvaluationSource("<System.in>", null), false);
                        }
                        catch (EcmaScriptException ecmaScriptException) {
                            this.finalMessage(String.valueOf(ecmaScriptException.getMessage()) + eol + "[[Error loading file '" + string5 + "']]");
                            if (this.interactive) {
                                this.errorExit();
                            }
                            return;
                        }
                    }
                } else if (this.interactive && this.console.supportsEditing()) {
                    this.console.createEditor(string5);
                } else {
                    this.doLoad(string5);
                }
            }
            ++n7;
        }
        if (this.interactive) {
            this.printStream.println("Interactive read eval print loop - type @help for a list of commands");
            try {
                this.printStream.print("> ");
                this.printStream.flush();
                String string = this.lineReader.readLine();
                while (string != null) {
                    String string6;
                    if (string.startsWith("@")) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string);
                        string6 = null;
                        String string7 = null;
                        string6 = stringTokenizer.nextToken().toLowerCase().trim();
                        if (stringTokenizer.hasMoreTokens()) {
                            string7 = stringTokenizer.nextToken().trim();
                        }
                        if (Command.executeCommand(this, this.printStream, string6, string7)) {
                            break;
                        }
                    } else if (!string.equals("")) {
                        while (true) {
                            this.lastResult = null;
                            try {
                                this.startTime = System.currentTimeMillis();
                                this.theValue = this.evaluator.evaluate(string);
                                this.timeOfEval = System.currentTimeMillis() - this.startTime;
                                this.lastResult = this.theValue;
                                if (this.theValue == null) break;
                                this.printStream.println("@@ Result: " + this.theValue.toString());
                            }
                            catch (EcmaScriptException ecmaScriptException) {
                                if (ecmaScriptException.isIncomplete()) {
                                    this.printStream.print("More> ");
                                    this.printStream.flush();
                                    string6 = this.lineReader.readLine();
                                    if (string6 != null) {
                                        if (string6.startsWith("@end")) {
                                            this.printStream.println("[[Error: " + ecmaScriptException.getMessage() + "]]");
                                            break;
                                        }
                                        if (string6.startsWith("@")) {
                                            this.printStream.println("[[Only command @end allowed when reading script end]]");
                                            this.printStream.println("[[Command and script ignored]]");
                                            break;
                                        }
                                        string = String.valueOf(string) + eol + string6;
                                        continue;
                                    }
                                }
                                this.printStream.println("[[Error: " + ecmaScriptException.getMessage() + "]]");
                            }
                            catch (Exception exception) {
                                this.printStream.println("[[**Uncatched error: " + exception + "]]");
                                exception.printStackTrace();
                            }
                            break;
                        }
                    }
                    this.printStream.print("> ");
                    this.printStream.flush();
                    string = this.lineReader.readLine();
                }
            }
            catch (IOException iOException) {
                this.errorStream.println("[[IO error reading line: " + iOException + "]]");
                this.errorExit();
            }
        } else if (!bl) {
            try {
                this.evaluator.evaluate(new BufferedReader(new InputStreamReader(System.in)), null, new FileEvaluationSource("<System.in>", null), false);
                bl = true;
            }
            catch (EcmaScriptException ecmaScriptException) {
                this.finalMessage(String.valueOf(ecmaScriptException.getMessage()) + eol + "[[Error interpreting standard input]]");
                if (this.interactive) {
                    this.errorExit();
                }
                return;
            }
        }
        if (this.interactive || this.anyMainTest) {
            this.exit();
        }
    }

    protected void doPwd() {
        String string = System.getProperty("user.dir", "");
        this.printStream.println("[[User directory: " + string + "]]");
    }

    protected void doPath() {
        String string = "FESI.path";
        String string2 = System.getProperty(string, null);
        string = "java.class.path";
        if (string2 == null) {
            string2 = System.getProperty("java.class.path", null);
        }
        if (string2 == null) {
            string = "DEFAULT";
            string2 = ".";
        }
        this.printStream.println("[[Load path (" + string + "): " + string2 + "]]");
    }

    protected void doLoad(String string) {
        if (string == null || string.equals("")) {
            this.printStream.println("[[Module name missing for @load.]]");
            return;
        }
        try {
            try {
                try {
                    this.document.putHiddenProperty("URL", new ESString("module://" + string));
                }
                catch (EcmaScriptException ecmaScriptException) {}
                this.printStream.println("@@ Loading module '" + string + "' . . .");
                this.startTime = System.currentTimeMillis();
                this.theValue = this.evaluator.evaluateLoadModule(string);
                this.timeOfEval = System.currentTimeMillis() - this.startTime;
                this.lastResult = this.theValue;
                if (this.theValue != null) {
                    this.printStream.println("@@ Resulting in: " + this.theValue);
                }
            }
            catch (EcmaScriptException ecmaScriptException) {
                this.printStream.println("[[Error loading the module '" + string + "']]");
                this.printStream.println("[[Error: " + ecmaScriptException.getMessage() + "]]");
            }
            catch (Exception exception) {
                this.printStream.println("[[**Uncatched error: " + exception + "]]");
                exception.printStackTrace();
            }
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            try {
                this.document.putHiddenProperty("URL", new ESString("module://<stdin>"));
            }
            catch (EcmaScriptException ecmaScriptException) {}
            throw throwable;
        }
        try {
            this.document.putHiddenProperty("URL", new ESString("module://<stdin>"));
        }
        catch (EcmaScriptException ecmaScriptException) {}
    }

    public void loadFile(String string, String string2) {
        File file = new File(string);
        File file2 = new File(file, string2);
        if (file2.exists()) {
            try {
                try {
                    try {
                        this.document.putHiddenProperty("URL", new ESString("file://" + file2.getCanonicalPath()));
                    }
                    catch (EcmaScriptException ecmaScriptException) {
                    }
                    catch (IOException iOException) {}
                    this.printStream.println("@@ Loading file '" + file2.getPath() + "' . . .");
                    this.theValue = this.evaluator.evaluateLoadFile(file2);
                    if (this.interactive && this.theValue != null) {
                        this.printStream.println("@@ Resulting in: " + this.theValue);
                    }
                }
                catch (EcmaScriptException ecmaScriptException) {
                    this.errorStream.println(String.valueOf(ecmaScriptException.getMessage()) + eol + "[[Error loading file' " + file2.getPath() + "']]");
                    Object var6_6 = null;
                    try {
                        this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
                    }
                    catch (EcmaScriptException ecmaScriptException2) {}
                    return;
                }
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
                }
                catch (EcmaScriptException ecmaScriptException) {}
                throw throwable;
            }
            try {
                this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
            }
            catch (EcmaScriptException ecmaScriptException) {}
            return;
        }
        this.errorStream.println("[[File " + file2.getPath() + " not found]]");
    }

    public int executeString(String string, String string2) {
        try {
            try {
                try {
                    this.document.putHiddenProperty("URL", new ESString("source://" + string2));
                }
                catch (EcmaScriptException ecmaScriptException) {}
                this.printStream.println("@@ Executing '" + string2 + "' . . .");
                this.theValue = this.evaluator.evaluate(string, string2);
                if (this.interactive && this.theValue != null) {
                    this.printStream.println("@@ Resulting in: " + this.theValue);
                }
            }
            catch (EcmaScriptException ecmaScriptException) {
                this.errorStream.println(String.valueOf(ecmaScriptException.getMessage()) + eol + "[[Error executing '" + string2 + "']]");
                int n = ecmaScriptException.getLineNumber();
                Object var5_5 = null;
                try {
                    this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
                }
                catch (EcmaScriptException ecmaScriptException2) {}
                return n;
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {
                this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
            }
            catch (EcmaScriptException ecmaScriptException) {}
            throw throwable;
        }
        try {
            this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
        }
        catch (EcmaScriptException ecmaScriptException) {}
        return 0;
    }

    protected void doLoadFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file = new File(String.valueOf(string) + ".es");
        }
        if (!file.exists()) {
            file = new File(String.valueOf(string) + ".esw");
        }
        if (!file.exists()) {
            file = new File(String.valueOf(string) + ".js");
        }
        if (file.exists()) {
            try {
                try {
                    try {
                        this.document.putHiddenProperty("URL", new ESString("file://" + file.getCanonicalPath()));
                    }
                    catch (EcmaScriptException ecmaScriptException) {
                    }
                    catch (IOException iOException) {}
                    if (this.interactive) {
                        this.printStream.println("@@ Loading file '" + file.getPath() + "' . . .");
                    }
                    this.theValue = this.evaluator.evaluateLoadFile(file);
                    if (this.interactive && this.theValue != null) {
                        this.printStream.println("@@ Resulting in: " + this.theValue);
                    }
                }
                catch (EcmaScriptException ecmaScriptException) {
                    this.finalMessage(String.valueOf(ecmaScriptException.getMessage()) + eol + "[[Error loading file' " + file.getPath() + "']]");
                    if (!this.interactive) {
                        this.errorExit();
                    }
                    Object var4_4 = null;
                    try {
                        this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
                    }
                    catch (EcmaScriptException ecmaScriptException2) {}
                    return;
                }
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
                }
                catch (EcmaScriptException ecmaScriptException) {}
                throw throwable;
            }
            try {
                this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
            }
            catch (EcmaScriptException ecmaScriptException) {}
            return;
        }
        this.finalMessage("File " + file.getPath() + " not found");
        if (this.interactive) {
            this.errorExit();
        }
    }

    protected void doExpand(String string) {
        if (string == null || string.equals("")) {
            this.errorStream.println("[[File name missing for @expand.]]");
            if (!this.interactive) {
                this.errorExit();
            }
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            file = new File(String.valueOf(string) + ".html");
        }
        if (!file.exists()) {
            file = new File(String.valueOf(string) + ".htm");
        }
        BufferedReader bufferedReader = null;
        try {
            try {
                this.document.putHiddenProperty("URL", new ESString("file://" + file.getAbsolutePath()));
                bufferedReader = new BufferedReader(new FileReader(file));
                if (this.interactive) {
                    this.printStream.println("@@ Expanding html file '" + file.getPath() + "' . . .");
                }
                boolean bl = false;
                StringBuffer stringBuffer = null;
                String string2 = bufferedReader.readLine();
                String string3 = string2.toLowerCase();
                int n = 0;
                while (string2 != null) {
                    ++n;
                    if (bl && string3.indexOf("</script>") != -1) {
                        bl = false;
                        this.evaluator.evaluate(stringBuffer.toString());
                    } else if (bl) {
                        stringBuffer.append(String.valueOf(string2) + eol);
                    } else if (string3.indexOf("<script>") != -1) {
                        bl = true;
                        stringBuffer = new StringBuffer();
                    } else {
                        this.printStream.println(string2);
                    }
                    string2 = bufferedReader.readLine();
                    String string4 = string3 = string2 == null ? null : string2.toLowerCase();
                }
                if (bl) {
                    this.errorStream.println("[[Error - end of file reached with openened <script>]]");
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.errorStream.println("[[File '" + string + "' not found.]]");
            }
            catch (EcmaScriptException ecmaScriptException) {
                this.errorStream.println("[[Error expanding the file '" + file.getPath() + "']]");
                this.errorStream.println("[[Error: " + ecmaScriptException.getMessage() + "]]");
            }
            catch (Exception exception) {
                this.errorStream.println("[[**Uncatched error: " + exception + "]]");
                exception.printStackTrace(this.errorStream);
            }
            Object var5_11 = null;
        }
        catch (Throwable throwable) {
            block28: {
                Object var5_12 = null;
                try {
                    this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
                }
                catch (EcmaScriptException ecmaScriptException) {}
                if (bufferedReader == null) break block28;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        try {
            this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
        }
        catch (EcmaScriptException ecmaScriptException) {}
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void doTest(String string) {
        int n;
        int n2;
        int n3;
        block26: {
            if (string == null || string.equals("")) {
                this.errorStream.println("[[File name missing for @test.]]");
                if (!this.interactive) {
                    this.errorExit();
                }
                return;
            }
            File file = new File(string);
            if (!file.exists()) {
                file = new File(String.valueOf(string) + ".estest");
            }
            BufferedReader bufferedReader = null;
            n3 = 0;
            n2 = 0;
            n = 0;
            try {
                try {
                    boolean bl;
                    String string2;
                    bufferedReader = new BufferedReader(new FileReader(file));
                    this.document.putHiddenProperty("URL", new ESString("file://" + file.getAbsolutePath()));
                    this.printStream.println("@@ Processing test file '" + file.getPath() + "' . . .");
                    String string3 = null;
                    StringBuffer stringBuffer = new StringBuffer();
                    String string4 = bufferedReader.readLine();
                    String string5 = string4.toLowerCase();
                    int n4 = 0;
                    while (string4 != null) {
                        ++n4;
                        if (string5.startsWith("@test")) {
                            string2 = new String(stringBuffer);
                            if (string3 != null) {
                                ++n3;
                                bl = this.testString(string3, string2, file);
                                if (bl) {
                                    ++n2;
                                } else {
                                    ++n;
                                    this.anyError = true;
                                }
                            } else {
                                this.evaluator.evaluate(string2);
                            }
                            stringBuffer = new StringBuffer();
                            string3 = string4;
                        } else {
                            stringBuffer.append(string4);
                            stringBuffer.append("\n");
                        }
                        string4 = bufferedReader.readLine();
                        String string6 = string5 = string4 == null ? null : string4.toLowerCase();
                    }
                    if (string3 != null) {
                        ++n3;
                        string2 = new String(stringBuffer);
                        bl = this.testString(string3, string2, file);
                        if (bl) {
                            ++n2;
                        } else {
                            ++n;
                            this.anyError = true;
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.errorStream.println("[[File '" + string + "' not found.]]");
                }
                catch (EcmaScriptException ecmaScriptException) {
                    this.errorStream.println("[[Error expanding the file '" + file.getPath() + "']]");
                    this.errorStream.println("[[Error: " + ecmaScriptException.getMessage() + "]]");
                }
                catch (Exception exception) {
                    this.errorStream.println("[[**Uncatched error: " + exception + "]]");
                    exception.printStackTrace(this.errorStream);
                }
                Object var8_16 = null;
                if (bufferedReader == null) break block26;
            }
            catch (Throwable throwable) {
                Object var8_17 = null;
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
                try {
                    this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
                }
                catch (EcmaScriptException ecmaScriptException) {}
                throw throwable;
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        try {
            this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
        }
        catch (EcmaScriptException ecmaScriptException) {}
        this.printStream.println("@@ " + n3 + " tests, " + n2 + " successes, " + n + " errors.");
    }

    protected boolean testString(String string, String string2, File file) {
        this.printStream.println("@@ Testing " + string);
        try {
            ESValue eSValue = this.evaluator.evaluate(string2);
            if (eSValue == null) {
                throw new EcmaScriptException("No value returned from @test");
            }
            boolean bl = false;
            try {
                bl = eSValue.booleanValue();
            }
            catch (EcmaScriptException ecmaScriptException) {
                throw new EcmaScriptException("@test did not return a boolean value");
            }
            if (!bl) {
                throw new EcmaScriptException("@test did not return 'true'");
            }
            return true;
        }
        catch (Exception exception) {
            this.printStream.println("[[Test " + string + " in file " + file.getPath() + " failed]]");
            this.printStream.println("[[Error: " + exception.getMessage() + "]]");
            return false;
        }
    }

    protected void printDetail() {
        if (this.lastResult == null) {
            this.printStream.println("** No last result available");
            return;
        }
        this.printStream.println("** Result: " + this.lastResult.toDetailString());
        this.printStream.println("** Evaluated in " + this.timeOfEval + " ms (note: +/-20 ms precision!)");
    }

    protected void toggleDebugParse() {
        this.evaluator.setDebugParse(!this.evaluator.isDebugParse());
        this.printStream.println("@@ debugParse is now: " + this.evaluator.isDebugParse());
    }

    protected void toggleDebugJavaAccess() {
        ESLoader.setDebugJavaAccess(!ESLoader.isDebugJavaAccess());
        this.printStream.println("@@ debugJavaAccess is now: " + ESLoader.isDebugJavaAccess());
    }

    protected void toggleDebugLoader() {
        ESLoader.setDebugLoader(!ESLoader.isDebugLoader());
        this.printStream.println("@@ debugLoader is now: " + ESLoader.isDebugLoader());
    }

    protected void toggleDebugEvent() {
        ESWrapper.setDebugEvent(!ESWrapper.isDebugEvent());
        this.printStream.println("@@ debugJavaAccess is now: " + ESWrapper.isDebugEvent());
    }

    protected void listExtensions() {
        int n = 0;
        Enumeration enumeration = this.evaluator.getExtensions();
        while (enumeration.hasMoreElements()) {
            this.printStream.println(" " + enumeration.nextElement());
            ++n;
        }
        this.printStream.println(" " + n + " extensions loaded");
    }

    public void displayHelpText() {
        this.printHelp();
    }

    protected void printHelp() {
        Command.printHelp(this.printStream);
    }

    protected void resetEvaluator() {
        try {
            this.printStream.println("@@ Reseting global object to default values");
            this.reset();
            return;
        }
        catch (EcmaScriptException ecmaScriptException) {
            this.errorStream.println("[[Error during initialization: " + ecmaScriptException.getMessage() + "]]");
            ecmaScriptException.printStackTrace();
            return;
        }
    }

    protected void listMemory() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        long l2 = runtime.totalMemory();
        this.printStream.println("@@ Total memory: " + l2 + ", free memory: " + l);
    }

    protected void listProperties(String string) {
        ESObject eSObject = this.evaluator.getGlobalObject();
        try {
            if (string != null) {
                ESValue eSValue = this.evaluator.evaluate(string);
                if (!(eSValue instanceof ESObject)) {
                    this.printStream.println("Cannot evaluate '" + string + "' to an object");
                    return;
                }
                eSObject = (ESObject)eSValue;
            }
            boolean bl = eSObject.isDirectEnumerator();
            Enumeration enumeration = eSObject.getProperties();
            while (enumeration.hasMoreElements()) {
                int n;
                String string2 = enumeration.nextElement().toString();
                this.printStream.print(string2);
                if (bl) continue;
                String string3 = eSObject.getProperty(string2, string2.hashCode()).toString();
                while (string3.indexOf("\n") == 0) {
                    string3 = string3.substring(1);
                }
                while (string3.indexOf(eol) == 0) {
                    string3 = string3.substring(eol.length());
                }
                if (string3.length() > 250) {
                    string3 = String.valueOf(string3.substring(0, 250)) + "...";
                }
                if ((n = string3.indexOf(eol)) == -1) {
                    n = string3.indexOf("\n");
                }
                if (n != -1) {
                    string3 = String.valueOf(string3.substring(0, n)) + "...";
                }
                this.printStream.println(": " + string3);
            }
            return;
        }
        catch (Exception exception) {
            this.printStream.println("Cannot evaluate '" + string + "' properties");
            this.printStream.println(exception);
            return;
        }
    }

    protected void listAllProperties(String string) {
        ESObject eSObject = this.evaluator.getGlobalObject();
        try {
            Object object;
            if (string != null) {
                object = this.evaluator.evaluate(string);
                if (!(object instanceof ESObject)) {
                    this.printStream.println("Cannot evaluate '" + string + "' to an object");
                    return;
                }
                eSObject = (ESObject)object;
            }
            object = eSObject.getAllProperties();
            while (object.hasMoreElements()) {
                String string2 = object.nextElement().toString();
                ESValue eSValue = eSObject.getProperty(string2, string2.hashCode());
                this.printStream.println(eSValue.getDescription(string2));
            }
            return;
        }
        catch (Exception exception) {
            this.printStream.println("Cannot evaluate '" + string + "' properties");
            this.printStream.println(exception);
            return;
        }
    }

    protected void clearConsole() {
        if (this.console != null) {
            this.console.clear();
        }
    }

    protected void describe(String string) {
        ESValue eSValue = this.evaluator.getGlobalObject();
        try {
            if (string != null) {
                eSValue = this.evaluator.evaluate(string);
            } else {
                string = "global";
            }
            this.printStream.println(eSValue.getDescription(string));
            if (eSValue.isComposite()) {
                Enumeration enumeration = eSValue.getAllDescriptions();
                while (enumeration.hasMoreElements()) {
                    ValueDescription valueDescription = (ValueDescription)enumeration.nextElement();
                    this.printStream.println("   " + valueDescription.toString());
                }
                return;
            }
        }
        catch (Exception exception) {
            this.printStream.println("Cannot evaluate '" + string + "'");
            this.printStream.println(exception);
        }
    }

    protected void setupCommands() {
        new 1("about", "display general information");
        new 2("clear", "Clear console output");
        new 3("debugEvent", "Toggle debug flag for event processing");
        new 4("debugLoader", "Toggle debug flag for dynamic loading");
        new 5("debugJavaAccess", "Toggle debug flag for java interfacing");
        new 6("debugParse", "Toggle debug flag for parsing");
        new 7("describe", "Display details on the value given as parameter");
        new 8("detail", "Display details on last result of an evaluation");
        new 9("exit", "Exit the interpreter");
        new 10("expand", "Expand between <script></script> in an .html file");
        new 11("extensions", "Display the list of loaded extensions");
        new 12("help", "Display the list of commands");
        new 13("list", "List the enumerated properties of the object");
        new 14("listAll", "List all properties of the object");
        new 15("load", "Load a .js, .es or .esw file");
        new 16("memory", "Give information on available memory");
        new 17("path", "Display the current load path");
        new 18("pwd", "Display the current user directory");
        new 19("reset", "Restore the interpreter to the initial state");
        new 20("test", "Execute a test file (.estest)");
        new 21("version", "Display the version of the interpreter");
    }

    public static void main(String[] stringArray) {
        Interpret interpret = new Interpret();
        interpret.doWork(stringArray);
    }

    private final class 1
    extends Command {
        boolean doCommand(Interpret interpret, String string) {
            interpret.printAbout();
            return false;
        }

        /* synthetic */ 1(String string, String string2) {
            super(string, string2);
        }
    }

    private final class 2
    extends Command {
        boolean doCommand(Interpret interpret, String string) {
            interpret.clearConsole();
            return false;
        }

        /* synthetic */ 2(String string, String string2) {
            super(string, string2);
        }
    }

    private final class 3
    extends Command {
        boolean doCommand(Interpret interpret, String string) {
            interpret.toggleDebugEvent();
            return false;
        }

        /* synthetic */ 3(String string, String string2) {
            super(string, string2);
        }
    }

    private final class 4
    extends Command {
        boolean doCommand(Interpret interpret, String string) {
            interpret.toggleDebugLoader();
            return false;
        }

        /* synthetic */ 4(String string, String string2) {
            super(string, string2);
        }
    }

    private final class 5
    extends Command {
        boolean doCommand(Interpret interpret, String string) {
            interpret.toggleDebugJavaAccess();
            return false;
        }

        /* synthetic */ 5(String string, String string2) {
            super(string, string2);
        }
    }

    private final class 6
    extends Command {
        boolean doCommand(Interpret interpret, String string) {
            interpret.toggleDebugParse();
            return false;
        }

        /* synthetic */ 6(String string, String string2) {
            super(string, string2);
        }
    }

    private final class 7
    extends Command {
        boolean doCommand(Interpret interpret, String string) {
            interpret.describe(string);
            return false;
        }

        /* synthetic */ 7(String string, String string2) {
            super(string, string2);
        }
    }

    private final class 8
    extends Command {
        boolean doCommand(Interpret interpret, String string) {
            interpret.printDetail();
            return false;
        }

        /* synthetic */ 8(String string, String string2) {
            super(string, string2);
        }
    }

    private final class 9
    extends Command {
        boolean doCommand(Interpret interpret, String string) {
            return true;
        }

        /* synthetic */ 9(String string, String string2) {
            super(string, string2);
        }
    }

    private final class 10
    extends Command {
        boolean doCommand(Interpret interpret, String string) {
            interpret.clearLastResult();
            interpret.doExpand(string);
            return false;
        }

        /* synthetic */ 10(String string, String string2) {
            super(string, string2);
        }
    }

    private final class 11
    extends Command {
        boolean doCommand(Interpret interpret, String string) {
            interpret.listExtensions();
            return false;
        }

        /* synthetic */ 11(String string, String string2) {
            super(string, string2);
        }
    }

    private final class 12
    extends Command {
        boolean doCommand(Interpret interpret, String string) {
            interpret.printHelp();
            return false;
        }

        /* synthetic */ 12(String string, String string2) {
            super(string, string2);
        }
    }

    private final class 13
    extends Command {
        boolean doCommand(Interpret interpret, String string) {
            interpret.listProperties(string);
            return false;
        }

        /* synthetic */ 13(String string, String string2) {
            super(string, string2);
        }
    }

    private final class 14
    extends Command {
        boolean doCommand(Interpret interpret, String string) {
            interpret.listAllProperties(string);
            return false;
        }

        /* synthetic */ 14(String string, String string2) {
            super(string, string2);
        }
    }

    private final class 15
    extends Command {
        boolean doCommand(Interpret interpret, String string) {
            interpret.clearLastResult();
            interpret.doLoad(string);
            return false;
        }

        /* synthetic */ 15(String string, String string2) {
            super(string, string2);
        }
    }

    private final class 16
    extends Command {
        boolean doCommand(Interpret interpret, String string) {
            interpret.listMemory();
            return false;
        }

        /* synthetic */ 16(String string, String string2) {
            super(string, string2);
        }
    }

    private final class 17
    extends Command {
        boolean doCommand(Interpret interpret, String string) {
            interpret.doPath();
            return false;
        }

        /* synthetic */ 17(String string, String string2) {
            super(string, string2);
        }
    }

    private final class 18
    extends Command {
        boolean doCommand(Interpret interpret, String string) {
            interpret.doPwd();
            return false;
        }

        /* synthetic */ 18(String string, String string2) {
            super(string, string2);
        }
    }

    private final class 19
    extends Command {
        boolean doCommand(Interpret interpret, String string) {
            interpret.clearLastResult();
            interpret.resetEvaluator();
            return false;
        }

        /* synthetic */ 19(String string, String string2) {
            super(string, string2);
        }
    }

    private final class 20
    extends Command {
        boolean doCommand(Interpret interpret, String string) {
            interpret.clearLastResult();
            interpret.doTest(string);
            return false;
        }

        /* synthetic */ 20(String string, String string2) {
            super(string, string2);
        }
    }

    private final class 21
    extends Command {
        boolean doCommand(Interpret interpret, String string) {
            interpret.printVersion();
            return false;
        }

        /* synthetic */ 21(String string, String string2) {
            super(string, string2);
        }
    }
}

