/*
 * Decompiled with CFR 0.152.
 */
package FESI.swinggui;

import FESI.Exceptions.ProgrammingError;
import FESI.swinggui.ExtendedConsole;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;

public class JConsoleArea
extends JTextArea {
    private int firstInputLocation = -1;
    private int lastOutputLocation = -1;
    private static Keymap fesiKeymap = null;
    protected ExtendedConsole mainConsole;

    JConsoleArea(ExtendedConsole extendedConsole, int n, int n2) {
        super(n, n2);
        this.mainConsole = extendedConsole;
        this.setFont(new Font("Monospaced", 0, 12));
        if (fesiKeymap == null) {
            Keymap keymap = JTextComponent.getKeymap("default");
            if (keymap == null) {
                throw new ProgrammingError("Could not find default keymap");
            }
            fesiKeymap = JTextComponent.addKeymap("FESIKeyMap", keymap);
            fesiKeymap.setDefaultAction(new DefaultKeyTypedAction(this));
            fesiKeymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), new ReturnKeyTypedAction(this));
            fesiKeymap.addActionForKeyStroke(KeyStroke.getKeyStroke(67, 2), new CopyAction());
            fesiKeymap.addActionForKeyStroke(KeyStroke.getKeyStroke(88, 2), new CutAction());
            fesiKeymap.addActionForKeyStroke(KeyStroke.getKeyStroke(86, 2), new PasteAction(this));
        }
        this.setKeymap(fesiKeymap);
    }

    protected void setFirstInputLocation(int n) {
        if (this.firstInputLocation == -1) {
            this.firstInputLocation = n;
        }
    }

    protected void resetFirstInputLocation() {
        this.firstInputLocation = -1;
    }

    protected int getFirstInputLocation() {
        if (this.firstInputLocation == -1 && this.lastOutputLocation != -1) {
            return this.lastOutputLocation;
        }
        return this.firstInputLocation;
    }

    protected void atEnd() {
        Document document = this.getDocument();
        int n = document.getLength();
        this.setCaretPosition(n);
    }

    public void paste() {
        Document document = this.getDocument();
        int n = document.getLength();
        this.setCaretPosition(n);
        this.setFirstInputLocation(n);
        super.paste();
    }

    public void append(String string) {
        super.append(string);
        Document document = this.getDocument();
        this.lastOutputLocation = document.getLength();
        this.setCaretPosition(this.lastOutputLocation);
    }

    public static class DefaultKeyTypedAction
    extends TextAction {
        JConsoleArea console;

        public DefaultKeyTypedAction(JConsoleArea jConsoleArea) {
            super("default-typed");
            this.console = jConsoleArea;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && actionEvent != null) {
                char c;
                String string = actionEvent.getActionCommand();
                int n = actionEvent.getModifiers();
                if (string != null && string.length() > 0 && (n & 8) == 0 && !Character.isISOControl(c = string.charAt(0))) {
                    Document document = jTextComponent.getDocument();
                    int n2 = document.getLength();
                    jTextComponent.setCaretPosition(n2);
                    this.console.setFirstInputLocation(n2);
                    jTextComponent.replaceSelection(string);
                }
            }
        }
    }

    public static class ReturnKeyTypedAction
    extends TextAction {
        JConsoleArea console;

        public ReturnKeyTypedAction(JConsoleArea jConsoleArea) {
            super("return");
            this.console = jConsoleArea;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && actionEvent != null) {
                Document document = jTextComponent.getDocument();
                int n = document.getLength();
                jTextComponent.setCaretPosition(n);
                jTextComponent.replaceSelection("\n");
                String string = null;
                int n2 = this.console.getFirstInputLocation();
                int n3 = n - n2 + 1;
                if (n2 != -1 && n3 > 0) {
                    try {
                        string = document.getText(n2, n3);
                    }
                    catch (BadLocationException badLocationException) {
                        throw new ProgrammingError("Unexpected exception: " + badLocationException.toString());
                    }
                    this.console.mainConsole.send(string);
                    this.console.resetFirstInputLocation();
                }
            }
        }
    }

    public static class CutAction
    extends TextAction {
        public CutAction() {
            super("cut-to-clipboard");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.cut();
            }
        }
    }

    public static class CopyAction
    extends TextAction {
        public CopyAction() {
            super("copy-to-clipboard");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.copy();
            }
        }
    }

    public static class PasteAction
    extends TextAction {
        JConsoleArea console;

        public PasteAction(JConsoleArea jConsoleArea) {
            super("paste-from-clipboard");
            this.console = jConsoleArea;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.paste();
            }
        }
    }
}

