/*
 * Decompiled with CFR 0.152.
 */
package FESI.swinggui;

import FESI.Exceptions.ProgrammingError;
import FESI.gui.InterpreterCommands;
import FESI.swinggui.Editor;
import FESI.swinggui.ExtendedConsole;
import FESI.swinggui.HelpWindow;
import FESI.swinggui.JConsoleArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class SwingConsole
extends JFrame
implements ExtendedConsole {
    private static String eol = System.getProperty("line.separator", "\n");
    private static int newWindowCounter;
    private Vector editorWindows = new Vector();
    private JConsoleArea theConsoleArea;
    private JScrollPane theScrollPane;
    private HelpWindow helpWindow;
    private static InputStream consoleIn;
    private static PrintStream consoleOut;
    private static InterpreterCommands itrp;
    TextAreaInputStream textAreaInputStream;

    private void editorWindowClosed(Editor editor) {
        this.editorWindows.removeElement(editor);
    }

    public InputStream getConsoleIn() {
        return consoleIn;
    }

    public PrintStream getConsoleOut() {
        return consoleOut;
    }

    public SwingConsole(InterpreterCommands interpreterCommands, String string, int n, int n2) {
        super(string);
        if (itrp != null) {
            throw new ProgrammingError("Only a single console is allowed in an executable");
        }
        itrp = interpreterCommands;
        this.getContentPane().setLayout(new BorderLayout());
        this.theConsoleArea = new JConsoleArea(this, n, n2);
        this.theConsoleArea.setFont(new Font("monospaced", 0, 12));
        this.theConsoleArea.setBackground(Color.lightGray);
        this.theScrollPane = new JScrollPane(this.theConsoleArea);
        this.theScrollPane.setVerticalScrollBarPolicy(22);
        this.getContentPane().add("Center", this.theScrollPane);
        this.theConsoleArea.setVisible(true);
        this.theConsoleArea.setBackground(Color.white);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        JMenuItem jMenuItem = new JMenuItem("New  Ctrl+N");
        jMenuItem.setMnemonic('N');
        jMenuItem.addActionListener(new 1());
        jMenu.add(jMenuItem);
        this.theConsoleArea.registerKeyboardAction(new 2(), KeyStroke.getKeyStroke(78, 2), 2);
        JMenuItem jMenuItem2 = new JMenuItem("Load...  Ctrl+L");
        jMenuItem2.setMnemonic('L');
        jMenuItem2.addActionListener(new 3());
        jMenu.add(jMenuItem2);
        this.theConsoleArea.registerKeyboardAction(new 4(), KeyStroke.getKeyStroke(76, 2), 2);
        JMenuItem jMenuItem3 = new JMenuItem("Open...  Ctrl+O");
        jMenuItem3.setMnemonic('O');
        jMenuItem3.addActionListener(new 5());
        jMenu.add(jMenuItem3);
        this.theConsoleArea.registerKeyboardAction(new 6(), KeyStroke.getKeyStroke(79, 2), 2);
        jMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem("Exit");
        jMenuItem4.setMnemonic('x');
        jMenuItem4.addActionListener(new 7());
        jMenu.add(jMenuItem4);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.setMnemonic('E');
        JMenuItem jMenuItem5 = new JMenuItem("Clear all");
        jMenuItem5.setMnemonic('a');
        jMenuItem5.addActionListener(new 8());
        jMenu2.add(jMenuItem5);
        jMenu2.addSeparator();
        JMenuItem jMenuItem6 = new JMenuItem("Cut");
        jMenuItem6.setMnemonic('t');
        jMenuItem6.addActionListener(new 9());
        jMenu2.add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem("Copy");
        jMenuItem7.setMnemonic('C');
        jMenuItem7.addActionListener(new 10());
        jMenu2.add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem("Paste at end");
        jMenuItem8.setMnemonic('P');
        jMenuItem8.addActionListener(new 11());
        jMenu2.add(jMenuItem8);
        jMenuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu("Help");
        jMenu3.setMnemonic('H');
        JMenuItem jMenuItem9 = new JMenuItem("Content  F1");
        jMenuItem9.setMnemonic('C');
        jMenuItem9.addActionListener(new 12());
        jMenu3.add(jMenuItem9);
        this.theConsoleArea.registerKeyboardAction(new 13(), KeyStroke.getKeyStroke(112, 0), 2);
        JMenuItem jMenuItem10 = new JMenuItem("Commands");
        jMenuItem10.addActionListener(new 14());
        jMenu3.add(jMenuItem10);
        JMenuItem jMenuItem11 = new JMenuItem("About");
        jMenuItem11.setMnemonic('A');
        jMenuItem11.addActionListener(new 15());
        jMenu3.addSeparator();
        jMenu3.add(jMenuItem11);
        jMenuBar.add(jMenu3);
        this.getContentPane().add("North", jMenuBar);
        this.pack();
        int n3 = Toolkit.getDefaultToolkit().getScreenSize().width;
        int n4 = Toolkit.getDefaultToolkit().getScreenSize().height;
        int n5 = this.getSize().width;
        int n6 = this.getSize().height;
        ((Component)this).setLocation((n3 - n5) / 2, (n4 - n6) / 2);
        this.textAreaInputStream = new TextAreaInputStream(this.theConsoleArea);
        consoleIn = new LineInputStream(this.textAreaInputStream);
        consoleOut = new PrintStream(new TextAreaOutputStream(this.theConsoleArea), true);
        System.setOut(consoleOut);
        System.setIn(consoleIn);
        System.setErr(consoleOut);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new 16());
        this.show();
        this.theConsoleArea.requestFocus();
    }

    public void commandExit() {
        boolean bl = false;
        int n = this.editorWindows.size();
        int n2 = 0;
        while (n2 < n && !bl) {
            Editor editor = (Editor)this.editorWindows.elementAt(n2);
            bl = editor.checkDirty();
            ++n2;
        }
        if (!bl) {
            if (this.helpWindow != null) {
                this.helpWindow.dispose();
                this.helpWindow = null;
            }
            itrp.exit();
        }
    }

    public void commandLoad() {
        FileDialog fileDialog = new FileDialog((Frame)this, "File to load");
        fileDialog.show();
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string2 != null && string != null) {
            itrp.loadFile(string, string2);
        }
    }

    public void commandNew() {
        JFrame jFrame = new JFrame("FESI Editor " + ++newWindowCounter);
        jFrame.getContentPane().setLayout(new BorderLayout());
        Editor editor = new Editor(this);
        this.editorWindows.addElement(editor);
        jFrame.getContentPane().add("Center", editor);
        jFrame.pack();
        ((Component)jFrame).setSize(500, 600);
        jFrame.show();
        jFrame.setDefaultCloseOperation(0);
        jFrame.addWindowListener(new 17(editor, jFrame, this));
    }

    public void commandOpen() {
        File file;
        File file2;
        FileDialog fileDialog = new FileDialog((Frame)this, "File to open");
        fileDialog.show();
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string2 != null && string != null && (file2 = new File(file = new File(string), string2)).exists()) {
            JFrame jFrame = new JFrame("FESI Editor");
            Editor editor = new Editor(this);
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add("Center", editor);
            jFrame.pack();
            ((Component)jFrame).setSize(500, 600);
            jFrame.show();
            editor.loadFile(file2);
        }
    }

    int executeString(String string, String string2) {
        int n = itrp.executeString(string, string2);
        this.theConsoleArea.atEnd();
        if (n <= 0) {
            this.toFront();
        }
        return n;
    }

    public synchronized void send(String string) {
        this.textAreaInputStream.send(string);
    }

    public synchronized void clear() {
        this.theConsoleArea.setText("");
        this.theConsoleArea.resetFirstInputLocation();
    }

    public boolean supportsEditing() {
        return true;
    }

    public void createEditor(String string) {
        File file = new File(string);
        JFrame jFrame = new JFrame("FESI Editor");
        Editor editor = new Editor(this);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add("Center", editor);
        jFrame.pack();
        ((Component)jFrame).setSize(500, 600);
        jFrame.show();
        if (file.exists()) {
            editor.loadFile(file);
        }
    }

    public void displayAbout() {
        itrp.displayAboutText();
        this.toFront();
    }

    public void displayHelpText() {
        itrp.displayHelpText();
        this.toFront();
    }

    public void displayHelpWindow() {
        if (this.helpWindow == null) {
            String string = System.getProperty("FESI.help");
            if (string == null) {
                System.err.println("[[Property FESI.help not defined, should be help url]]");
                return;
            }
            Cursor cursor = this.getCursor();
            Cursor cursor2 = Cursor.getPredefinedCursor(3);
            this.setCursor(cursor2);
            this.helpWindow = new HelpWindow(string);
            this.setCursor(cursor);
            return;
        }
        ((Component)this.helpWindow).setVisible(true);
        this.helpWindow.toFront();
    }

    static {
        itrp = null;
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SwingConsole.this.commandNew();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SwingConsole.this.commandNew();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SwingConsole.this.commandLoad();
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SwingConsole.this.commandLoad();
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SwingConsole.this.commandOpen();
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SwingConsole.this.commandOpen();
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SwingConsole.this.commandExit();
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SwingConsole.this.clear();
        }

        /* synthetic */ 8() {
        }
    }

    private final class 9
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SwingConsole.this.theConsoleArea.cut();
        }

        /* synthetic */ 9() {
        }
    }

    private final class 10
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SwingConsole.this.theConsoleArea.copy();
        }

        /* synthetic */ 10() {
        }
    }

    private final class 11
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SwingConsole.this.theConsoleArea.paste();
        }

        /* synthetic */ 11() {
        }
    }

    private final class 12
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SwingConsole.this.displayHelpWindow();
        }

        /* synthetic */ 12() {
        }
    }

    private final class 13
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SwingConsole.this.displayHelpWindow();
        }

        /* synthetic */ 13() {
        }
    }

    private final class 14
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SwingConsole.this.displayHelpText();
        }

        /* synthetic */ 14() {
        }
    }

    private final class 15
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SwingConsole.this.displayAbout();
        }

        /* synthetic */ 15() {
        }
    }

    private final class 16
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            boolean bl = false;
            int n = SwingConsole.this.editorWindows.size();
            int n2 = 0;
            while (n2 < n && !bl) {
                Editor editor = (Editor)SwingConsole.this.editorWindows.elementAt(n2);
                bl = editor.checkDirty();
                if (!bl) {
                    Frame frame = editor.getFrame();
                    frame.dispose();
                }
                ++n2;
            }
            if (!bl) {
                SwingConsole.this.dispose();
            }
        }

        public void windowClosed(WindowEvent windowEvent) {
            itrp.exit();
        }

        /* synthetic */ 16() {
        }
    }

    private static final class 17
    extends WindowAdapter {
        private final /* synthetic */ SwingConsole this$0;
        private final /* synthetic */ JFrame val$frame;
        private final /* synthetic */ Editor val$editor;

        public void windowClosing(WindowEvent windowEvent) {
            if (!this.val$editor.checkDirty()) {
                this.val$frame.dispose();
                this.this$0.toFront();
            }
        }

        public void windowClosed(WindowEvent windowEvent) {
            this.this$0.editorWindowClosed(this.val$editor);
        }

        /* synthetic */ 17(Editor editor, JFrame jFrame, SwingConsole swingConsole) {
            this.val$editor = editor;
            this.val$frame = jFrame;
            this.this$0 = swingConsole;
        }
    }

    public class LineInputStream
    extends FilterInputStream {
        byte[] byteArray;
        int arrayOffset;
        int arrayLength;

        public LineInputStream(InputStream inputStream) {
            super(inputStream);
            SwingConsole.this = SwingConsole.this;
        }

        public synchronized int read() throws IOException {
            if (this.byteArray != null && this.arrayOffset < this.arrayLength) {
                return this.byteArray[this.arrayOffset++];
            }
            this.byteArray = this.readLine();
            this.arrayOffset = 0;
            this.arrayLength = this.byteArray.length;
            if (this.byteArray != null && this.arrayOffset < this.arrayLength) {
                return this.byteArray[this.arrayOffset++];
            }
            return -1;
        }

        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.byteArray != null && this.arrayOffset < this.arrayLength) {
                int n3 = this.available();
                if (n2 > n3) {
                    n2 = n3;
                }
                System.arraycopy(this.byteArray, this.arrayOffset, byArray, n, n2);
                this.arrayOffset += n2;
                return n2;
            }
            this.byteArray = this.readLine();
            this.arrayOffset = 0;
            this.arrayLength = this.byteArray.length;
            if (this.byteArray == null || this.arrayOffset >= this.arrayLength) {
                return -1;
            }
            int n4 = this.available();
            if (n2 > n4) {
                n2 = n4;
            }
            System.arraycopy(this.byteArray, this.arrayOffset, byArray, n, n2);
            this.arrayOffset += n2;
            return n2;
        }

        public synchronized int available() throws IOException {
            return this.arrayLength - this.arrayOffset + super.available();
        }

        public synchronized byte[] readLine() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            boolean bl = false;
            while (!bl) {
                int n = this.in.read();
                if (n == -1) {
                    bl = true;
                    continue;
                }
                if (n == 8) {
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    byteArrayOutputStream.reset();
                    int n2 = byArray.length - 1;
                    if (n2 <= 0) continue;
                    byteArrayOutputStream.write(byArray, 0, n2);
                    continue;
                }
                if (n == 21) {
                    byteArrayOutputStream.reset();
                    continue;
                }
                if (n == 10) {
                    byteArrayOutputStream.write(n);
                    bl = true;
                    continue;
                }
                byteArrayOutputStream.write(n);
            }
            return byteArrayOutputStream.toByteArray();
        }
    }

    public class TextAreaOutputStream
    extends OutputStream {
        JConsoleArea theConsoleArea;
        String buffer = "";

        public TextAreaOutputStream(JConsoleArea jConsoleArea) {
            SwingConsole.this = SwingConsole.this;
            this.theConsoleArea = jConsoleArea;
        }

        public synchronized void flush() {
            this.theConsoleArea.append(this.buffer);
            this.buffer = "";
        }

        public synchronized void write(int n) {
            if (n < 0) {
                n += 256;
            }
            this.buffer = String.valueOf(this.buffer) + (char)n;
        }
    }

    public class TextAreaInputStream
    extends PipedInputStream {
        JConsoleArea theConsoleArea;
        OutputStream out;
        int nbrOfKeyTyped;

        public TextAreaInputStream(JConsoleArea jConsoleArea) {
            SwingConsole.this = SwingConsole.this;
            try {
                this.theConsoleArea = jConsoleArea;
                this.out = new PipedOutputStream(this);
                this.nbrOfKeyTyped = 0;
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
        }

        private void send(char c) {
            try {
                if (c == '\n') {
                    byte[] byArray = eol.getBytes();
                    this.out.write(byArray, 0, byArray.length);
                    this.out.flush();
                    this.nbrOfKeyTyped = 0;
                    return;
                }
                if (c >= ' ' && c < '\u0100') {
                    this.out.write(c);
                    ++this.nbrOfKeyTyped;
                    return;
                }
                if (c != '\r') {
                    this.out.write(63);
                    ++this.nbrOfKeyTyped;
                    return;
                }
            }
            catch (IOException iOException) {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        private void send(String string) {
            int n = 0;
            while (n < string.length()) {
                this.send(string.charAt(n));
                ++n;
            }
        }
    }
}

