/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.system;

import FESI.jslib.JSGlobalObject;
import FESI.jslib.JSUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import jp.wda.gpss.SocketProcessor;
import jp.wda.gpss.Socklet;
import jp.wda.gpss.SockletDeployInfo;
import jp.wda.gpss.system.Configuration;
import jp.wda.gpss.system.ScriptSocklet;

public class FesiJsSocklet
extends ScriptSocklet {
    private JSGlobalObject jsGlobal;
    private String encoding;
    private String debug;

    public void init(List linkedSocklets) {
        try {
            this.jsGlobal = JSUtil.makeEvaluator((String[])new String[]{"FESI.Extensions.JavaAccess"});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.encoding = this.getInitParam("sourceEncoding");
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        this.debug = this.getInitParam("debug");
        if (this.debug == null) {
            this.debug = "normal";
        }
        String fileName = this.getInitParam("source");
        String script = "";
        if (fileName != null) {
            try {
                script = this.loadFile(fileName, this.encoding);
                System.out.println("  \u30b9\u30af\u30ea\u30d7\u30c8'" + fileName + "'\u3092\u521d\u671f\u5316\u4e2d\u3067\u3059\u3002");
            }
            catch (Exception e) {
                System.out.println("  \u30b9\u30af\u30ea\u30d7\u30c8'" + fileName + "'\u3092\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3002");
            }
        }
        try {
            this.jsGlobal.setMember("application", (Object)this);
            this.jsGlobal.eval(script);
            if (this.get("onInit") == null) {
                System.out.println("      onInit\u304c\u672a\u5b9a\u7fa9\u3067\u3059\u3002");
                this.jsGlobal.eval("function onInit(){}");
            }
            if (this.get("onConnect") == null) {
                System.out.println("      onConnect\u304c\u672a\u5b9a\u7fa9\u3067\u3059\u3002");
                this.jsGlobal.eval("function onConnect(client){client.send(\"+OK\");return true;}");
            }
            if (this.get("onDisconnect") == null) {
                System.out.println("      onDisconnect\u304c\u672a\u5b9a\u7fa9\u3067\u3059\u3002");
                this.jsGlobal.eval("function onDisconnect(client){}");
            }
            if (this.get("onCommand") == null) {
                System.out.println("      onCommand\u304c\u672a\u5b9a\u7fa9\u3067\u3059\u3002");
                this.jsGlobal.eval("function onCommand(client,command){application.sendToAllClients(command);return true;}");
            }
            if (this.get("onDestroy") == null) {
                this.jsGlobal.eval("function onDestroy(){}");
            }
            if (this.get("onSockletLink") == null) {
                this.jsGlobal.eval("function onSockletLink(from){return false;}");
            }
            this.call("onInit", new Object[]{linkedSocklets});
        }
        catch (Exception e) {
            if (this.debug.equals("stacktrace")) {
                e.printStackTrace();
            }
            System.out.println(e);
        }
    }

    public boolean checkConnection(SocketProcessor client) {
        try {
            Object result = this.call("onConnect", new Object[]{client});
            return "true".equals(result.toString());
        }
        catch (Exception e) {
            if (this.debug.equals("stacktrace")) {
                e.printStackTrace();
            } else {
                System.out.println(e);
            }
            return false;
        }
    }

    public void preRemoveClient(SocketProcessor client) {
        try {
            this.call("onDisconnect", new Object[]{client});
        }
        catch (Exception e) {
            if (this.debug.equals("stacktrace")) {
                e.printStackTrace();
            }
            System.out.println(e);
        }
    }

    public boolean doCommand(SocketProcessor client, String command) {
        try {
            Object result = this.call("onCommand", new Object[]{client, command});
            return "true".equals(result.toString());
        }
        catch (Exception e) {
            if (this.debug.equals("stacktrace")) {
                e.printStackTrace();
            } else {
                System.out.println(e);
            }
            return false;
        }
    }

    public void destroy() {
        try {
            this.call("onDestroy", new Object[0]);
        }
        catch (Exception e) {
            if (this.debug.equals("stacktrace")) {
                e.printStackTrace();
            }
            System.out.println(e);
        }
        this.jsGlobal = null;
    }

    public boolean allowAccessFromOtherSocklet(Socklet from) {
        try {
            Object result = this.call("onSockletLink", new Object[]{from});
            return "true".equals(result.toString());
        }
        catch (Exception e) {
            if (this.debug.equals("stacktrace")) {
                e.printStackTrace();
            } else {
                System.out.println(e);
            }
            return false;
        }
    }

    public boolean importSource(String fileName) {
        String script = this.loadFile(fileName, this.encoding);
        try {
            this.jsGlobal.eval(script);
            return true;
        }
        catch (Exception e) {
            if (this.debug.equals("stacktrace")) {
                e.printStackTrace();
            } else {
                System.out.println(e);
            }
            return false;
        }
    }

    public void addSocklet(List links, String sockletName, String className) {
        SockletDeployInfo appinfo = this.copyInfo(sockletName, className);
        links.add(appinfo);
    }

    public void addScriptSocklet(List links, String sockletName, String fileName) {
        SockletDeployInfo appinfo = this.copyInfo(sockletName, "jp.wda.gpss.system.FesiJsSocklet");
        appinfo.setInitParam("source", fileName);
        links.add(appinfo);
    }

    public Object call(String functionName, Object[] args) {
        try {
            return this.jsGlobal.call(functionName, args);
        }
        catch (Exception e) {
            if (this.debug.equals("stacktrace")) {
                e.printStackTrace();
            } else {
                System.out.println(e);
            }
            return null;
        }
    }

    public Object get(String variableName) {
        try {
            return this.jsGlobal.getMember(variableName);
        }
        catch (Exception e) {
            if (this.debug.equals("stacktrace")) {
                e.printStackTrace();
            } else {
                System.out.println(e);
            }
            return null;
        }
    }

    private String loadFile(String fileName, String encoding) {
        fileName = Configuration.getAbsolutePath(fileName).getAbsolutePath();
        String result = "";
        try {
            BufferedReader fr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), encoding));
            String inLine = fr.readLine();
            while (inLine != null) {
                result = String.valueOf(result) + inLine + "\n";
                inLine = fr.readLine();
            }
            fr.close();
        }
        catch (Exception e) {
            if (this.debug.equals("stacktrace")) {
                e.printStackTrace();
            }
            System.out.println(e);
        }
        return result;
    }
}

