package jp.wda.gpss.system;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Iterator;
import java.util.Vector;

import jp.wda.gpss.Progress;
import jp.wda.gpss.Socklet;
import jp.wda.gpss.SockletDeployInfo;
import jp.wda.gpss.SockletDeployingException;
 
/**
 * <FONT SIZE=2><I><B>
 * [ OProject GPSS for FlashMX ] FlashMXpėp\PbgT[o
 * </B></I></FONT><BR>
 * \Pbg҂CT[oNX<BR>
 * <BR>
 * Ԗڂ̈ɁAconfig.xmlݒt@Cw肵āANĂB<BR>
 *
 * @version	1.04		2003/11/27
 * @since		1.00		2003/04/29
 * @author	amoi
 */
public class Main extends ExecutableBase{
	// AvP[VGg[|Cg ///////////////////////////////////////////////
	//                                                         Application Entry Point //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * Ҏ󂯃CT[oN܂B<BR>
	 * Ԗڂ̈ɁAconfig.xmlݒt@Cw肵āANĂB<BR>
	 * 
	 * @param args
	 */
	public static void main(String[] args){
		if(args.length == 0){
			System.out.println("Usage : ");
			System.out.println("  java jp.wda.gpss.system.Main config.xml");
			System.out.println("    config.xml - ݒt@C");
			
			return;
		}
		File configfile = new File(args[0]);
		if(!configfile.exists()){
			System.out.println("ݒt@C܂B");
			System.out.println("File : " + configfile.getAbsolutePath());
			return;
		}
		
		Main main = new Main(new Configuration(configfile));
	}
	
	// RXgN^ ///////////////////////////////////////////////////////////////////
	//                                                                    Constructors //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 *	ftHg̐ݒpăIuWFNg\zRXgN^
	 */
	private Main(Configuration config){
		super(config);
		
		this.terminator = false;
	}
	
	/* ***********************************************************************>> */;
	/**
	 * JVMKx[WRN^ɂČĂ΂AIB<BR>
	 * zĂSĂSocklet̏IsȂ܂B<BR>
	 * IĂꍇ́AɉsȂ܂B
	 */
	protected void finalize(){
		if(this.terminator){ return; }
		
		Iterator it = getSocklets();
		while(it.hasNext()){
			Socklet app = (Socklet)it.next();
			app.destroy();
		}
	}

	// tB[h` ///////////////////////////////////////////////////////////////
	//                                                                          Fields //
	/////////////////////////////////////////////////////////////////////////////////////
	
	/* ***********************************************************************>> */;
	/**
	 * T[oIXCb`
	 */
	private boolean terminator = false;

	// \bh /////////////////////////////////////////////////////////////////////
	//                                                                 Private Methods //
	/////////////////////////////////////////////////////////////////////////////////////
	
	/* ***********************************************************************>> */;
	/**
	 * T[oJnAڑ󂯕t܂B
	 * @see jp.wda.gpss.system.ExecutableBase#accept()
	 */
	public void accept(){
		System.out.println("Starting server...");
		ServerSocket svsocket = null;
		
		try {
			// T[o\PbgNX̃CX^X𐶐
			svsocket = new ServerSocket(getPort());
			
			// T[oNĂԂ́BBB
			while(true){
				// NCAg̐ڑv҂
				// ڑvꍇ͂󂯂ƂAV\Pbg𐶐
				Socket socket = svsocket.accept();
				
				if(terminator){ break; }
				
				createSocketProcessor(socket);
			}
		}catch(Throwable e){
			//  ڑsƂ`
			e.printStackTrace();
		}finally{
			if(svsocket != null){
				try{ svsocket.close(); }catch(Exception e){ ; }
			}
			this.terminator = false;
		}
	}
	
	/* ***********************************************************************>> */;
	/**
	 * \PbgɃNCAg\PbgIuWFNg쐬܂B
	 * 
	 * @param socket	ʐMp\Pbg
	 */
	private void createSocketProcessor(Socket socket){
		getProgress().syslog("Create Client... " + socket.getInetAddress().getHostAddress());
		SocketProcessorImpl client = null;
		try{
			socket.setSoTimeout(getInitialTimeout());
			client = new SocketProcessorImpl(this, socket, getEncoding(), getMessagesBufferSize());
		}catch(InterruptedIOException e){
			getProgress().errlog("^CAEgݒɎs܂B:" + client.getClientID(), e);
			return;
		}catch(IOException e){
			e.printStackTrace();
			return;
		}
		
		if(client != null){
			new Thread(client, "ID:" + client.getClientID()).start();
			getProgress().syslog("Welcome " + client.getIPAddress() + "! (ID:" + client.getClientID() + ")");
		}
		
		return;
	}
	
	// SystemCommandSockletp\bh ///////////////////////////////////////////////////
	//                                                Methods for SystemCommandSocklet //
	/////////////////////////////////////////////////////////////////////////////////////
	
	/* ***********************************************************************>> */;
	/**
	 * T[oI܂B
	 * @param sys ĂяoSystemCommandSocklet
	 * @see jp.wda.gpss.ExecutableBase#shutdown(SystemCommandSocklet)
	 */
	void shutdown(SystemCommandSocklet sys){
		if(!checkSystemCommandSocklet(sys)){ return; }
		
		getProgress().syslog("Shutdown server...");
		
		// ڑ̑SNCAgؒf
		Iterator it = getSocklets();
		while(it.hasNext()){
			Socklet app = (Socklet)it.next();
			app.disconnectAllClients("Good by...");
			app.destroy();
		}
		
		this.terminator = true;
		Socket socket = null;
		try{
			// _~[ڑ
			socket = new Socket("localhost", getPort());
		}catch(Throwable e){
			;
		}finally{
			if(socket != null){
				try{ socket.close(); }catch(IOException e){ ; }
			}
		}
		
		getProgress().syslog("Shutdown successfully!");
	}
	
	/* ***********************************************************************>> */;
	/**
	 * T[oċN܂B
	 * @param sys ĂяoSystemCommandSocklet
	 * @see jp.wda.gpss.ExecutableBase#restart(SystemCommandSocklet)
	 */
	void restart(SystemCommandSocklet sys){
		if(!checkSystemCommandSocklet(sys)){ return; }
		
		setRestartAfterShutdown();
		shutdown(sys);
	}
	
	/* ***********************************************************************>> */;
	/**
	 * w肵zSockletċN܂
	 * 
	 * @param sys ĂяoSystemCommandSocklet
	 * @param name Sockletz
	 * @return ċNɐ^
	 * @see jp.wda.gpss.ExecutableBase#restartSocklet(SystemCommandSocklet, String)
	 */
	boolean restartSocklet(SystemCommandSocklet sys, String name){
		if(!checkSystemCommandSocklet(sys)){ return false; }
		
		getProgress().syslog("Restart socklet \"" + name + "\"");
		Socklet socklet = this.getSocklet(name);
		SockletDeployInfo info = null;
		String scriptExt = null;
		File scriptFile = null;
		SockletLoader loader = null;
		if(socklet != null && socklet instanceof ScriptSocklet){
			scriptExt  = ((ScriptSocklet)socklet).getExtention();
			scriptFile = ((ScriptSocklet)socklet).getScriptFile();
			ScriptInfo scrinfo = getScriptInfomation(scriptExt);
			
			if(scrinfo != null && scriptFile != null && scriptFile.exists()){
				info = getScriptSockletInformation(name);
				info.addInitParam("source", scriptFile.getAbsolutePath());
				info.addInitParam("sourceEncoding", scrinfo.getEncoding());
				info.setClassname(scrinfo.getJSClass().getName());
			}
			
			loader = this.scriptLoader;
		}else{
			info = getSockletInformation(name);
		}
		
		if(info == null){
			getProgress().syslog("Socket \"" + name + "\"'s infomation is not found.", Progress.ERROR);
			return false;
		}
		
		// Socklet̒~
		terminateSocklet(socklet, "Good by...");
		
		getProgress().syslog("Socklet\"" + info.getName() + "\"(" + info.getClassname() + ")z܂B");
		try{
			socklet = deployNewSocklet(info, DEPLOY_BY_SYSTEM, loader);
			if(socklet instanceof ScriptSocklet){
				((ScriptSocklet)socklet).setExtention(scriptExt);
				((ScriptSocklet)socklet).setScriptFile(scriptFile);
			}
		}catch(SockletDeployingException e){
			getProgress().errlog("Socklet̔zɎs܂B", e);
			return false;
		}
		return true;
	}
	
	/* ***********************************************************************>> */;
	/**
	 * ݒt@CēǍ܂B
	 * @param sys ĂяoSystemCommandSocklet
	 * @return ēǍɐ^
	 * @see jp.wda.gpss.ExecutableBase#reloadCongif(SystemCommandSocklet)
	 */
	boolean reloadConfig(SystemCommandSocklet sys){
		if(!checkSystemCommandSocklet(sys)){ return false; }
		
		System.out.println("Reload config...");
		try{
			loadConfig();
		}catch(ConfigurationError e){
			getProgress().errlog("ݒt@C̍ēǍɎs܂B", e);
			return false;
		}
		
		reloadSystemCommandInfo();
		
		System.out.println("Reload config successfully!");
		return true;
	}
}

/**
 * <FONT SIZE=2><I><B>
 * [ OProject GPSS for FlashMX ] FlashMXpėp\PbgT[o
 * </B></I></FONT><BR>
 *	NCAg\PbgC^[tF[X̎
 *
 *	@author	amoi
 */
final class SocketProcessorImpl extends SocketProcessorBase implements Runnable{
	// RXgN^ ///////////////////////////////////////////////////////////////////
	//                                                                    Constructors //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 *	CT[oƃ\Pbgw肵ăIuWFNg\z܂B
	 *
	 * @param main CT[o
	 * @param socket \Pbg
	 */
	public SocketProcessorImpl(Main server, Socket socket, String encoding, int buffersize) throws IOException{
		super(server, encoding, buffersize, socket.getInetAddress().getHostAddress());
		this.socket = socket;
	}

	// tB[h` ///////////////////////////////////////////////////////////////
	//                                                                          Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * \Pbg
	 */
	private Socket socket;
	
	/* ***********************************************************************>> */;
	/**
	 *	NCAg瑗Ă郁bZ[WM邽߂̃[_<BR>
	 */
	private BufferedReader in;
	/**
	 *	NCAgւ̃bZ[W𑗐M邽߂̃C^<BR>
	 */
	private PrintWriter out;

	/* ***********************************************************************>> */;
	/**
	 *	M<BR>
	 */
	private boolean sendingstatus = true;

	/* ***********************************************************************>> */;
	/**
	 * bZ[WMpXbh
	 */
	private MessageSender sender;

	// vpeB ///////////////////////////////////////////////////////////////////////
	//                                                                      Properties //
	/////////////////////////////////////////////////////////////////////////////////////
	
	/* ***********************************************************************>> */;
	/**
	 * MpbZ[Wobt@TCY
	 */
	private boolean terminated = true;
	/**
	 * MpbZ[Wobt@TCYݒ肵܂B
	 * @param size obt@TCY
	 */
	public boolean isTerminated(){ return terminated; }

	// CX^X\bh /////////////////////////////////////////////////////////////
	//                                                                Instance Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * \PbgR}hMAAvP[ṼC^v^ɗ܂B
	 *	@see java.lang.Runnable#run()
	 */
	public void run(){
		// Mp
		char c[] = new char[1];
		
		try {
			// readerwriter͂ꂼBufferedReader,PrintWriterŃXg[bvĐ
			this.in  = new BufferedReader( new InputStreamReader(  socket.getInputStream(),  getEncoding()));
			this.out = new PrintWriter(    new OutputStreamWriter( socket.getOutputStream(), getEncoding()), true);
			this.sender = new MessageSender(this);
			
			// ڑpR}hMA
			// CT[o珊Socklet炢܂B
			if(in.read(c, 0, 1) != -1 ){
				StringBuffer sb = new StringBuffer(4096);
				
				while(c[0] != '\0'){
					sb.append(c[0]);
					in.read(c, 0 ,1);
				}
				// fobOpóB
				getProgress().log("debuglogger", "connection:" + sb + " [" + getClientID() + "]");
				
				doInitialCommand(sb.toString());
			}
			
			// Sockletݒ肳ĂȂꍇ͒ɏIB
			if(getApplication() == null){
				return;
			}
			
			// NCAg̐ڑsAʂʒm܂B
			// ʒmbZ[WMɎsꍇ͒ɏIB
			sendingstatus = false;
			if(!getApplication().checkConnection(this)){
				return;
			}
			
			this.terminated = false;
			
			// ^CAEgԂݒ
			socket.setSoTimeout(getApplication().getTimeout());
				
			// NCAg1M
			while( in.read(c, 0, 1) != -1 ){
				StringBuffer sb = new StringBuffer(4096);
				
				while(c[0] != '\0'){
					sb.append(c[0]);
					in.read(c, 0 ,1);
				}
				// fobOpóB
				getProgress().log("debuglogger", "command:" + sb + " [" + getClientID() + "]");
				
				// MĂR}hs
				sendingstatus = false;
				if(!getApplication().doCommand(this, sb.toString())){
					return;
				}
			}
		}catch(SocketException ioe){
			getProgress().errlog(ioe.getMessage() + ":" + getClientID());
			return;
		}catch(Throwable ioe){
			getProgress().errlog("O܂B" + getClientID(), ioe);
			return;
		}finally{
			this.terminated = true;
			if(sendingstatus){
				// M̃bZ[Wꍇ́A1҂܂B
				synchronized(this){ try{ wait(2000);}catch(InterruptedException e){ ; } }
			}
			
			// fobOpóB
			getProgress().log("debuglogger", "disconnect [" + getClientID() + "]");
			
			try{
				// bZ[WMpXbh̒~
				if(this.sender != null && !this.sender.isTeminated()){
					this.sender.terminate();
				}
				
				// AvP[V炱̃NCAg폜
				if(getApplication() != null){
					getApplication().preRemoveClient(this);
					getApplication().removeClient(this);
					notifyToSystemCommandSocklet();
				}
			}catch(Throwable e){
				getProgress().errlog("IɗO܂B" + getClientID(), e);
				e.printStackTrace();
			}
			
			// IOXg[yу\Pbg
			if(this.out != null){ this.out.close(); }
			try{ if(this.in != null){ this.in.close(); }}catch(IOException e){ ; }
			try{ if(this.socket != null){ this.socket.close(); }}catch(IOException e){ ; }
			
			this.out    = null;
			this.in     = null;
			this.socket = null;
		}
	}
	
	/* ***********************************************************************>> */;
	/**
	 * NCAgɃbZ[W𑗂܂B<BR>
	 *
	 * @param msg NCAgɑ郁bZ[W
	 * @return Mɐꍇ͐^Asꍇ͋U
	 * @see jp.wda.gpss.SocketProcessor#send(String)
	 */
	public boolean send(String message){
		if(this.sender.isTeminated()){ return false; }
		return sender.send(message);
	}
	
	/* ***********************************************************************>> */;
	/**
	 * NCAgɃbZ[W𑗂܂B<BR>
	 * bZ[Wnull"\0"I[Ƃ܂B<BR>
	 * ̃\bhł́AMp̕ʃXbhgp܂B<BR>
	 * NCAgɃbZ[WM̂҂܂B<BR>
	 *
	 * @param msg NCAgɑ郁bZ[W
	 * @return Mɐꍇ͐^Asꍇ͋U
	 */
	private boolean sendAndWait(String message){
		if(this.out == null){
			getProgress().errlog("C^r܂B" + getClientID());
			isSending(false);
			return false;
		}
		
		this.out.print(message + "\0");
		
		if(this.out.checkError()){
			getProgress().errlog("MɎs܂B" + getClientID() + "\n" + message);
			isSending(false);
			return false;
		}
		
		return true;
	}
	
	/**
	 * MpXbh̑MXe[^XύX܂B
	 * @param sw MXe[^X
	 */
	private void isSending(boolean sw){
		this.sendingstatus = sw;
		if(!sw){
			synchronized(this){ notifyAll(); }
			if(sender != null){ synchronized(sender){ sender.notifyAll(); } }
		}
	}
	
	/* ***********************************************************************>> */;
	/**
	 * NCAg\PbgIɏI܂B
	 * @see jp.wda.gpss.SocketProcessor#terminate()
	 */
	public synchronized void terminate(){
		if(this.socket != null && !this.socket.isClosed()){
			try{
				this.socket.close();
			}catch(IOException e){
				getProgress().errlog("Shutdown failure : " + getClientID(), e);
			}
		}
	}
	/**
	 * NCAgɏIbZ[WoANCAg\PbgI܂B
	 * @param message IbZ[W
	 * @see jp.wda.gpss.SocketProcessor#terminate(String)
	 */
	public synchronized void terminate(String message){
		sendAndWait(message);
		terminate();
	}
	
	// NX ///////////////////////////////////////////////////////////////////////
	//                                                                     Inner Class //
	/////////////////////////////////////////////////////////////////////////////////////
	/**
	 * ʃXbhgpāANCAg\Pbg̏o̓Xg[ɕ𑗏o邽߂̃NX
	 */
	private class MessageSender implements Runnable{
		// RXgN^ ///////////////////////////////////////////////////////////////////
		//                                                                    Constructors //
		/////////////////////////////////////////////////////////////////////////////////////

		/* ***********************************************************************>> */;
		/**
		 * w肵ăIuWFNg\zRXgN^
		 *
		 * @param socket NCAg\PbgIuWFNg
		 * @param out NCAg\Pbg̏o̓Xg[
		 */
		private MessageSender(SocketProcessorImpl socket){
			this.parent = socket;
			this.messages = new Vector();
			
			thisThread = new Thread(this, "sender-" + parent.getClientID());
			thisThread.start();
		}
		
		// tB[h` ///////////////////////////////////////////////////////////////
		//                                                                          Fields //
		/////////////////////////////////////////////////////////////////////////////////////

		/* ***********************************************************************>> */;
		/**
		 * NCAg\PbgIuWFNg
		 */
		private SocketProcessorImpl parent;
		/**
		 * bZ[Wobt@
		 */
		private Vector messages;
		/**
		 * bZ[Wobt@
		 */
		private Thread thisThread;

		// vpeB ///////////////////////////////////////////////////////////////////////
		//                                                                      Properties //
		/////////////////////////////////////////////////////////////////////////////////////

		/* ***********************************************************************>> */;
		/**
		 * IXCb`
		 */
		private boolean terminate = false;
		/**
		 * ɂ̃Xbh~Ă邩
		 * @return ~ς݂̏ꍇ͐^
		 */
		public boolean isTeminated(){ return terminate; }
		
		// CX^X\bh /////////////////////////////////////////////////////////////
		//                                                                Instance Methods //
		/////////////////////////////////////////////////////////////////////////////////////

		/* ***********************************************************************>> */;
		/**
		 * w肵bZ[Wobt@ɒǉAXbhĊJB
		 * 
		 * @param message ǉ镶
		 * @return obt@ǉɎsꍇ͋U
		 */
		private boolean send(String message){
			if(messages == null){ return false; }
			
			messages.add(message);
			if(messages.size() > parent.getMessagesBufferSize()){
				System.out.println("obt@ɗ߂Ēu郁bZ[W̍ől𒴂܂B");
				return false;
			}
			
			// XbhĊJ
			parent.isSending(true);
			synchronized(this){ notify(); }
			
			return true;
		}
		
		/* ***********************************************************************>> */;
		/**
		 * ̑MpXbhIB
		 */
		void terminate(){
			messages = null;
			terminate = true;
			
			// XbhĊJ
			synchronized(this){ notify(); }
		}
		
		/* ***********************************************************************>> */;
		/**
		 * MpXbh
		 */
		public void run(){
			while(!terminate){
				while(messages != null && messages.size() > 0){
					if(!parent.sendAndWait((String)messages.remove(0))){
						terminateParent();
						return;
					}
				}
				parent.isSending(false);
				
				// bZ[WMterminateXCb`ɕύXȂAꉞmF
				if(terminate){ return; }
				
				// Xbhx~
				synchronized(this){
					try{ wait(); }catch(Exception e){
						getProgress().errlog("MpXbh̋x~Ɏs܂B", e);
						terminateParent();
						return;
					}
				}
			}
		}
		private void terminateParent(){
			terminate = true;
			parent.terminate();
		}
	}
}
