/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.framework.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import jp.haw.grain.framework.xml.Util;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class BinaryXMLParser
implements XmlPullParser {
    public static final String XMLDECL_VERSION = "http://xmlpull.org/v1/doc/properties.html#xmldecl-version";
    private static final int INITIAL_STATE = 0;
    private static final int DOCUMENT_READING_STATE = 1;
    public static final int CDATA = 6;
    public static final int NOP_TAG = 0;
    public static final int ELEMENT_START_TAG = 1;
    public static final int EMPTY_ELEMENT_TAG = 2;
    public static final int ATTRIBUTE_TAG = 3;
    public static final int TEXT_TAG = 4;
    public static final int PREFIXMAPPING_TAG = 5;
    public static final int CDATA_START_TAG = 6;
    public static final int ELEMENT_END_TAG = 9;
    public static final int DOCUMENT_END = 15;
    public static final int NONE_MASK = 0;
    public static final int INDEXED_MASK = 16;
    public static final int DEFAULT_NS_MASK = 16;
    public static final int NS_MASK = 32;
    public static final int TAG_MASK = 15;
    public static final int TEXT_TERMINATOR = 0;
    public static final String DETECT_ENCODING = "http://xmlpull.org/v1/doc/features.html#detect-encoding";
    private InputStream inputStream;
    private int eventType = 0;
    private Vector wordDic = new Vector();
    private Stack nsStack = new Stack();
    private int bodySize;
    private int dicSize;
    private String version;
    private String encoding;
    private byte nextNode;
    private int depth;
    private String namespaceUri;
    private String prefix;
    private String name;
    private Vector attibutes;
    private boolean processingEmptyElement;
    private boolean afterEndTag;
    private Stack elementStack = new Stack();
    private boolean whitespace;
    private boolean headerApplied;
    private boolean processNamespace = false;
    private boolean validation = false;
    private boolean processDocDecl;
    private boolean detectEncoding = false;
    private int nextToken;
    private String text;
    private byte[] cdata;
    private int node;
    private boolean nodeApplied = true;

    private BinaryXMLParser() {
    }

    public static BinaryXMLParser newInstance() {
        return BinaryXMLParser.newInstance(null, null);
    }

    public static BinaryXMLParser newInstance(InputStream is, String encoding) {
        try {
            BinaryXMLParser parser = new BinaryXMLParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            if (is != null) {
                parser.setInput(is, encoding);
            }
            return parser;
        }
        catch (XmlPullParserException e) {
            return null;
        }
    }

    public void setFeature(String name, boolean state) throws XmlPullParserException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (this.eventType != 0) {
            throw new XmlPullParserException("Illegal state");
        }
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(name)) {
            this.processNamespace = state;
        } else if (DETECT_ENCODING.equals(name)) {
            this.detectEncoding = state;
        } else {
            throw new XmlPullParserException("Unsupported feature: " + name);
        }
    }

    public boolean getFeature(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(name)) {
            return this.processNamespace;
        }
        if (DETECT_ENCODING.equals(name)) {
            return this.detectEncoding;
        }
        return false;
    }

    public void setProperty(String arg0, Object arg1) throws XmlPullParserException {
    }

    public Object getProperty(String name) {
        if (name.equals(XMLDECL_VERSION)) {
            return this.version;
        }
        return null;
    }

    public void setInput(Reader arg0) throws XmlPullParserException {
        throw new XmlPullParserException("Unsupported Operation");
    }

    public void setInput(InputStream inputStream, String encoding) throws XmlPullParserException {
        this.inputStream = new IndexCountInputStream(inputStream);
        this.encoding = encoding;
    }

    public String getInputEncoding() {
        return this.encoding;
    }

    public void defineEntityReplacementText(String arg0, String arg1) throws XmlPullParserException {
    }

    public int getNamespaceCount(int depth) throws XmlPullParserException {
        if (!this.processNamespace) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.nsStack.size(); ++i) {
            Namespace ns = (Namespace)this.nsStack.elementAt(i);
            if (ns.depth > depth) break;
            ++count;
        }
        return count;
    }

    public String getNamespacePrefix(int pos) throws XmlPullParserException {
        if (!this.processNamespace) {
            throw new IndexOutOfBoundsException();
        }
        Namespace ns = (Namespace)this.nsStack.elementAt(pos);
        if (ns != null) {
            return ns.prefix;
        }
        return null;
    }

    public String getNamespaceUri(int pos) throws XmlPullParserException {
        if (!this.processNamespace) {
            throw new IndexOutOfBoundsException();
        }
        Namespace ns = (Namespace)this.nsStack.elementAt(pos);
        if (ns != null) {
            return ns.namespaceUri;
        }
        return "";
    }

    public String getNamespace(String prefix) {
        if (!this.processNamespace) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = this.nsStack.size() - 1; i >= 0; --i) {
            Namespace ns = (Namespace)this.nsStack.elementAt(i);
            if (ns == null || prefix == null && ns.prefix != null || prefix != null && !prefix.equals(ns.prefix)) continue;
            return ns.namespaceUri;
        }
        return null;
    }

    public int getDepth() {
        return this.depth;
    }

    public String getPositionDescription() {
        return null;
    }

    public int getLineNumber() {
        return 0;
    }

    public int getColumnNumber() {
        return 0;
    }

    public boolean isWhitespace() throws XmlPullParserException {
        if (this.text == null || this.text.length() == 0) {
            return false;
        }
        for (int i = 0; i < this.text.length(); ++i) {
            char c = this.text.charAt(i);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            return false;
        }
        return true;
    }

    public String getText() {
        return this.text;
    }

    public byte[] getCDATA() {
        return this.cdata;
    }

    public char[] getTextCharacters(int[] arg0) {
        return null;
    }

    public String getNamespace() {
        return ((Element)this.elementStack.peek()).namespaceUri;
    }

    public String getName() {
        return ((Element)this.elementStack.peek()).name;
    }

    public String getPrefix() {
        return ((Element)this.elementStack.peek()).prefix;
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        if (this.eventType != 2) {
            throw new XmlPullParserException("Illegal state: expected START_TAG");
        }
        return this.processingEmptyElement;
    }

    public int getAttributeCount() {
        return this.attibutes.size();
    }

    public String getAttributeNamespace(int index) {
        return ((Attribute)this.attibutes.elementAt((int)index)).namespaceUri;
    }

    public String getAttributeName(int index) {
        return ((Attribute)this.attibutes.elementAt((int)index)).name;
    }

    public String getAttributePrefix(int index) {
        return ((Attribute)this.attibutes.elementAt((int)index)).prefix;
    }

    public String getAttributeType(int index) {
        return ((Attribute)this.attibutes.elementAt((int)index)).type;
    }

    public boolean isAttributeDefault(int arg0) {
        return false;
    }

    public String getAttributeValue(int index) {
        return ((Attribute)this.attibutes.elementAt((int)index)).value;
    }

    public String getAttributeValue(String namespace, String name) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("not START_TAG state.");
        }
        for (int i = 0; i < this.attibutes.size(); ++i) {
            Attribute attr = (Attribute)this.attibutes.elementAt(i);
            if (!attr.namespaceUri.equals(namespace) || !attr.name.equals(name)) continue;
            return attr.value;
        }
        return null;
    }

    public int getEventType() {
        return this.eventType;
    }

    public int next() throws XmlPullParserException, IOException {
        return this.nextToken(false);
    }

    public int nextToken() throws XmlPullParserException, IOException {
        return this.nextToken(true);
    }

    private int nextToken(boolean reportAll) throws XmlPullParserException {
        try {
            System.out.println("start nextToken: reportAll=" + reportAll);
            StringBuffer buf = null;
            block10: while (true) {
                this.whitespace = false;
                if (this.eventType == 0 && !this.headerApplied) {
                    this.bodySize = this.readInteger();
                    int dicSize = this.readInteger();
                    this.version = this.readAsciiChar();
                    String encoding = this.readAsciiChar();
                    if (this.detectEncoding) {
                        this.encoding = encoding;
                    }
                    this.buildDictionary(dicSize);
                    this.headerApplied = true;
                }
                if (this.nodeApplied) {
                    this.node = this.nextNode();
                }
                System.out.println("processing node: " + Integer.toHexString(this.node));
                System.out.println("buffer: " + buf);
                switch (this.node & 0xF) {
                    case 1: 
                    case 2: {
                        if (!reportAll && buf != null) break block10;
                        this.applyNode();
                        this.eventType = 2;
                        return this.eventType;
                    }
                    case 9: {
                        if (!reportAll && buf != null) break block10;
                        this.applyNode();
                        this.eventType = 3;
                        return this.eventType;
                    }
                    case 15: {
                        if (!reportAll && buf != null) break block10;
                        this.eventType = 1;
                        return this.eventType;
                    }
                    case 4: {
                        System.out.println("TEXT_TAG: " + Integer.toHexString(this.node));
                        this.applyNode();
                        if (this.getText() == null || this.getText().length() == 0) {
                            if (!reportAll) continue block10;
                            this.eventType = 4;
                            return this.eventType;
                        }
                        System.out.println("TEXT_TAG: text=" + this.getText());
                        if (!this.isWhitespace()) {
                            if (reportAll) {
                                this.eventType = 4;
                                return this.eventType;
                            }
                            if (buf == null) {
                                buf = new StringBuffer();
                            }
                            buf.append(this.text);
                            continue block10;
                        }
                        this.whitespace = true;
                        if (!reportAll) continue block10;
                        this.eventType = 7;
                        return this.eventType;
                    }
                    case 6: {
                        System.out.println("CDATA_START_TAG: " + Integer.toHexString(this.node));
                        if (!reportAll && buf != null) break block10;
                        this.applyNode();
                        this.eventType = 6;
                        return this.eventType;
                    }
                    case 5: {
                        System.out.println("prefixmapping tag :" + Integer.toHexString(this.node));
                        this.applyNode();
                        continue block10;
                    }
                    default: {
                        throw new XmlPullParserException("unexpected node: " + Integer.toHexString(this.node));
                    }
                }
                break;
            }
            this.text = buf.toString();
            this.eventType = 4;
            return this.eventType;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new XmlPullParserException(e.toString());
        }
    }

    public void require(int arg0, String arg1, String arg2) throws XmlPullParserException, IOException {
    }

    public String nextText() throws XmlPullParserException, IOException {
        System.out.println("start next text");
        if (this.getEventType() != 2) {
            throw new XmlPullParserException("parser must be on START_TAG to read next text");
        }
        int eventType = this.next();
        if (eventType == 4) {
            System.out.println("event type: text");
            String result = this.getText();
            System.out.println("text: " + result);
            eventType = this.next();
            if (eventType != 3) {
                throw new XmlPullParserException("event TEXT it must be immediately followed by END_TAG");
            }
            return result;
        }
        if (eventType == 3) {
            System.out.println("event type: end tag");
            return "";
        }
        throw new XmlPullParserException("parser must be on START_TAG or TEXT to read text");
    }

    public int nextTag() throws XmlPullParserException, IOException {
        int eventType = this.next();
        if (eventType == 4 && this.isWhitespace()) {
            eventType = this.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected start or end tag");
        }
        return eventType;
    }

    int readInteger() throws XmlPullParserException, IOException {
        int body;
        int head = this.inputStream.read();
        if ((head & 0x80) == 0) {
            return head;
        }
        int mask = 224;
        int data = 0;
        int i = 0;
        while (mask < 255 && (body = this.inputStream.read()) != -1) {
            data = data << 6 | body & 0x3F;
            if ((head & mask) == (mask << 1 & 0xFF)) {
                return (head & ~mask) << (i + 1) * 6 | data;
            }
            mask = mask >>> 1 | 0x80;
            ++i;
        }
        throw new XmlPullParserException("Illegal binary format: integer");
    }

    String readAsciiChar() throws XmlPullParserException, IOException {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i != -1) {
            i = this.inputStream.read();
            if (i == 0) {
                return buf.toString();
            }
            buf.append((char)i);
        }
        throw new XmlPullParserException("Illegal binary format: ascii-chars");
    }

    String readText() throws XmlPullParserException, IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int i = 0;
        while (i != -1) {
            i = this.inputStream.read();
            if (i == 0) {
                return new String(os.toByteArray(), this.encoding);
            }
            os.write(i);
        }
        System.out.println("terminate i is -1");
        return "";
    }

    byte[] readCDATA() throws XmlPullParserException, IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int length = this.readInteger();
        byte[] buf = new byte[length];
        this.inputStream.read(buf);
        os.write(buf, 0, length);
        return os.toByteArray();
    }

    private void buildDictionary(int dicSize) throws XmlPullParserException, IOException {
        for (int i = 0; i < dicSize; ++i) {
            String[] word = new String[]{Integer.toString(this.readInteger()), this.readText()};
            this.wordDic.addElement(word);
        }
    }

    private int nextNode() throws XmlPullParserException, IOException {
        this.nodeApplied = false;
        if (this.processingEmptyElement) {
            this.node = 9;
            this.processingEmptyElement = false;
        } else {
            this.node = this.readNode();
        }
        return this.node;
    }

    private void applyNode() throws XmlPullParserException, IOException {
        System.out.println("apply node: " + Integer.toHexString(this.node) + ", nodeApplied=" + this.nodeApplied);
        if (this.nodeApplied) {
            throw new XmlPullParserException("already applied");
        }
        if (this.afterEndTag) {
            --this.depth;
            if (this.elementStack.size() > 0) {
                this.elementStack.pop();
            }
            this.afterEndTag = false;
        }
        int tag = this.node & 0xF;
        switch (tag) {
            case 1: 
            case 2: {
                byte attrNode;
                ++this.depth;
                Element elem = new Element();
                this.elementStack.push(elem);
                Namespace ns = this.readNamespace(this.node);
                String name = this.readName(this.node);
                if (ns != null) {
                    if (this.processNamespace) {
                        elem.namespaceUri = ns.namespaceUri;
                        elem.prefix = ns.prefix;
                        elem.name = name;
                    } else {
                        elem.name = (ns.prefix == null ? "" : ns.prefix + ":") + name;
                    }
                } else {
                    elem.name = name;
                }
                System.out.println("** elem: name=" + name + (ns != null ? ", namespace=" + ns.namespaceUri + ", prefix=" + ns.prefix : " no namespace"));
                this.attibutes = new Vector();
                if (!this.processNamespace) {
                    for (int i = 0; i < this.nsStack.size(); ++i) {
                        Namespace n = (Namespace)this.nsStack.elementAt(i);
                        if (n.depth > this.depth) break;
                        if (n.depth != this.depth) continue;
                        Attribute attr = new Attribute();
                        attr.name = "xmlns" + (n.prefix == null ? "" : ":" + n.prefix);
                        attr.value = n.namespaceUri;
                        this.attibutes.addElement(attr);
                    }
                }
                while (true) {
                    attrNode = this.readNode();
                    System.out.println("attrNode: " + Integer.toHexString(attrNode));
                    if ((attrNode & 0xF) != 3) break;
                    Attribute attr = new Attribute();
                    this.attibutes.addElement(attr);
                    Namespace attrNs = this.readNamespace(attrNode);
                    String attrName = this.readName(attrNode);
                    if (attrNs != null) {
                        if (this.processNamespace) {
                            attr.namespaceUri = attrNs.namespaceUri;
                            attr.prefix = attrNs.prefix;
                            attr.name = attrName;
                        } else {
                            attr.name = (attrNs.prefix == null ? "" : attrNs.prefix + ":") + attrName;
                        }
                    } else {
                        attr.name = attrName;
                    }
                    attr.value = this.readText();
                    System.out.println("** attr: name=" + attrName + ", value=" + attr.value + (attrNs != null ? ", namespace=" + attrNs.namespaceUri + ", prefix=" + attrNs.prefix : " no namespace"));
                }
                this.nextNode = attrNode;
                if (tag != 2) break;
                this.processingEmptyElement = true;
                break;
            }
            case 9: {
                this.afterEndTag = true;
                break;
            }
            case 15: {
                return;
            }
            case 4: {
                this.text = this.readText();
                break;
            }
            case 6: {
                this.cdata = this.readCDATA();
                break;
            }
            case 5: {
                this.readPrefixMapping(this.node);
                break;
            }
        }
        this.nodeApplied = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte readNode() throws XmlPullParserException, IOException {
        System.out.println("start read node: nextNode=" + Integer.toHexString(this.nextNode));
        if (this.nextNode == 0) {
            int node = this.inputStream.read();
            if (node == -1) {
                return 15;
            }
            return (byte)node;
        }
        try {
            byte by = this.nextNode;
            return by;
        }
        finally {
            this.nextNode = 0;
        }
    }

    private String readName(int node) throws XmlPullParserException, IOException {
        System.out.println("start read name");
        if ((node & 0x10) == 0) {
            int index = this.readInteger();
            for (int i = 0; i < this.wordDic.size(); ++i) {
                String[] word = (String[])this.wordDic.elementAt(i);
                int wordindex = Integer.parseInt(word[0]);
                if (wordindex != index) continue;
                return word[1];
            }
            return null;
        }
        return this.readText();
    }

    private Namespace readNamespace(int node) throws XmlPullParserException, IOException {
        int index;
        System.out.println("start read namespace");
        int n = index = (node & 0x20) != 0 ? this.readInteger() : 0;
        if (index == 0 && (node & 0xF) == 3) {
            return null;
        }
        return this.getNamespace(index);
    }

    private void readPrefixMapping(int node) throws XmlPullParserException, IOException {
        System.out.println("start read prefix mapping");
        Namespace ns = new Namespace();
        if ((node & 0x10) != 0) {
            ns.index = this.readInteger();
            ns.prefix = this.readText();
        }
        ns.namespaceUri = this.readText();
        ns.depth = this.depth + 1;
        this.nsStack.push(ns);
    }

    private Namespace getNamespace(int index) {
        for (int i = this.nsStack.size() - 1; i >= 0; --i) {
            Namespace ns = (Namespace)this.nsStack.elementAt(i);
            if (ns.depth > this.depth || ns.index != index) continue;
            return ns;
        }
        return null;
    }

    class IndexCountInputStream
    extends InputStream {
        private InputStream is;
        private int index;

        public IndexCountInputStream(InputStream in) {
            this.is = in;
        }

        public int read() throws IOException {
            ++this.index;
            int re = this.is.read();
            System.out.println("IndexCountInputStream: byte[" + this.index + "]=");
            Util.dumpBytes(new byte[]{(byte)re});
            return re;
        }
    }

    class NamespaceGroup {
        int depth;
        Hashtable namespaces = new Hashtable();

        NamespaceGroup() {
        }
    }

    class Namespace {
        int depth;
        int index;
        String prefix;
        String namespaceUri;

        Namespace() {
        }
    }

    class Attribute {
        String name;
        String namespaceUri = "";
        String prefix;
        String type;
        String value;

        Attribute() {
        }
    }

    class Element {
        String name;
        String namespaceUri = "";
        String prefix;

        Element() {
        }
    }
}

