/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.transform.util;

import jp.haw.grain.transform.util.TargetNode;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Util {
    public static void copyAttributes(Element source, Element dest) {
        NamedNodeMap attrs = source.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            if (attr.getNodeName().startsWith("xmlns")) {
                if ("http://www.w3.org/2002/xforms".equals(attr.getNodeValue()) || "http://www.w3.org/1999/xhtml".equals(attr.getNodeValue())) continue;
                if (attr.getNodeName().equals("xmlns")) {
                    String uri = attr.getNodeValue();
                    String prefix = uri.substring(uri.lastIndexOf("/") + 1);
                    String separate = ":";
                    if (uri == null || uri.equals("")) {
                        prefix = "";
                        separate = "";
                    } else if (uri.endsWith("/")) {
                        String[] prefixs = uri.split("/");
                        prefix = prefixs[prefixs.length - 1];
                    }
                    dest.setAttribute("xmlns" + separate + prefix, uri);
                    continue;
                }
            }
            if (attr.getNamespaceURI() != null) {
                dest.setAttributeNS(attr.getNamespaceURI(), attr.getNodeName(), attr.getNodeValue());
                continue;
            }
            dest.setAttribute(attr.getNodeName(), attr.getNodeValue());
        }
    }

    public static String normalizedString(String str) {
        return str.replaceAll("\t", "").replaceAll("\r", "").replaceAll("\n", "").trim();
    }

    public static boolean parentNodeAs(Node node, TargetNode target) {
        Node parent = node.getParentNode();
        if (parent == null) {
            return false;
        }
        if (target.equals(parent)) {
            return true;
        }
        return Util.parentNodeAs(parent, target);
    }

    public static void getTextContent(Element label, StringBuffer contentBuf) {
        if (!label.hasChildNodes()) {
            return;
        }
        NodeList list = label.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() == 3) {
                contentBuf.append(node.getNodeValue());
                continue;
            }
            if (node.getNodeType() != 1) continue;
            Util.getTextContent((Element)node, contentBuf);
        }
    }

    public static NodeList getNamedChildNode(Element current, String name) {
        return Util.getNamedChildNode(current, null, name);
    }

    public static NodeList getNamedChildNode(Element current, String namespaceURI, String name) {
        DocumentFragment df = current.getOwnerDocument().createDocumentFragment();
        NodeList list = current.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (child == null || child.getLocalName() == null || !child.getLocalName().equals(name)) continue;
            if (namespaceURI == null) {
                df.appendChild(child);
                continue;
            }
            if (!namespaceURI.equals(child.getNamespaceURI())) continue;
            df.appendChild(child);
        }
        return df.getChildNodes();
    }
}

