/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.deployer;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.DeployableMonitorListener;
import org.codehaus.cargo.container.internal.util.HttpUtils;
import org.codehaus.cargo.util.monitor.MonitoredObject;

public class URLDeployableMonitor
extends MonitoredObject
implements DeployableMonitor {
    private List listeners = new ArrayList();
    private URL pingURL;
    private HttpUtils httpUtils = new HttpUtils();
    private long timeout;

    public URLDeployableMonitor(URL pingURL) {
        this(pingURL, 20000L);
    }

    public URLDeployableMonitor(URL pingURL, long timeout) {
        this.timeout = timeout;
        this.pingURL = pingURL;
    }

    public void registerListener(DeployableMonitorListener listener) {
        this.listeners.add(listener);
    }

    public void monitor() {
        this.getMonitor().debug("Checking URL [" + this.pingURL + "] for status...", this.getClass().getName());
        HttpUtils.HttpResult results = new HttpUtils.HttpResult();
        if (this.httpUtils.ping(this.pingURL, results)) {
            this.getMonitor().debug("URL [" + this.pingURL + "] is responding...", this.getClass().getName());
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                DeployableMonitorListener listener = (DeployableMonitorListener)it.next();
                this.getMonitor().debug("Notifying monitor listener [" + listener + "]", this.getClass().getName());
                listener.deployed();
            }
        } else {
            this.getMonitor().debug("Status: response message [" + results.responseMessage + "], " + " response code [" + results.responseCode + "]", this.getClass().getName());
        }
    }

    public long getTimeout() {
        return this.timeout;
    }
}

