/*
 * Decompiled with CFR 0.152.
 */
package j2meunit.textui;

import j2meunit.framework.AssertionFailedError;
import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestFailure;
import j2meunit.framework.TestListener;
import j2meunit.framework.TestResult;
import j2meunit.util.StringUtil;
import j2meunit.util.Version;
import java.io.PrintStream;
import java.util.Enumeration;

public class TestRunner
implements TestListener {
    protected PrintStream fWriter = System.out;

    public TestRunner() {
    }

    public TestRunner(PrintStream printStream) {
        this.fWriter = printStream;
    }

    public synchronized void addError(Test test, Throwable throwable) {
        this.fWriter.print("E");
    }

    public synchronized void addFailure(Test test, AssertionFailedError assertionFailedError) {
        this.fWriter.print("F");
    }

    public void endTest(Test test) {
    }

    public void endTestStep(Test test) {
        this.fWriter.print(".");
    }

    public static void main(String[] stringArray) {
        System.out.println("TestRunner.main()");
        TestRunner testRunner = new TestRunner();
        testRunner.start(stringArray);
    }

    public synchronized void print(TestResult testResult) {
        this.printHeader(testResult);
        this.printErrors(testResult);
        this.printFailures(testResult);
    }

    public void printErrors(TestResult testResult) {
        if (testResult.errorCount() != 0) {
            if (testResult.errorCount() == 1) {
                this.fWriter.println("There was " + testResult.errorCount() + " error:");
            } else {
                this.fWriter.println("There were " + testResult.errorCount() + " errors:");
            }
            int n = 1;
            Enumeration enumeration = testResult.errors();
            while (enumeration.hasMoreElements()) {
                TestFailure testFailure = (TestFailure)enumeration.nextElement();
                this.fWriter.println(n + ") " + testFailure.failedTest());
                this.fWriter.println(testFailure.thrownException().getMessage());
                ++n;
            }
        }
    }

    public void printFailures(TestResult testResult) {
        if (testResult.failureCount() != 0) {
            if (testResult.failureCount() == 1) {
                this.fWriter.println("There was " + testResult.failureCount() + " failure:");
            } else {
                this.fWriter.println("There were " + testResult.failureCount() + " failures:");
            }
            int n = 1;
            Enumeration enumeration = testResult.failures();
            while (enumeration.hasMoreElements()) {
                TestFailure testFailure = (TestFailure)enumeration.nextElement();
                this.fWriter.print(n + ") " + testFailure.failedTest());
                Throwable throwable = testFailure.thrownException();
                if (throwable.getMessage() != null) {
                    this.fWriter.println(" \"" + StringUtil.truncate(throwable.getMessage(), 80) + "\"");
                } else {
                    this.fWriter.println();
                    this.fWriter.println(testFailure.thrownException().getMessage());
                }
                ++n;
            }
        }
    }

    public void printHeader(TestResult testResult) {
        if (testResult.wasSuccessful()) {
            this.fWriter.println();
            this.fWriter.print("OK");
            this.fWriter.println(" (" + testResult.runCount() + " tests)");
        } else {
            this.fWriter.println();
            this.fWriter.println("FAILURES!!!");
            this.fWriter.println("Test Results:");
            this.fWriter.println("Run: " + testResult.runCount() + " Failures: " + testResult.failureCount() + " Errors: " + testResult.errorCount());
        }
    }

    public static void run(Test test) {
        TestRunner testRunner = new TestRunner();
        testRunner.doRun(test);
    }

    public synchronized void startTest(Test test) {
        System.out.print(".");
    }

    protected TestResult createTestResult() {
        return new TestResult();
    }

    protected void doRun(Test test) {
        TestResult testResult = this.createTestResult();
        testResult.addListener(this);
        long l = System.currentTimeMillis();
        test.run(testResult);
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        this.fWriter.println();
        this.fWriter.println("Time: " + StringUtil.elapsedTimeAsString(l3));
        this.print(testResult);
        this.fWriter.println();
        if (!testResult.wasSuccessful()) {
            System.exit(-1);
        }
        System.exit(0);
    }

    protected String processArguments(String[] stringArray) {
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-v")) {
                System.out.println("J2ME Unit " + Version.id() + "by RoleModel Software, Inc. \nOriginal JUnit by Kent Beck and Erich Gamma");
                continue;
            }
            string = stringArray[i];
        }
        if (string.equals("")) {
            System.out.println("Usage: TestRunner testCaseName, where name is the name of the TestCase class");
            System.exit(-1);
        }
        return string;
    }

    protected void start(String[] stringArray) {
        String string = this.processArguments(stringArray);
        try {
            Class<?> clazz = Class.forName(string);
            TestCase testCase = (TestCase)clazz.newInstance();
            Test test = testCase.suite();
            this.doRun(test);
        }
        catch (Exception exception) {
            System.out.println("Could not create and run test suite");
            System.exit(-1);
        }
    }
}

