/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.divide;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import jp.haw.grain.divide.DataFolder;
import jp.haw.grain.divide.DividedData;
import org.apache.log4j.Logger;

public class WriteFolder
implements DataFolder,
Serializable {
    private static final Logger log = Logger.getLogger((Class)WriteFolder.class);
    protected int mode;
    protected String sessionId;
    protected String contentType;
    protected long createTime;
    protected long survivalTime;
    protected DividedData[] dataList;

    public static WriteFolder createFolder(String sessionId, byte[] data, int bufferSize) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(data));
        ArrayList<DividedData> datas = new ArrayList<DividedData>();
        byte[] buf = new byte[1];
        int no = 1;
        ByteArrayOutputStream dataOut = new ByteArrayOutputStream();
        while (in.read(buf) != -1) {
            dataOut.write(buf);
            if (dataOut.toByteArray().length != bufferSize) continue;
            datas.add(new DividedData(dataOut.toByteArray(), no));
            ++no;
            dataOut = new ByteArrayOutputStream();
        }
        if (dataOut.toByteArray().length > 0) {
            datas.add(new DividedData(dataOut.toByteArray(), no));
        }
        return new WriteFolder(datas.toArray(new DividedData[datas.size()]), sessionId);
    }

    private WriteFolder(DividedData[] dataList, String sessionId) {
        this.sessionId = sessionId;
        this.dataList = dataList;
        this.mode = 2;
        this.createTime = Calendar.getInstance().getTimeInMillis();
        this.survivalTime = 1800000L;
    }

    public DividedData getDataAt(int no) {
        log.debug((Object)("no=" + no));
        for (int i = 0; i < this.dataList.length; ++i) {
            if (this.dataList[i].getNo() != no) continue;
            return this.dataList[i];
        }
        return null;
    }

    public DividedData[] getDataList() {
        return this.dataList;
    }

    public int getMaxCount() {
        return this.dataList.length;
    }

    public int getMode() {
        return this.mode;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isSurvival() {
        long nowTime = Calendar.getInstance().getTimeInMillis();
        return nowTime <= this.createTime + this.survivalTime;
    }

    public void setSurvivalTime(long l) {
        this.survivalTime = l;
    }

    public long getSurvivalTime() {
        return this.survivalTime;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

