/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.framework.xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.haw.grain.framework.xml.BinaryXMLEncoder;
import jp.haw.grain.framework.xml.ParseException;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BinaryXMLOutputter {
    private static final Logger log = Logger.getLogger((Class)BinaryXMLOutputter.class);
    private InputSource source;
    private String encoding = "Shift-JIS";
    private String lineSeparator = "\n";

    public BinaryXMLOutputter(byte[] bs) {
        try {
            String header = new String(bs, 0, bs.length > 50 ? 50 : bs.length, "ISO-8859-1");
            this.parseEncoding(header);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.source = new InputSource(new ByteArrayInputStream(bs));
        log.debug((Object)("encoding=" + this.encoding));
    }

    public BinaryXMLOutputter(char[] cs) {
        this.source = new InputSource(new CharArrayReader(cs));
        String head = new String(cs, 0, cs.length > 50 ? 50 : cs.length);
        this.parseEncoding(head);
        log.debug((Object)("encoding=" + this.encoding));
    }

    public BinaryXMLOutputter(InputStream is) {
        this.source = new InputSource(is);
    }

    public BinaryXMLOutputter(Reader reader) {
        this.source = new InputSource(reader);
    }

    public BinaryXMLOutputter(String src) {
        this.source = new InputSource(new StringReader(src));
        this.parseEncoding(src);
        log.debug((Object)("encoding=" + this.encoding));
    }

    private void parseEncoding(String head) {
        if (!head.startsWith("<?xml")) {
            return;
        }
        Matcher m = Pattern.compile("encoding=\"([^\"]*)\"").matcher(head);
        if (m.find() && m.groupCount() > 0) {
            this.setTextEncoding(m.group(1));
        }
    }

    public void setLineSeparator(String separator) {
        this.lineSeparator = separator;
    }

    public void setTextEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void writeTo(OutputStream os) throws IOException, ParseException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            log.debug((Object)("SAXParser: " + parser.getClass().getName()));
            log.debug((Object)("char stream: " + this.source.getCharacterStream()));
            log.debug((Object)("output stream: " + os.getClass().getName()));
            BinaryXMLEncoder enc = new BinaryXMLEncoder(this.encoding);
            parser.parse(this.source, (DefaultHandler)enc);
            enc.writeTo(os);
        }
        catch (SAXException e) {
            log.debug((Object)e.toString(), (Throwable)e);
            throw new ParseException(e);
        }
        catch (ParserConfigurationException e) {
            log.debug((Object)e.toString(), (Throwable)e);
            throw new ParseException(e);
        }
        catch (FactoryConfigurationError e) {
            log.debug((Object)e.toString(), (Throwable)e);
            throw new ParseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("ussage: encoding infile(xml) outfile(gbxml)");
            System.exit(1);
        }
        InputStream is = null;
        OutputStream os = null;
        try {
            is = new BufferedInputStream(new FileInputStream(args[1]));
            BinaryXMLOutputter bxo = new BinaryXMLOutputter(is);
            bxo.setTextEncoding(args[0]);
            os = new BufferedOutputStream(new FileOutputStream(args[2]));
            bxo.writeTo(os);
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException ie) {
                    ie.printStackTrace();
                }
            }
        }
    }
}

