/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.framework.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import javax.mail.MessagingException;
import jp.haw.grain.framework.xml.BinaryXMLParser;
import jp.haw.grain.framework.xml.Util;
import org.apache.log4j.Logger;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XMLOutputter {
    private static final Logger log = Logger.getLogger((Class)XMLOutputter.class);
    private BinaryXMLParser parser;
    private boolean versionread = false;

    public XMLOutputter(byte[] bs, String encoding) {
        this(new ByteArrayInputStream(bs), encoding);
    }

    public XMLOutputter(InputStream is) {
        this(is, null);
    }

    public XMLOutputter(InputStream is, String encoding) {
        this.parser = BinaryXMLParser.newInstance(is, encoding);
    }

    public String getEncoding() {
        return this.parser.getInputEncoding();
    }

    public boolean isEndOfDocument() {
        return this.parser.getEventType() == 1;
    }

    public void writeTo(Writer writer) throws IOException, XmlPullParserException {
        int et = this.parser.getEventType();
        while (et != 1) {
            if (et == 2) {
                if (!this.versionread) {
                    writer.write("<?xml version=\"");
                    writer.write(this.parser.getProperty("http://xmlpull.org/v1/doc/properties.html#xmldecl-version").toString());
                    writer.write("\" encoding=\"");
                    writer.write(this.parser.getInputEncoding());
                    writer.write("\" ?>\n");
                    this.versionread = true;
                }
                log.debug((Object)"start tag name: ");
                writer.write(60);
                this.writeNameWithPrefix(writer);
                this.writePrefixMappings(writer);
                this.writeAttributes(writer);
                if (this.parser.isEmptyElementTag()) {
                    writer.write("/>\n");
                    et = this.parser.next();
                } else {
                    writer.write(">\n");
                }
            } else if (et == 3) {
                writer.write("</");
                log.debug((Object)"end tag name: ");
                this.writeNameWithPrefix(writer);
                writer.write(">\n");
            } else if (et == 4) {
                writer.write(this.parser.getText());
                writer.write("\n");
                log.debug((Object)this.parser.getText());
            }
            et = this.parser.next();
        }
        log.debug((Object)writer.toString());
    }

    public void writeNextTagTo(Writer writer) throws XmlPullParserException, IOException {
        int et = this.parser.next();
        if (et == 2) {
            if (!this.versionread) {
                writer.write("<?xml version=\"");
                writer.write(this.parser.getProperty("http://xmlpull.org/v1/doc/properties.html#xmldecl-version").toString());
                writer.write("\" encoding=\"");
                writer.write(this.parser.getInputEncoding());
                writer.write("\"?>\n");
                this.versionread = true;
            }
            log.debug((Object)"start tag name: ");
            writer.write(60);
            this.writeNameWithPrefix(writer);
            this.writePrefixMappings(writer);
            this.writeAttributes(writer);
            if (this.parser.isEmptyElementTag()) {
                writer.write("/>");
                et = this.parser.next();
            } else {
                writer.write(">");
            }
        } else if (et == 3) {
            writer.write("</");
            log.debug((Object)"end tag name: ");
            this.writeNameWithPrefix(writer);
            writer.write(">");
        } else if (et == 4) {
            writer.write(this.parser.getText());
            log.debug((Object)this.parser.getText());
        } else if (et == 6) {
            writer.write("<![CDATA[");
            try {
                writer.write(Util.encodeBase64(this.parser.getCDATA()));
            }
            catch (MessagingException me) {
                throw new XmlPullParserException("CDATA to base64 encoding error", (XmlPullParser)this.parser, (Throwable)me);
            }
            writer.write("]]>");
            byte[] data = this.parser.getCDATA();
            String hex = "";
            for (int i = 0; i < data.length; ++i) {
                hex = hex + Integer.toHexString(data[i]);
                hex = hex + ":";
            }
            log.debug((Object)("CDATA[" + this.parser.getCDATA().length + "]"));
        }
        log.debug((Object)writer.toString());
    }

    private void writeNameWithPrefix(Writer writer) throws IOException, XmlPullParserException {
        String prefix = this.getCurrentPrefix();
        if (prefix != null && prefix.length() > 0) {
            writer.write(prefix);
            writer.write(58);
            log.debug((Object)(prefix + ":"));
        }
        writer.write(this.parser.getName());
        log.debug((Object)this.parser.getName());
    }

    private String getCurrentPrefix() throws XmlPullParserException {
        String elementNs = this.parser.getNamespace();
        int nsCount = this.parser.getNamespaceCount(this.parser.getDepth());
        for (int i = 0; i < nsCount; ++i) {
            if (!this.parser.getNamespaceUri(i).equals(elementNs)) continue;
            return this.parser.getNamespacePrefix(i);
        }
        return "";
    }

    private void writePrefixMappings(Writer writer) throws IOException, XmlPullParserException {
        int nsParentCount;
        int nsCount = this.parser.getNamespaceCount(this.parser.getDepth());
        if (nsCount > (nsParentCount = this.parser.getNamespaceCount(this.parser.getDepth() - 1))) {
            for (int i = nsParentCount; i < nsCount; ++i) {
                String prefix = this.parser.getNamespacePrefix(i);
                String uri = this.parser.getNamespaceUri(i);
                writer.write(" xmlns");
                if (prefix != null) {
                    writer.write(58);
                    writer.write(prefix);
                }
                writer.write("=\"");
                writer.write(uri);
                writer.write(34);
            }
        }
    }

    private void writeAttributes(Writer writer) throws IOException {
        int attcount = this.parser.getAttributeCount();
        for (int i = 0; i < attcount; ++i) {
            writer.write(32);
            if (this.parser.getAttributePrefix(i) != null) {
                writer.write(this.parser.getAttributePrefix(i));
                writer.write(58);
            }
            log.debug((Object)("attr [" + i + "]prefix:" + this.parser.getAttributePrefix(i)));
            writer.write(this.parser.getAttributeName(i));
            log.debug((Object)("attr [" + i + "]name:" + this.parser.getAttributeName(i)));
            writer.write("=\"");
            writer.write(this.parser.getAttributeValue(i));
            log.debug((Object)("attr [" + i + "]value:" + this.parser.getAttributeValue(i)));
            writer.write(34);
        }
    }
}

