/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.ant;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.codehaus.cargo.ant.ConfigurationElement;
import org.codehaus.cargo.ant.PropertySet;
import org.codehaus.cargo.ant.ZipURLInstallerElement;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerFactory;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.installer.ZipURLInstaller;
import org.codehaus.cargo.util.monitor.FileMonitor;

public class CargoTask
extends Task {
    private static final String ACTION_START = "start";
    private static final String ACTION_STOP = "stop";
    private String action;
    private String id;
    private Reference refid;
    private String containerKey;
    private Map systemProperties = new HashMap();
    private Path extraClasspath;
    private File output;
    private File log;
    private boolean append;
    private File homeDir;
    private long timeout = 60000L;
    private ZipURLInstallerElement zipURLInstallerElement;
    private ConfigurationElement configurationElement;
    private ContainerFactory factory = new ContainerFactory();

    public void setAction(String action) {
        this.action = action;
    }

    public void setContainerKey(String containerKey) {
        this.containerKey = containerKey;
    }

    public final void setHomeDir(File homeDir) {
        this.homeDir = homeDir;
    }

    public final void setId(String id) {
        this.id = id;
    }

    public final void setRefId(Reference refid) {
        this.refid = refid;
    }

    public final ZipURLInstallerElement createZipURLInstaller() {
        if (this.getZipURLInstaller() == null) {
            this.zipURLInstallerElement = new ZipURLInstallerElement();
        }
        return this.zipURLInstallerElement;
    }

    public final ConfigurationElement createConfiguration() {
        if (this.getConfiguration() == null) {
            this.configurationElement = new ConfigurationElement();
        }
        return this.configurationElement;
    }

    public final void setOutput(File output) {
        this.output = output;
    }

    public final void setLog(File log) {
        this.log = log;
    }

    public final void setAppend(boolean isAppend) {
        this.append = isAppend;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public Path createExtraClasspath() {
        if (this.getExtraClasspath() == null) {
            this.extraClasspath = new Path(this.getProject());
        }
        return this.extraClasspath.createPath();
    }

    public void addSysproperty(Environment.Variable property) {
        this.getSystemProperties().put(property.getKey(), property.getValue());
    }

    public void addConfiguredSyspropertyset(PropertySet propertySet) {
        ResourceBundle bundle = propertySet.readProperties();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Environment.Variable var = new Environment.Variable();
            var.setKey(key);
            var.setValue(bundle.getString(key));
            this.addSysproperty(var);
        }
    }

    public void addConfiguredSysproperty(Environment.Variable property) {
        this.addSysproperty(property);
    }

    public void execute() {
        Container container = this.getContainer();
        this.verify(container);
        this.setupMonitor(container);
        this.setupOutput(container);
        this.setupConfiguration(container);
        this.setupTimeout(container);
        this.setupHomeDir(container);
        this.setupExtraClasspath(container);
        this.setupSystemProperties(container);
        if (this.getId() != null) {
            this.getProject().addReference(this.getId(), (Object)container);
        }
        this.executeActions(container);
    }

    protected void executeActions(Container container) {
        if (this.getAction() != null) {
            if (this.getAction().equalsIgnoreCase(ACTION_START)) {
                container.start();
            } else if (this.getAction().equalsIgnoreCase(ACTION_STOP)) {
                container.stop();
            }
        }
    }

    protected void setupMonitor(Container container) {
        if (this.getLog() != null) {
            FileMonitor monitor = new FileMonitor(this.getLog(), false);
            container.setMonitor(monitor);
        }
    }

    protected void setupOutput(Container container) {
        if (this.getOutput() != null) {
            container.setOutput(this.getOutput());
        }
        if (this.isAppend()) {
            container.setAppend(true);
        }
    }

    protected void setupTimeout(Container container) {
        if (this.getTimeout() != container.getTimeout()) {
            container.setTimeout(this.getTimeout());
        }
    }

    protected void setupConfiguration(Container container) {
        if (this.getConfiguration() != null) {
            Configuration configuration = this.getConfiguration().createConfiguration(container);
            if (this.getLog() != null) {
                configuration.setMonitor(container.getMonitor());
            }
            container.setConfiguration(configuration);
        }
    }

    protected void setupHomeDir(Container container) {
        if (this.getHomeDir() != null) {
            container.setHomeDir(this.getHomeDir());
        } else if (this.getZipURLInstaller() != null) {
            ZipURLInstaller installer = this.getZipURLInstaller().createInstaller();
            if (this.getLog() != null) {
                installer.setMonitor(container.getMonitor());
            }
            installer.install();
            container.setHomeDir(installer.getHomeDir());
        }
    }

    protected void setupExtraClasspath(Container container) {
        if (this.getExtraClasspath() != null) {
            container.setExtraClasspath(this.getExtraClasspath().list());
        }
    }

    protected void setupSystemProperties(Container container) {
        if (!this.getSystemProperties().isEmpty()) {
            container.setSystemProperties(this.getSystemProperties());
        }
    }

    protected final Map getSystemProperties() {
        return this.systemProperties;
    }

    protected final ZipURLInstallerElement getZipURLInstaller() {
        return this.zipURLInstallerElement;
    }

    protected final ConfigurationElement getConfiguration() {
        return this.configurationElement;
    }

    protected final Path getExtraClasspath() {
        return this.extraClasspath;
    }

    protected final long getTimeout() {
        return this.timeout;
    }

    protected final File getOutput() {
        return this.output;
    }

    protected final File getLog() {
        return this.log;
    }

    protected final File getHomeDir() {
        return this.homeDir;
    }

    protected final boolean isAppend() {
        return this.append;
    }

    protected final String getAction() {
        return this.action;
    }

    protected Container getContainer() {
        Container container;
        if (this.getRefid() != null) {
            Object o = this.getRefid().getReferencedObject(this.getProject());
            if (!(o instanceof Container)) {
                throw new BuildException("The [refid] attribute must point to a container reference, it is pointing to a [" + o.getClass().getName() + "] object");
            }
            container = (Container)o;
        } else {
            container = this.factory.createContainer(this.containerKey);
        }
        return container;
    }

    protected String getContainerKey() {
        return this.containerKey;
    }

    protected String getId() {
        return this.id;
    }

    protected Reference getRefid() {
        return this.refid;
    }

    private void verify(Container container) {
        if (this.getId() != null && this.getRefid() != null) {
            throw new BuildException("You must use either [id] or [idref] but not both");
        }
        if (this.getContainerKey() == null && this.getRefid() == null) {
            throw new BuildException("You must specify either a [containerClass] attribute pointing to a class implementing the " + Container.class.getName() + " interface or use a [refid] attribute");
        }
        if (this.getId() == null && this.getAction() == null) {
            throw new BuildException("You must specify an [action] attribute with values [start] or [stop]");
        }
        if (this.getAction() != null && !this.getAction().equalsIgnoreCase(ACTION_START) && !this.getAction().equalsIgnoreCase(ACTION_STOP)) {
            throw new BuildException("Valid actions are: [start] and [stop]");
        }
        if (this.getHomeDir() == null && this.getZipURLInstaller() == null && (this.getRefid() == null || this.getRefid() != null && container.getHomeDir() == null)) {
            throw new BuildException("You must specify either a [homeDir] attribute pointing to the location where the " + this.getContainer().getName() + " is installed, or a nested <zipurlinstaller> element");
        }
    }
}

