/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.internal.util.AntUtils;
import org.codehaus.cargo.container.internal.util.ResourceUtils;
import org.codehaus.cargo.container.spi.ContainerConfiguration;
import org.codehaus.cargo.util.FileUtils;
import org.codehaus.cargo.util.monitor.MonitoredObject;

public abstract class AbstractConfiguration
extends MonitoredObject
implements ContainerConfiguration {
    protected static final String RESOURCE_PATH = "/org/codehaus/cargo/container/internal/resources/";
    private File dir;
    private Map properties;
    private Container container;
    private AntUtils antUtils;
    private ResourceUtils resourceUtils;
    private FileUtils fileUtils = new FileUtils();

    public AbstractConfiguration(Container container, File dir) {
        this.antUtils = new AntUtils();
        this.resourceUtils = new ResourceUtils();
        this.properties = new HashMap();
        this.container = container;
        this.dir = dir;
        this.setProperty("cargo.hostname", "localhost");
        this.setProperty("cargo.servlet.port", "8080");
    }

    public Container getContainer() {
        return this.container;
    }

    protected final FileUtils getFileUtils() {
        return this.fileUtils;
    }

    protected final AntUtils getAntUtils() {
        return this.antUtils;
    }

    protected final ResourceUtils getResourceUtils() {
        return this.resourceUtils;
    }

    public File getDir() {
        return this.dir;
    }

    public void setProperty(String name, String value) {
        this.getMonitor().debug("Setting property [" + name + "] = [" + value + "]", this.getClass().getName());
        this.properties.put(name, value);
    }

    public Map getProperties() {
        return this.properties;
    }

    public String getPropertyValue(String name) {
        return (String)this.properties.get(name);
    }
}

