/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.internal.util.HintKey;

public abstract class AbstractGenericHintFactory {
    private Map mappings = new HashMap();

    protected AbstractGenericHintFactory() {
    }

    protected void registerImplementation(String containerId, String hint, Class implementationClass) {
        HintKey key = new HintKey(containerId, hint);
        this.mappings.put(key, implementationClass);
    }

    protected Object createImplementation(Container container, String hint, GenericParameters parameters, String implementationConceptName) {
        Object implementation;
        HintKey key = new HintKey(container.getId(), hint);
        if (!this.mappings.containsKey(key)) {
            throw new ContainerException("Cannot create " + implementationConceptName + ". Unknown container id [" + container.getId() + "] or unknown hint [" + hint + "]");
        }
        Class implementationClass = (Class)this.mappings.get(key);
        try {
            Constructor constructor = this.getConstructor(implementationClass, parameters);
            implementation = this.createInstance(constructor, container, parameters);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create " + implementationConceptName + " for container id [" + container.getId() + "] and hint [" + hint + "]", e);
        }
        return implementation;
    }

    protected abstract Constructor getConstructor(Class var1, GenericParameters var2) throws NoSuchMethodException;

    protected abstract Object createInstance(Constructor var1, Container var2, GenericParameters var3) throws Exception;

    public static interface GenericParameters {
    }
}

