/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.pseudoserver;

import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.pseudoserver.ReceivedHttpMessage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;

class HttpRequest
extends ReceivedHttpMessage {
    private String _protocol;
    private String _command;
    private String _uri;
    private Hashtable _parameters;

    HttpRequest(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    void interpretMessageHeader(String messageHeader) {
        StringTokenizer st = new StringTokenizer(messageHeader);
        this._command = st.nextToken();
        this._uri = st.nextToken();
        this._protocol = st.nextToken();
    }

    void appendMessageHeader(StringBuffer sb) {
        sb.append(this._command).append(' ').append(this._uri).append(' ').append(this._protocol);
    }

    public String getCommand() {
        return this._command;
    }

    public String getURI() {
        return this._uri;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public String[] getParameter(String name) {
        if (this._parameters == null) {
            this._parameters = this._command.equalsIgnoreCase("GET") || this._command.equalsIgnoreCase("HEAD") ? this.readParameters(this.getParameterString(this._uri)) : this.readParameters(new String(this.getBody()));
        }
        return (String[])this._parameters.get(name);
    }

    private String getParameterString(String uri) {
        return uri.indexOf(63) < 0 ? "" : uri.substring(uri.indexOf(63) + 1);
    }

    boolean wantsKeepAlive() {
        if ("Keep-alive".equalsIgnoreCase(this.getConnectionHeader())) {
            return true;
        }
        if (this._protocol.equals("HTTP/1.1")) {
            return !"Close".equalsIgnoreCase(this.getConnectionHeader());
        }
        return false;
    }

    private Hashtable readParameters(String content) {
        Hashtable parameters = new Hashtable();
        if (content == null || content.trim().length() == 0) {
            return parameters;
        }
        StringTokenizer st = new StringTokenizer(content, "&=");
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            if (!st.hasMoreTokens()) continue;
            this.addParameter(parameters, HttpUnitUtils.decode(name), HttpUnitUtils.decode(st.nextToken()));
        }
        return parameters;
    }

    private void addParameter(Hashtable parameters, String name, String value) {
        String[] oldValues = (String[])parameters.get(name);
        if (oldValues == null) {
            parameters.put(name, new String[]{value});
        } else {
            String[] values = new String[oldValues.length + 1];
            System.arraycopy(oldValues, 0, values, 0, oldValues.length);
            values[oldValues.length] = value;
            parameters.put(name, values);
        }
    }

    private String getConnectionHeader() {
        return this.getHeader("Connection");
    }
}

