/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.container.resin;

import java.io.File;
import java.io.IOException;
import org.apache.cactus.integration.ant.container.AbstractJavaContainer;
import org.apache.cactus.integration.ant.util.ResourceUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public abstract class AbstractResinContainer
extends AbstractJavaContainer {
    private File dir;
    private File resinConf;
    private int port = 8080;
    private File tmpDir;
    static /* synthetic */ Class class$org$apache$cactus$integration$ant$container$resin$ResinRun;

    public final void setDir(File theDir) {
        this.dir = theDir;
    }

    public final void setTmpDir(File theTmpDir) {
        this.tmpDir = theTmpDir;
    }

    public final void setResinConf(File theResinConf) {
        this.resinConf = theResinConf;
    }

    public final void setPort(int thePort) {
        this.port = thePort;
    }

    public void verify() {
        if (this.getDir() == null) {
            throw new BuildException("You must specify the mandatory [dir] attribute");
        }
        if (!this.getDir().isDirectory()) {
            throw new BuildException("[" + this.getDir() + "] is not a directory");
        }
    }

    public final int getPort() {
        return this.port;
    }

    public final void init() {
        this.verify();
    }

    public final void startUp() {
        try {
            File installDir = this.setupTempDirectory(this.getTmpDir(), "cactus/" + this.getContainerDirName());
            this.cleanTempDirectory(installDir);
            this.prepare(installDir);
            Java java = this.createJavaForStartUp();
            java.addSysproperty(this.createSysProperty("resin.home", installDir));
            Path classpath = java.createClasspath();
            classpath.createPathElement().setLocation(ResourceUtils.getResourceLocation("/" + (class$org$apache$cactus$integration$ant$container$resin$ResinRun == null ? (class$org$apache$cactus$integration$ant$container$resin$ResinRun = AbstractResinContainer.class$("org.apache.cactus.integration.ant.container.resin.ResinRun")) : class$org$apache$cactus$integration$ant$container$resin$ResinRun).getName().replace('.', '/') + ".class"));
            FileSet fileSet = new FileSet();
            fileSet.setDir(this.getDir());
            fileSet.createInclude().setName("lib/*.jar");
            classpath.addFileset(fileSet);
            java.setClassname((class$org$apache$cactus$integration$ant$container$resin$ResinRun == null ? (class$org$apache$cactus$integration$ant$container$resin$ResinRun = AbstractResinContainer.class$("org.apache.cactus.integration.ant.container.resin.ResinRun")) : class$org$apache$cactus$integration$ant$container$resin$ResinRun).getName());
            java.createArg().setValue("-start");
            java.createArg().setValue("-conf");
            java.createArg().setFile(new File(installDir, "resin.conf"));
            this.startUpAdditions(java, classpath);
            java.execute();
        }
        catch (IOException ioe) {
            this.getLog().error((Object)"Failed to startup the container", (Throwable)ioe);
            throw new BuildException((Throwable)ioe);
        }
    }

    public final void shutDown() {
        File installDir = this.setupTempDirectory(this.getTmpDir(), "cactus/" + this.getContainerDirName());
        Java java = this.createJavaForShutDown();
        java.setFork(true);
        java.addSysproperty(this.createSysProperty("resin.home", installDir));
        Path classpath = java.createClasspath();
        classpath.createPathElement().setLocation(ResourceUtils.getResourceLocation("/" + (class$org$apache$cactus$integration$ant$container$resin$ResinRun == null ? (class$org$apache$cactus$integration$ant$container$resin$ResinRun = AbstractResinContainer.class$("org.apache.cactus.integration.ant.container.resin.ResinRun")) : class$org$apache$cactus$integration$ant$container$resin$ResinRun).getName().replace('.', '/') + ".class"));
        FileSet fileSet = new FileSet();
        fileSet.setDir(this.getDir());
        fileSet.createInclude().setName("lib/*.jar");
        classpath.addFileset(fileSet);
        java.setClassname((class$org$apache$cactus$integration$ant$container$resin$ResinRun == null ? (class$org$apache$cactus$integration$ant$container$resin$ResinRun = AbstractResinContainer.class$("org.apache.cactus.integration.ant.container.resin.ResinRun")) : class$org$apache$cactus$integration$ant$container$resin$ResinRun).getName());
        java.createArg().setValue("-stop");
        java.execute();
    }

    protected abstract void startUpAdditions(Java var1, Path var2);

    protected abstract void prepareAdditions(File var1, FilterChain var2) throws IOException;

    protected abstract String getContainerDirName();

    protected final File getDir() {
        return this.dir;
    }

    protected final File getTmpDir() {
        return this.tmpDir;
    }

    private void prepare(File theInstallDir) throws IOException {
        FileUtils fileUtils = FileUtils.newFileUtils();
        FilterChain filterChain = this.createFilterChain();
        if (this.resinConf != null) {
            fileUtils.copyFile(this.resinConf, new File(theInstallDir, "resin.conf"));
        } else {
            ResourceUtils.copyResource(this.getProject(), "/org/apache/cactus/integration/ant/container/resources/" + this.getContainerDirName() + "/resin.conf", new File(theInstallDir, "resin.conf"), filterChain);
        }
        if (this.getDeployableFile() != null) {
            File webappsDir = this.createDirectory(theInstallDir, "webapps");
            fileUtils.copyFile(this.getDeployableFile().getFile(), new File(webappsDir, this.getDeployableFile().getFile().getName()), null, true);
        }
        this.prepareAdditions(theInstallDir, filterChain);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

