/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2005/05/06
 *
 */
package jp.haw.grain.framework.servlet;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import jp.haw.grain.divide.DataFolder;
import jp.haw.grain.divide.DividedData;
import jp.haw.grain.divide.ReadFolder;
import jp.haw.grain.divide.WriteFolder;
import jp.haw.grain.framework.xml.BinaryXMLInputStream;
import jp.haw.grain.framework.xml.BinaryXMLOutputter;
import jp.haw.grain.framework.xml.BinaryXMLReader;
import jp.haw.grain.framework.xml.ParseException;
import jp.haw.grain.framework.xml.XMLOutputter;
import jp.haw.grain.transform.GudConverter;
import jp.haw.grain.transform.GudTransformException;

import org.apache.log4j.Logger;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * Grain Sprout̗vɑ΂郌X|XXML̏ꍇoCi`ɕϊB
 * 
 * @version $Id: BinaryXMLFilter.java 265 2006-04-18 14:05:28Z go $
 * @author go
 */
public class BinaryXMLFilter implements Filter {

	private static final Logger log = Logger.getLogger(BinaryXMLFilter.class);

	public static final Pattern XML_CONTENT_TYPE_PATTERN = Pattern.compile("^\\w*/xml");
	public static final Pattern CONTENT_TYPE_PATTERN = Pattern.compile("^(.*?)(; ?charset=(.*))?$");

	public static final String DEFAULT_CHARSET = "ISO-8859-1";
	public static final String GBXML_CONTENT_TYPE = "application/gbxml";

	//Mpwb_name
	public static final String DIVIDE_TRANSFER = "X-Divide-Transfer";
	public static final String DIVIDE_COUNT = "X-Divide-Count";
	public static final String DIVIDE_MAX_DOUNT = "X-Divide-Max-Count";
	public static final String DIVIDE_SESSION_ID = "X-Divide-Session-ID";
	public static final String DIVIDE_CONTENT_TYPE = "X-Content-Type";
	public static final String DIVIDE_PROTOCOL_VERSION = "X-Divide-Protocol-Version";	

	//MvgRo[Wԍ
	public static final String DIVIDE_PROTOCOL_VERSION_NO = "1.0";

	private String textEncoding = "UTF-8";
	private boolean ignoreRequestContentType = false;
	private int divideBufferSize;
	private long survivalTime;
	private static Map session = Collections.synchronizedMap(new HashMap());

	public void init(FilterConfig config) throws ServletException {
		String textEncoding = config.getInitParameter("TextEncoding");
		if (textEncoding != null)
			this.textEncoding = textEncoding;
		String ignoreRequestContentType = config.getInitParameter("IgnoreRequestContentType");
		if ("true".equals(ignoreRequestContentType))
			this.ignoreRequestContentType = true;

		//X|Xf[^̕TCY
		String divideBufferSize = config.getInitParameter("divideBufferSize");
		try {
			log.debug("divideBufferSize=" + divideBufferSize);
			this.divideBufferSize = Integer.parseInt(divideBufferSize);
		} catch (NumberFormatException e) {
			this.divideBufferSize = 10240; //10kbɂ
		}

		//f[^tH_̐
		String survivalTime = config.getInitParameter("survivalTime");
		try {
			this.survivalTime = Long.parseLong(survivalTime);
		} catch (NumberFormatException e) {
			this.survivalTime = 60 * 30 * 1000; //30ɂ
		}

	}

	/** 
	 * NGXgContent-Typewb_ "application/gbxml" ŁA Response  Content-Type  "?/xml" ̏ꍇA
	 * ResponseXMLf[^oCiXMLɕϊB<br>
	 * ADojał́AGET̏ꍇAContent-Typewb_ݒłȂB̏ꍇ́AInitParam
	 * IgnoreRequestContentTypetrueݒ肵AׂẴNGXgϊΏۂɂ邱ƁB
	 * 
	 * TODO ̔@̒B
	 * 
	 */
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
		String contentType = ((HttpServletRequest)request).getContentType();
		log.debug("Request Content-Type: " + contentType);
		try {
			BinaryXMLEncodedServletRequest xmlRequest = new BinaryXMLEncodedServletRequest((HttpServletRequest)request);
			BinaryXMLEncodedServletResponse xmlResponse = new BinaryXMLEncodedServletResponse((HttpServletResponse)response);
			xmlResponse.setDivideBufferSize(getDivideBufferSize());
			xmlResponse.setSurvivalTime(getFolderSurvivalTime());
			
			
			//gud tH[}bgvZbg
			xmlResponse.setExpectGud("gud".equals(xmlRequest.getHeader("X-expect-FO")));
			//f[^tH_̐
			BinaryXMLFilter.refreshFolder();

			//M̃`FbN
			log.debug("transfer="+xmlRequest.getHeader(DIVIDE_TRANSFER));
			log.debug("sessionId="+xmlRequest.getHeader(BinaryXMLFilter.DIVIDE_SESSION_ID));
			log.debug("count="+xmlRequest.getHeader(DIVIDE_COUNT));
			if ("start".equals(xmlRequest.getHeader(DIVIDE_TRANSFER))) {
				log.debug("Divide Read Transfer Start!");
				//MJnȂ̂readFolder𐶐B
				String sessionId = generateSessionId();
				ReadFolder readFolder = new ReadFolder(sessionId, xmlRequest.getIntHeader(DIVIDE_MAX_DOUNT), xmlRequest.getHeader(DIVIDE_CONTENT_TYPE));
				readFolder.setSurvivalTime(getFolderSurvivalTime());

				//f[^mapɓo^A200 OK ԂB
				readFolder.addData(createDividedData(xmlRequest));
				session.put(sessionId, readFolder);
				
				HttpServletResponse httpResponse = (HttpServletResponse)response;
				httpResponse.setHeader(BinaryXMLFilter.DIVIDE_SESSION_ID, sessionId);
				httpResponse.setHeader(BinaryXMLFilter.DIVIDE_PROTOCOL_VERSION, BinaryXMLFilter.DIVIDE_PROTOCOL_VERSION_NO); //protocol-version
				httpResponse.getOutputStream().close();
				log.debug("addHeader:"+BinaryXMLFilter.DIVIDE_SESSION_ID+":"+sessionId);
				log.debug("addHeader:"+BinaryXMLFilter.DIVIDE_PROTOCOL_VERSION+":"+BinaryXMLFilter.DIVIDE_PROTOCOL_VERSION_NO);
				return;
			} else if ("end".equals(xmlRequest.getHeader(DIVIDE_TRANSFER))) {
				//M̏IȂ̂ŁA܂ł̃f[^ƌbodyStreamɃZbg
				DataFolder folder = getFolder(xmlRequest);
				if (folder.getMode() != DataFolder.MODE_READ) //folderMpł͂Ȃ̂ŃG[
					throw new ServletException("folder is not read mode: sessionId=" + folder.getSessionId());
				ReadFolder readFolder = (ReadFolder)folder;
				readFolder.addData(createDividedData(xmlRequest));

				session.remove(((HttpServletRequest)request).getHeader(DIVIDE_SESSION_ID));
				
				xmlRequest.acceptFolder(readFolder);
			} else if (xmlRequest.getHeader(DIVIDE_SESSION_ID) != null) {
				//sessionIdwb_ɂ̂ŃtH_[擾Ă݂B
				DataFolder folder = getFolder(xmlRequest);
				if (folder.getMode() == DataFolder.MODE_READ) {
					log.debug("Divide READ-MODE Continue");
					//read[hȂ̂ŁANGXg̃f[^tH_ɒǉďIB
					ReadFolder readFolder = (ReadFolder)folder;
					readFolder.addData(createDividedData(xmlRequest));
					HttpServletResponse httpResponse = (HttpServletResponse)response;
					httpResponse.setHeader(DIVIDE_TRANSFER, "continu-read"); //transfer: 
					httpResponse.setHeader(DIVIDE_PROTOCOL_VERSION, DIVIDE_PROTOCOL_VERSION_NO); //protocol-version
					httpResponse.getOutputStream().close();
					
					log.debug("addHeader:"+DIVIDE_PROTOCOL_VERSION+": "+DIVIDE_PROTOCOL_VERSION_NO);
					return;
				} else {
					log.debug("WriteFolder output:" + xmlRequest.getHeader(DIVIDE_COUNT));
					//write[hȂ̂ŁAwb_ɐݒ肳ꂽcount̃f[^ԂB
					WriteFolder writeFolder = (WriteFolder)folder;
					DividedData data = writeFolder.getDataAt(xmlRequest.getIntHeader(DIVIDE_COUNT));
					//tH_̕f[^͂łɓK؂Ȍ`ɕϊĂ͂Ȃ̂ł̂܂ܕԂB
					HttpServletResponse httpResponse = (HttpServletResponse)response;
					httpResponse.setHeader(DIVIDE_COUNT, xmlRequest.getHeader(DIVIDE_COUNT)); // count
					httpResponse.setHeader(DIVIDE_CONTENT_TYPE, writeFolder.getContentType()); // content-type
					httpResponse.setHeader(DIVIDE_PROTOCOL_VERSION, DIVIDE_PROTOCOL_VERSION_NO); //protocol-version
					if (writeFolder.getMaxCount() == xmlRequest.getIntHeader(DIVIDE_COUNT)) {
						httpResponse.setHeader(DIVIDE_TRANSFER, "end"); // transfer: end
					}
					OutputStream out = response.getOutputStream();
					out.write(data.getData());
					out.close();

					return;
				}
			}

			chain.doFilter(xmlRequest, xmlResponse);
			xmlResponse.commit();
		} catch (ParseException e) {
			log.error("do filter", e);
			throw new ServletException(e);
		} catch (ServletException e) {
			log.error("do filter", e);
			throw e;
		} catch (IOException e) {
			log.error("do filter", e);
			throw e;
		} catch (RuntimeException e) {
			log.error("do filter", e);
			throw e;
		} catch (Error e) {
			log.error("do filter", e);
			throw e;
		}
	}

	public void destroy() {
	}

	public int getDivideBufferSize() {
		return this.divideBufferSize;
	}

	public long getFolderSurvivalTime() {
		return this.survivalTime;
	}

	/**
	 * NGXg番f[^IuWFNg𐶐ĕԂ܂B
	 * @param request
	 * @return
	 * @throws IOException
	 */
	public DividedData createDividedData(BinaryXMLEncodedServletRequest request) throws IOException {
		BufferedInputStream in = new BufferedInputStream(request.getBodyStream());
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		byte[] buf = new byte[1];
		while (in.read(buf) != -1) {
			out.write(buf[0]);
		}
		out.close();
		
		return new DividedData(out.toByteArray(), request.getIntHeader("x-divide-count"));
	}

	/**
	 * NGXgwb_x-divide-session-idɑΉDataFolder擾܂B
	 * ΉDataFolder݂ȂꍇServletExceptionԂ܂B
	 * ̂߁Ã\bh̓wb_x-divide-session-id݂邱Ƃ
	 * mFĂĂ΂ׂłB
	 * 
	 * @param request
	 * @return
	 * @throws ServletException
	 */
	public DataFolder getFolder(BinaryXMLEncodedServletRequest request) throws ServletException {
		//sessionIdwb_ɂ̂session𒲂ׂ
		String sessionId = request.getHeader(DIVIDE_SESSION_ID);
		if (!session.containsKey(sessionId)) //sessionIdɑΉdataFolderȂ̂ŃG[ɂB
			throw new ServletException("session is not found!: sessionId=" + sessionId);

		return (DataFolder)BinaryXMLFilter.session.get(sessionId);
	}

	static String generateSessionId() {
		char[] word =
			new char[] {
				'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z',
				'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z',
				'1','2','3','4','5','6','7','8','9','0','-','/','_' };

		StringBuffer id = new StringBuffer();

		Random rnd = new Random();
		for (int i = 0; i < 10; i++) {
			id.append(word[rnd.nextInt(word.length)]);
		}

		//sessionId݂Ă΍蒼B
		if (session.containsKey(id.toString()))
			return generateSessionId();

		return id.toString();
	}

	/**
	 * ̐؂ꂽtH_[폜܂B
	 *
	 */
	static synchronized void refreshFolder() {
		Iterator sessionIds = BinaryXMLFilter.session.keySet().iterator();
		while (sessionIds.hasNext()) {
			String id = sessionIds.next().toString();
			DataFolder folder = (DataFolder)BinaryXMLFilter.session.get(id);
			if (!folder.isSurvival()) {
				BinaryXMLFilter.session.remove(id);
			}
		}

		sessionIds = null;
	}

	interface ResponseBuffer {
		void close() throws IOException;
		void commit() throws IOException, ParseException;
		boolean isCharStream();
	}

	class BinaryXMLEncodedServletRequest extends HttpServletRequestWrapper {

		private ServletInputStream inputStream;
		private BufferedReader reader;
		protected boolean initQueryString;
		protected Map extendHeader;
		protected Document gbxmlContent;
		protected InputStream bodyStream;
		protected InputStream headerStream;
		protected int contentLength = -1;
		protected String queryString;
		protected String contentType;

		/**
		 * @param arg0
		 */
		public BinaryXMLEncodedServletRequest(HttpServletRequest request) {
			super(request);
		}

		/**
		 * NGXgbodỹTCYԂ܂B
		 * content-typeapplication/gbxml̂Ƃbinary xml̃TCYԂ܂B
		 * 
		 * @TODO gbxmlɖߍ܂ꂽlengthoĕԂB
		 */
		public int getContentLength() {
			try {
				if (this.contentLength == -1)
					initStream();
			} catch (IOException e) {
				throw new RuntimeException(e);
			}
			return this.contentLength;
		}

		public String getContentType() {
			if(this.contentType == null) return super.getContentType();
			
			return this.contentType;
		}

		public boolean isGBXMLContent() {
			return BinaryXMLFilter.GBXML_CONTENT_TYPE.equals(this.getContentType());
		}

		/**
		 * gwb_binary xml͂܂B
		 * ͌ʂ͂ꂼAheaderStream, bodyStreamɊi[܂B
		 * content-typeapplication/gbxml̂Ƃ͂܂B
		 * ȊȌꍇ́AByteArrayInputStreamɂ܂B
		 * 
		 * @throws IOException
		 */
		protected void initStream() throws IOException {
			if (!isGBXMLContent()) {
				this.bodyStream = new ByteArrayInputStream(new byte[0]);
				this.headerStream = new ByteArrayInputStream(new byte[0]);
				this.contentLength = super.getContentLength();
				return;
			}

			InputStream is = super.getInputStream();
			PushbackInputStream pbIn = new PushbackInputStream(is);

			ByteArrayOutputStream header = new ByteArrayOutputStream();
			ByteArrayOutputStream body = new ByteArrayOutputStream();

			byte[] buf = new byte[1];
			final int LF = 0x0a;
			//ւ݂̂
			//wb_͕KLFLFŏI
			log.debug("start read Header");
			while (pbIn.read(buf) != -1) {
				if (buf[0] == LF) {
					//LFɂԂ̂Ŏ1byteǂł݂B
					byte[] next = new byte[1];
					pbIn.read(next);
					if (next[0] == LF)
						break; //LFLFƑĂI
					else
						pbIn.unread(next); //LFLFȂ̂1byteɖ߂đs
				}
				header.write(buf);
			}
			//wb_ǂݍݏI
			this.headerStream = new ByteArrayInputStream(header.toByteArray());

			//{fB[ǂݍ݊JnB
			log.debug("start read Body");
			while (pbIn.read(buf) != -1) {
				body.write(buf);
			}

			//{fB[ǂݍݏI
			this.contentLength = body.toByteArray().length;
			this.bodyStream = new ByteArrayInputStream(body.toByteArray());
		}

		public InputStream getBodyStream() {
			return this.bodyStream;
		}

		public void acceptFolder(ReadFolder folder) throws IOException {
			byte[] bodyData = folder.toByteArray();
			log.debug("setBody: [" + bodyData.length +"]");
			this.bodyStream = new ByteArrayInputStream(bodyData);
			this.contentType = folder.getContentType();
		}

		public void setBodyStream(InputStream stream) {
			this.bodyStream = stream;
		}
		
		/**
		 * gwb_܂B
		 *
		 */
		protected void initExtendHeader() {
			this.extendHeader = new HashMap();
			try {
				if (this.headerStream == null) {
					initStream();
				}

				BufferedReader reader = new BufferedReader(new InputStreamReader(this.headerStream));
				String oneLine = null;
				while ((oneLine = reader.readLine()) != null) {
					if (oneLine.trim().equals(""))
						continue;
					if (oneLine.indexOf(":") == -1)
						continue;
					String key = oneLine.substring(0, oneLine.indexOf(":")).toLowerCase();
					String value = oneLine.substring(oneLine.indexOf(":") + 1).trim();
					
					if (this.extendHeader.containsKey(key)) {
						((Vector)this.extendHeader.get(key)).add(value);
					} else {
						Vector vec = new Vector();
						vec.add(value);
						this.extendHeader.put(key, vec);
					}
				}
			} catch (IOException e) {
				log.warn(e);
			}
		}

		public ServletInputStream getInputStream() throws IOException {
			log.debug("get input stream called.");
			if (this.bodyStream == null) {
				//
				initStream();
			}
			//            for (;;) {
			//                int i = is.read();
			//                if (i < 0) break;
			//                String hex = Integer.toHexString(i);
			//                hex = hex.length() == 2 ? hex : "0" + hex;
			//                System.out.print("0x" + hex + ", ");
			//            }
			if (this.reader != null)
				throw new IllegalStateException("method getReader() was already called.");
			if (this.inputStream == null) {
				if (isGBXMLContent()) {
					XMLOutputter out = new XMLOutputter(this.bodyStream, BinaryXMLFilter.this.textEncoding);
					this.inputStream = new BinaryXMLInputStream(out);
				} else {
					this.inputStream = super.getInputStream();
				}
			}
			return this.inputStream;
		}

		public BufferedReader getReader() throws IOException {
			log.debug("get reader called.");
			if (this.bodyStream == null) {
				//
				initStream();
			}
			if (this.inputStream != null)
				throw new IllegalStateException("method getInputStream() was already called.");
			if (this.reader == null) {
				if (isGBXMLContent()) {
					XMLOutputter out = new XMLOutputter(this.bodyStream, BinaryXMLFilter.this.textEncoding);
					this.reader = new BufferedReader(new BinaryXMLReader(out));
				} else {
					this.reader = super.getReader();
				}
			}
			return this.reader;
		}

		/**
		 * NGXgRegorg.w3c.dom.DocumentɕϊĕԂ܂B
		 * ̃\bh̓NGXgcontent-typeapplication/gbxml̂Ƃ
		 * Ă΂ׂłB
		 * @return
		 */
		public Document getDocument() throws ServletException {
			if (!isGBXMLContent())
				throw new UnsupportedOperationException("can't gbxml content");

			DocumentBuilderFactory factory = DocumentBuilderFactoryImpl.newInstance();
			factory.setNamespaceAware(true);
			factory.setIgnoringElementContentWhitespace(true);
			factory.setIgnoringComments(true);
			factory.setCoalescing(true);

			try {
				DocumentBuilder builder = factory.newDocumentBuilder();
				return builder.parse(new InputSource(getReader()));
			} catch (ParserConfigurationException e) {
				throw new ServletException(e);
			} catch (SAXException saxe) {
				throw new ServletException(saxe);
			} catch (IOException ioe) {
				throw new ServletException(ioe);
			}
		}

		public String getQueryString() {

            log.debug("getQueryString called");
		    if (isGBXMLContent()) return null;
            log.debug("getQueryString not skipped");
            
			StringBuffer buffer = new StringBuffer();
			try {
				BufferedReader reader = new BufferedReader(getReader());
				String buf = null;
				while ((buf = reader.readLine()) != null) {
					buffer.append(buf);
				}
				return buffer.toString();
			} catch (IOException e) {
				log.debug("Catch Exception!!");
				this.reader = null;
				log.error(e.toString(), e);
				throw new RuntimeException(e);
			}
		}

		public String getHeader(String key) {
			if (this.extendHeader == null)
				initExtendHeader();
			String value = super.getHeader(key);
			if (value != null)
				return value;

			if (!this.extendHeader.containsKey(key.toLowerCase()))
				return null;

			Object obj = ((Vector)this.extendHeader.get(key.toLowerCase())).get(0);
			if (obj == null)
				return null;

			return obj.toString();
		}

		public Enumeration getHeaderNames() {
			if (this.extendHeader == null)
				initExtendHeader();

			Enumeration names = super.getHeaderNames();
			Set extendNames = this.extendHeader.keySet();
			if (extendNames == null || extendNames.size() == 0)
				return names;

			while (names.hasMoreElements()) {
				extendNames.add(names.nextElement());
			}

			return Collections.enumeration(extendNames);
		}

		public Enumeration getHeaders(String key) {
			if (this.extendHeader == null)
				initExtendHeader();

			Enumeration values = super.getHeaders(key);
			if (!this.extendHeader.containsKey(key.toLowerCase()))
				return values;

			Vector vec = (Vector)this.extendHeader.get(key);
			while (values.hasMoreElements()) {
				vec.add(values.nextElement());
			}

			return vec.elements();
		}

		public int getIntHeader(String key) {
			if (this.extendHeader == null)
				initExtendHeader();

			int value = super.getIntHeader(key);
			if (!this.extendHeader.containsKey(key.toLowerCase()))
				return value;

			return Integer.parseInt(getHeader(key));
		}

		/**
		 * w肳ꂽL[̃p[^lԂ܂B
		 * content-typeapplication/gbxml̂Ƃ
		 * UnsupportedOperationException܂B
		 * ̏ꍇgetQueryString()getDocument()\bh
		 * Recf[^擾ĂB
		 * 
		 * @return p[^l 
		 * @exception UnsupportedOperationException Recbinary xmlꍇ
		 */
		public String getParameter(String key) {
			if (isGBXMLContent()) {
				throw new UnsupportedOperationException("please call getDocument() or getQueryString()");
			}

			return super.getParameter(key);
		}

		/**
		 * p[^MAP`ŕԂ܂B
		 * content-typeapplication/gbxml̂Ƃ
		 * UnsupportedOperationException܂B
		 * ̏ꍇgetQueryString()getDocument()\bh
		 * Recf[^擾ĂB
		 * 
		 * @return 
		 * @exception UnsupportedOperationException Recbinary xmlꍇ
		 */
		public Map getParameterMap() {
			if (isGBXMLContent()) {
				throw new UnsupportedOperationException("please call getDocument() or getQueryString()");
			}

			return super.getParameterMap();
		}

		/**
		 * p[^̖OXgԂ܂B
		 * content-typeapplication/gbxml̂Ƃ
		 * UnsupportedOperationException܂B
		 * ̏ꍇgetQueryString()getDocument()\bh
		 * Recf[^擾ĂB
		 * 
		 * @return 
		 * @exception UnsupportedOperationException Recbinary xmlꍇ
		 */
		public Enumeration getParameterNames() {
			if (isGBXMLContent()) {
				throw new UnsupportedOperationException("please call getDocument() or getQueryString()");
			}

			return super.getParameterNames();
		}

		/**
		 * w肳ꂽL[̃p[^l̃XgԂ܂B
		 * content-typeapplication/gbxml̂Ƃ
		 * UnsupportedOperationException܂B
		 * ̏ꍇgetQueryString()getDocument()\bh
		 * Recf[^擾ĂB
		 * 
		 * @return p[^l 
		 * @exception UnsupportedOperationException Recbinary xmlꍇ
		 */
		public String[] getParameterValues(String arg0) {
			if (isGBXMLContent()) {
				throw new UnsupportedOperationException("please call getDocument() or getQueryString()");
			}

			return super.getParameterValues(arg0);
		}

	}

	class BinaryXMLEncodedServletResponse extends HttpServletResponseWrapper {

		private ResponseBuffer buffer;
		private String contentType;
		private String characterEncoding;
		private int contentLength = -1;
		private boolean commited;
		private boolean expectGud;
		private int divideBufferSize;
		private long survivalTime;

		/**
		 * @param arg0
		 */
		public BinaryXMLEncodedServletResponse(HttpServletResponse response) {
			super(response);
		}

		//        /* (non-Javadoc)
		//         * @see javax.servlet.ServletResponse#flushBuffer()
		//         */
		//        public void flushBuffer() throws IOException {
		//            // TODO Auto-generated method stub
		//            super.flushBuffer();
		//        }
		//        /* (non-Javadoc)
		//         * @see javax.servlet.ServletResponse#getBufferSize()
		//         */
		//        public int getBufferSize() {
		//            // TODO Auto-generated method stub
		//            return super.getBufferSize();
		//        }

		/**
		 * @see javax.servlet.ServletResponse#getCharacterEncoding()
		 */
		public String getCharacterEncoding() {
			if (this.characterEncoding == null)
				return DEFAULT_CHARSET;
			return this.characterEncoding;
		}

		//        /* (non-Javadoc)
		//         * @see javax.servlet.ServletResponse#getLocale()
		//         */
		//        public Locale getLocale() {
		//            // TODO Auto-generated method stub
		//            return super.getLocale();
		//        }
		//        /* (non-Javadoc)
		//         * @see javax.servlet.ServletResponseWrapper#getResponse()
		//         */
		//        public ServletResponse getResponse() {
		//            // TODO Auto-generated method stub
		//            return super.getResponse();
		//        }
		/**
		 * @see javax.servlet.ServletResponse#isCommitted()
		 */
		public boolean isCommitted() {
			if (commited)
				return true;
			return false;
		}
		//        /* (non-Javadoc)
		//         * @see javax.servlet.ServletResponse#reset()
		//         */
		//        public void reset() {
		//            // TODO Auto-generated method stub
		//            super.reset();
		//        }
		//        /* (non-Javadoc)
		//         * @see javax.servlet.ServletResponse#resetBuffer()
		//         */
		//        public void resetBuffer() {
		//            // TODO Auto-generated method stub
		//            super.resetBuffer();
		//        }
		//        /* (non-Javadoc)
		//         * @see javax.servlet.ServletResponse#setBufferSize(int)
		//         */
		//        public void setBufferSize(int arg0) {
		//            // TODO Auto-generated method stub
		//            super.setBufferSize(arg0);
		//        }

		/**
		 * @see javax.servlet.ServletResponse#setContentLength(int)
		 */
		public void setContentLength(int contentLength) {
			this.contentLength = contentLength;
		}

		//        /* (non-Javadoc)
		//         * @see javax.servlet.ServletResponse#setLocale(java.util.Locale)
		//         */
		//        public void setLocale(Locale arg0) {
		//            // TODO Auto-generated method stub
		//            super.setLocale(arg0);
		//        }
		//        /* (non-Javadoc)
		//         * @see javax.servlet.ServletResponseWrapper#setResponse(javax.servlet.ServletResponse)
		//         */
		//        public void setResponse(ServletResponse arg0) {
		//            // TODO Auto-generated method stub
		//            super.setResponse(arg0);
		//        }

		public void setContentType(String contentType) {
			log.debug("request Content-Type to: " + contentType);
			if (this.buffer != null && isCommitted())
				return;
			log.debug("setting Content-Type to: " + contentType);
			Matcher m = CONTENT_TYPE_PATTERN.matcher(contentType);
			if (!m.matches())
				return;
			this.contentType = m.group(1);
			if (!usingWriter()) {
				this.characterEncoding = m.group(3);
			}
			log.debug("buffer: " + (buffer != null));
		}

		public ServletOutputStream getOutputStream() throws IOException {
			log.debug("getOutputStream");
			if (this.buffer == null) {
				this.buffer = new BufferedServletOutputStream();
			}
			if (usingWriter()) {
				throw new IllegalStateException("method getWriter() was already called.");
			}
			return (ServletOutputStream)this.buffer;
		}

		public PrintWriter getWriter() throws IOException {
			log.debug("getWriter");
			if (this.buffer == null) {
				this.buffer = new BufferedPrintWriter();
			}
			if (usingOutputStream()) {
				throw new IllegalStateException("method getOutputStream() was already called.");
			}
			return (PrintWriter)this.buffer;
		}

		public void commit() throws IOException, ParseException {
			log.debug("commited content-type: " + this.contentType);
			if (isXML()) {
				log.debug("commit xml content-type: " + GBXML_CONTENT_TYPE);
				super.setContentType(GBXML_CONTENT_TYPE);
			} else {
				log.debug("commit non-xml content-type: " + this.contentType);
				if (this.characterEncoding == null || this.characterEncoding.length() == 0) {
					super.setContentType(this.contentType);
				} else {
					super.setContentType(this.contentType + ";charset=" + this.characterEncoding);
				}
				if (this.contentLength > -1)
					super.setContentLength(this.contentLength);
			}
			if (this.buffer != null)
				this.buffer.commit();
		}

		private boolean isXML() {
			if (this.contentType == null)
				return false;
			return XML_CONTENT_TYPE_PATTERN.matcher(this.contentType).lookingAt();
		}

		private boolean expectGud() {
			return this.expectGud;
		}

		private void setExpectGud(boolean expect) {
			this.expectGud = expect;
		}

		private boolean usingWriter() {
			if (this.buffer == null)
				return false;
			return (this.buffer instanceof PrintWriter);
		}

		private boolean usingOutputStream() {
			if (this.buffer == null)
				return false;
			return (this.buffer instanceof ServletOutputStream);
		}

		/**
		 * Mf[^̕TCYԂ܂B
		 * @return
		 */
		public int getDivideBufferSize() {
			return divideBufferSize;
		}

		/**
		 * tH_̐ԂԂ܂B
		 * @return
		 */
		public long getSurvivalTime() {
			return survivalTime;
		}

		/**
		 * tH_̐Ԃݒ肵܂B
		 * @param i tH_̐
		 */
		public void setDivideBufferSize(int i) {
			divideBufferSize = i;
		}

		/**
		 * Mf[^̕TCYݒ肵܂B
		 * @param l Mf[^̕TCY
		 */
		public void setSurvivalTime(long l) {
			survivalTime = l;
		}

		class BufferedServletOutputStream extends ServletOutputStream implements ResponseBuffer {

			ByteArrayOutputStream buffer = new ByteArrayOutputStream();

			public void commit() throws IOException, ParseException {
				if (BinaryXMLEncodedServletResponse.this.isXML()) {
					BinaryXMLOutputter bxo = null;
					if (BinaryXMLEncodedServletResponse.this.expectGud()) {
						//gud FOvĂ̂ŕϊB
						GudConverter converter = new GudConverter(this.buffer.toByteArray());
						try {
							String gud = converter.convert();
							log.debug("gud=" + gud);
							bxo = new BinaryXMLOutputter(gud);
						} catch (ParserConfigurationException e) {
							throw new ParseException(e);
						} catch (SAXException saxe) {
							throw new ParseException(saxe);
						} catch (GudTransformException e) {
							throw new ParseException(e);
						}
					} else {
						bxo = new BinaryXMLOutputter(this.buffer.toByteArray());
					}
					//bxo.setTextEncoding(BinaryXMLFilter.this.textEncoding);
					ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
					bxo.writeTo(byteOut);
					flash(byteOut.toByteArray());
				} else {
					log.debug("non encoded commit");
					flash(this.buffer.toByteArray());
				}
			}

			/**
			 * X|Xf[^o͂܂B
			 * X|Xf[^ݒ肳ꂽbuffersize傫ꍇ͕đM܂B
			 * @param data
			 * @throws IOException
			 */
			public void flash(byte[] data) throws IOException {
				HttpServletResponse response = (HttpServletResponse)BinaryXMLEncodedServletResponse.this.getResponse();

				if (data.length > BinaryXMLEncodedServletResponse.this.getDivideBufferSize()) {
					log.debug("Start Divide Transfer!: orgSize=" + data.length + "  divideSize=" + BinaryXMLEncodedServletResponse.this.getDivideBufferSize());
					String sessionId = BinaryXMLFilter.generateSessionId();
					WriteFolder writeFolder = WriteFolder.createFolder(sessionId, data, BinaryXMLEncodedServletResponse.this.getDivideBufferSize());
					writeFolder.setSurvivalTime(BinaryXMLEncodedServletResponse.this.getSurvivalTime()); //
					BinaryXMLFilter.session.put(sessionId, writeFolder); //sessionɓo^

					log.debug("create Folder: sessionId=" + writeFolder.getSessionId());

					//1Ԗڂ̃f[^o͂
					DividedData first = writeFolder.getDataAt(1);
					response.setHeader(BinaryXMLFilter.DIVIDE_TRANSFER, "start");
					response.setHeader(BinaryXMLFilter.DIVIDE_SESSION_ID, sessionId);
					response.setHeader(BinaryXMLFilter.DIVIDE_MAX_DOUNT, String.valueOf(writeFolder.getMaxCount()));
					response.setHeader(BinaryXMLFilter.DIVIDE_COUNT, "1");
					response.setHeader(BinaryXMLFilter.DIVIDE_PROTOCOL_VERSION, BinaryXMLFilter.DIVIDE_PROTOCOL_VERSION_NO); //protocol-version
					response.getOutputStream().write(first.getData());
				} else {
					response.getOutputStream().write(data);
				}
			}

			public void write(int data) throws IOException {
				this.buffer.write(data);
			}

			public void close() throws IOException {
				this.buffer.close();
			}

			public boolean isCharStream() {
				return false;
			}
		}

		class BufferedPrintWriter extends PrintWriter implements ResponseBuffer {

			private CharArrayWriter buf;

			public BufferedPrintWriter() {
				super(new CharArrayWriter());
				this.buf = (CharArrayWriter)this.out;
			}
            
			public void commit() throws IOException, ParseException {
				if (BinaryXMLEncodedServletResponse.this.isXML()) {
					log.debug("encoded commit");
					BinaryXMLOutputter bxo = null;
					if (BinaryXMLEncodedServletResponse.this.expectGud()) {
						//gud FOvĂ̂ŕϊB
						GudConverter converter = new GudConverter(this.buf.toCharArray());
						try {
							String gud = converter.convert();
							log.debug("gud=" + gud);
							bxo = new BinaryXMLOutputter(gud);
						} catch (ParserConfigurationException e) {
							throw new ParseException(e);
						} catch (SAXException saxe) {
							throw new ParseException(saxe);
						} catch (GudTransformException e) {
							throw new ParseException(e);
						}
					} else {
						bxo = new BinaryXMLOutputter(this.buf.toCharArray());
					}
					ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
					bxo.writeTo(byteOut);
					flash(byteOut.toByteArray());
				} else {
					log.debug("non encoded commit");
					flash(new String(this.buf.toCharArray()).getBytes());
				}
			}

			public boolean isCharStream() {
				return true;
			}

			/**
			 * X|Xf[^o͂܂B
			 * X|Xf[^ݒ肳ꂽbuffersize傫ꍇ͕đM܂B
			 * @param data
			 * @throws IOException
			 */
			public void flash(byte[] data) throws IOException {
				log.debug(new String(data));
				StringBuffer hex = new StringBuffer();
				for(int i=0; i<data.length; i++) {
					hex.append("["+Integer.toHexString(data[i])+"]");
				}
				log.debug(hex.toString());
				
				HttpServletResponse response = (HttpServletResponse)BinaryXMLEncodedServletResponse.this.getResponse();

				if (data.length > BinaryXMLEncodedServletResponse.this.getDivideBufferSize()) {
					log.debug("Start Divide Transfer!: orgSize=" + data.length + "  divideSize=" + BinaryXMLEncodedServletResponse.this.getDivideBufferSize());
					String sessionId = BinaryXMLFilter.generateSessionId();
					WriteFolder writeFolder = WriteFolder.createFolder(sessionId, data, BinaryXMLEncodedServletResponse.this.getDivideBufferSize());
					writeFolder.setSurvivalTime(BinaryXMLEncodedServletResponse.this.getSurvivalTime()); //
					BinaryXMLFilter.session.put(sessionId, writeFolder); //sessionɓo^

					log.debug("create Folder: sessionId=" + writeFolder.getSessionId());
					//1Ԗڂ̃f[^o͂
					DividedData first = writeFolder.getDataAt(1);
					response.setHeader(BinaryXMLFilter.DIVIDE_TRANSFER, "start");
					response.setHeader(BinaryXMLFilter.DIVIDE_SESSION_ID, sessionId);
					response.setHeader(BinaryXMLFilter.DIVIDE_MAX_DOUNT, String.valueOf(writeFolder.getMaxCount()));
					response.setHeader(BinaryXMLFilter.DIVIDE_COUNT, "1");
					response.setHeader(BinaryXMLFilter.DIVIDE_PROTOCOL_VERSION, BinaryXMLFilter.DIVIDE_PROTOCOL_VERSION_NO); //protocol-version
					response.getOutputStream().write(first.getData());
				} else {
					response.getOutputStream().write(data);
				}
			}

		}
	}

}
