package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.util.TargetNode;
import jp.haw.grain.transform.util.Util;

import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * XHTMLpvfgudinline-blockvfɕϊ܂B
 * AXHTMLbodyvf̎qvfłpvf݂̂ΏۂƂȂ܂B
 * ׂ͂ăRs[܂B
 * @author nakajo
 */
public class P2InlineBlock extends AbstractTransformer {

	protected GudBuilder builder;
	protected Element current;

	public P2InlineBlock(GudBuilder builder) {
		this.builder = builder;
	}
	
	

	public Element getCurrentElement() {
		return this.current;
	}

	protected boolean isTarget(Node node) {
		if(node.getNodeType() != Node.ELEMENT_NODE) return false;
		if(!GudBuilder.XHTML_NS.equals(node.getNamespaceURI())) return false;
		
		//xhtml:bodyȉ̗vf[ƂɂB
		if(!Util.parentNodeAs(node, new TargetNode(GudBuilder.XHTML_NS, "body", Node.ELEMENT_NODE)))
			return false;
			
		return node.getLocalName().equals("p");
	}

	public DocumentFragment transform() {
		Document dom = builder.getGudDoc();
		DocumentFragment df = dom.createDocumentFragment();
		
		Element xhtml_p = (Element)node;
		Element gud_inlineblock = dom.createElementNS(GudBuilder.GUD_NS, "inline-block");
		Util.copyAttributes(xhtml_p, gud_inlineblock);
		df.appendChild(gud_inlineblock);
		
		this.current = gud_inlineblock;
		
		return df;
	}
}
