/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.transformer.AbstractTransformer;
import jp.haw.grain.transform.util.TargetNode;
import jp.haw.grain.transform.util.Util;
import jp.haw.grain.xpath.compiler.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TriggerAndSubmitChildCopy
extends AbstractTransformer {
    protected GudBuilder builder;
    protected Element current;

    public TriggerAndSubmitChildCopy(GudBuilder builder) {
        this.builder = builder;
    }

    public Element getCurrentElement() {
        return this.current;
    }

    protected boolean isTarget(Node node) {
        TargetNode xformsTriggerTarget = new TargetNode("http://www.w3.org/2002/xforms", "trigger", 1);
        TargetNode xformsSubmitTarget = new TargetNode("http://www.w3.org/2002/xforms", "submit", 1);
        return Util.parentNodeAs(node, xformsTriggerTarget) || Util.parentNodeAs(node, xformsSubmitTarget);
    }

    public DocumentFragment transform() {
        Document dom = this.builder.getGudDoc();
        if (this.node.getNodeType() == 1) {
            return this.elementTransform(dom);
        }
        if (this.node.getNodeType() == 3) {
            return this.textTransform(dom);
        }
        return null;
    }

    protected DocumentFragment elementTransform(Document dom) {
        DocumentFragment df = dom.createDocumentFragment();
        Element any = (Element)this.node;
        Element gud = null;
        if (any.getNamespaceURI() != null && any.getNamespaceURI() != "http://www.w3.org/2002/xforms") {
            gud = dom.createElementNS(any.getNamespaceURI(), this.node.getLocalName());
            gud.setPrefix(any.getPrefix());
        } else {
            gud = any.getNamespaceURI() == null ? dom.createElementNS("", this.node.getLocalName()) : dom.createElementNS("http://grain.jp/gud/", this.node.getLocalName());
        }
        Util.copyAttributes(any, gud);
        try {
            Util.compileRef(gud);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        df.appendChild(gud);
        this.current = gud;
        return df;
    }

    protected DocumentFragment textTransform(Document dom) {
        DocumentFragment df = dom.createDocumentFragment();
        Text gud = dom.createTextNode(Util.normalizedString(this.node.getNodeValue()));
        df.appendChild(gud);
        this.current = null;
        return df;
    }
}

