/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.framework.servlet;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.haw.grain.divide.DataFolder;
import jp.haw.grain.divide.DividedData;
import jp.haw.grain.divide.ReadFolder;
import jp.haw.grain.divide.WriteFolder;
import jp.haw.grain.framework.xml.BinaryXMLInputStream;
import jp.haw.grain.framework.xml.BinaryXMLOutputter;
import jp.haw.grain.framework.xml.BinaryXMLReader;
import jp.haw.grain.framework.xml.ParseException;
import jp.haw.grain.framework.xml.XMLOutputter;
import jp.haw.grain.transform.GudConverter;
import jp.haw.grain.transform.GudTransformException;
import org.apache.log4j.Logger;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BinaryXMLFilter
implements Filter {
    private static final Logger log = Logger.getLogger(BinaryXMLFilter.class);
    public static final Pattern XML_CONTENT_TYPE_PATTERN = Pattern.compile("^\\w*/xml");
    public static final Pattern CONTENT_TYPE_PATTERN = Pattern.compile("^(.*?)(; ?charset=(.*))?$");
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    public static final String GBXML_CONTENT_TYPE = "application/gbxml";
    public static final String DIVIDE_TRANSFER = "X-Divide-Transfer";
    public static final String DIVIDE_COUNT = "X-Divide-Count";
    public static final String DIVIDE_MAX_DOUNT = "X-Divide-Max-Count";
    public static final String DIVIDE_SESSION_ID = "X-Divide-Session-ID";
    public static final String DIVIDE_CONTENT_TYPE = "X-Content-Type";
    public static final String DIVIDE_PROTOCOL_VERSION = "X-Divide-Protocol-Version";
    public static final String DIVIDE_PROTOCOL_VERSION_NO = "1.0";
    private String textEncoding = "UTF-8";
    private boolean ignoreRequestContentType = false;
    private int divideBufferSize;
    private long survivalTime;
    private static Map session = Collections.synchronizedMap(new HashMap());

    public void init(FilterConfig config) throws ServletException {
        String ignoreRequestContentType;
        String textEncoding = config.getInitParameter("TextEncoding");
        if (textEncoding != null) {
            this.textEncoding = textEncoding;
        }
        if ("true".equals(ignoreRequestContentType = config.getInitParameter("IgnoreRequestContentType"))) {
            this.ignoreRequestContentType = true;
        }
        String divideBufferSize = config.getInitParameter("divideBufferSize");
        try {
            log.debug((Object)("divideBufferSize=" + divideBufferSize));
            this.divideBufferSize = Integer.parseInt(divideBufferSize);
        }
        catch (NumberFormatException e) {
            this.divideBufferSize = 10240;
        }
        String survivalTime = config.getInitParameter("survivalTime");
        try {
            this.survivalTime = Long.parseLong(survivalTime);
        }
        catch (NumberFormatException e) {
            this.survivalTime = 1800000L;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String contentType = ((HttpServletRequest)request).getContentType();
        log.debug((Object)("Request Content-Type: " + contentType));
        try {
            BinaryXMLEncodedServletRequest xmlRequest = new BinaryXMLEncodedServletRequest((HttpServletRequest)request);
            BinaryXMLEncodedServletResponse xmlResponse = new BinaryXMLEncodedServletResponse((HttpServletResponse)response);
            xmlResponse.setDivideBufferSize(this.getDivideBufferSize());
            xmlResponse.setSurvivalTime(this.getFolderSurvivalTime());
            log.debug((Object)("Request URI: " + xmlRequest.getRequestURI()));
            log.debug((Object)("X-expect-FO: " + xmlRequest.getHeader("X-expect-FO")));
            xmlResponse.setExpectGud("gud".equals(xmlRequest.getHeader("X-expect-FO")));
            BinaryXMLFilter.refreshFolder();
            log.debug((Object)("transfer=" + xmlRequest.getHeader(DIVIDE_TRANSFER)));
            log.debug((Object)("sessionId=" + xmlRequest.getHeader(DIVIDE_SESSION_ID)));
            log.debug((Object)("count=" + xmlRequest.getHeader(DIVIDE_COUNT)));
            if ("start".equals(xmlRequest.getHeader(DIVIDE_TRANSFER))) {
                log.debug((Object)"Divide Read Transfer Start!");
                String sessionId = BinaryXMLFilter.generateSessionId();
                ReadFolder readFolder = new ReadFolder(sessionId, xmlRequest.getIntHeader(DIVIDE_MAX_DOUNT), xmlRequest.getHeader(DIVIDE_CONTENT_TYPE));
                readFolder.setSurvivalTime(this.getFolderSurvivalTime());
                readFolder.addData(this.createDividedData(xmlRequest));
                session.put(sessionId, readFolder);
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.setHeader(DIVIDE_SESSION_ID, sessionId);
                httpResponse.setHeader(DIVIDE_PROTOCOL_VERSION, DIVIDE_PROTOCOL_VERSION_NO);
                httpResponse.getOutputStream().close();
                log.debug((Object)("addHeader:X-Divide-Session-ID:" + sessionId));
                log.debug((Object)"addHeader:X-Divide-Protocol-Version:1.0");
                return;
            }
            if ("end".equals(xmlRequest.getHeader(DIVIDE_TRANSFER))) {
                DataFolder folder = this.getFolder(xmlRequest);
                if (folder.getMode() != 1) {
                    throw new ServletException("folder is not read mode: sessionId=" + folder.getSessionId());
                }
                ReadFolder readFolder = (ReadFolder)folder;
                readFolder.addData(this.createDividedData(xmlRequest));
                session.remove(((HttpServletRequest)request).getHeader(DIVIDE_SESSION_ID));
                xmlRequest.acceptFolder(readFolder);
            } else if (xmlRequest.getHeader(DIVIDE_SESSION_ID) != null) {
                DataFolder folder = this.getFolder(xmlRequest);
                if (folder.getMode() == 1) {
                    log.debug((Object)"Divide READ-MODE Continue");
                    ReadFolder readFolder = (ReadFolder)folder;
                    readFolder.addData(this.createDividedData(xmlRequest));
                    HttpServletResponse httpResponse = (HttpServletResponse)response;
                    httpResponse.setHeader(DIVIDE_TRANSFER, "continu-read");
                    httpResponse.setHeader(DIVIDE_PROTOCOL_VERSION, DIVIDE_PROTOCOL_VERSION_NO);
                    httpResponse.getOutputStream().close();
                    log.debug((Object)"addHeader:X-Divide-Protocol-Version: 1.0");
                    return;
                }
                log.debug((Object)("WriteFolder output:" + xmlRequest.getHeader(DIVIDE_COUNT)));
                WriteFolder writeFolder = (WriteFolder)folder;
                DividedData data = writeFolder.getDataAt(xmlRequest.getIntHeader(DIVIDE_COUNT));
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.setHeader(DIVIDE_COUNT, xmlRequest.getHeader(DIVIDE_COUNT));
                httpResponse.setHeader(DIVIDE_CONTENT_TYPE, writeFolder.getContentType());
                httpResponse.setHeader(DIVIDE_PROTOCOL_VERSION, DIVIDE_PROTOCOL_VERSION_NO);
                if (writeFolder.getMaxCount() == xmlRequest.getIntHeader(DIVIDE_COUNT)) {
                    httpResponse.setHeader(DIVIDE_TRANSFER, "end");
                }
                ServletOutputStream out = response.getOutputStream();
                out.write(data.getData());
                out.close();
                return;
            }
            chain.doFilter((ServletRequest)xmlRequest, (ServletResponse)xmlResponse);
            xmlResponse.commit();
        }
        catch (ParseException e) {
            log.error((Object)"do filter", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (ServletException e) {
            log.error((Object)"do filter", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            log.error((Object)"do filter", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.error((Object)"do filter", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            log.error((Object)"do filter", (Throwable)e);
            throw e;
        }
    }

    public void destroy() {
    }

    public int getDivideBufferSize() {
        return this.divideBufferSize;
    }

    public long getFolderSurvivalTime() {
        return this.survivalTime;
    }

    public DividedData createDividedData(BinaryXMLEncodedServletRequest request) throws IOException {
        BufferedInputStream in = new BufferedInputStream(request.getBodyStream());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1];
        while (in.read(buf) != -1) {
            out.write(buf[0]);
        }
        out.close();
        return new DividedData(out.toByteArray(), request.getIntHeader("x-divide-count"));
    }

    public DataFolder getFolder(BinaryXMLEncodedServletRequest request) throws ServletException {
        String sessionId = request.getHeader(DIVIDE_SESSION_ID);
        if (!session.containsKey(sessionId)) {
            throw new ServletException("session is not found!: sessionId=" + sessionId);
        }
        return (DataFolder)session.get(sessionId);
    }

    static String generateSessionId() {
        char[] word = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '/', '_'};
        StringBuffer id = new StringBuffer();
        Random rnd = new Random();
        for (int i = 0; i < 10; ++i) {
            id.append(word[rnd.nextInt(word.length)]);
        }
        if (session.containsKey(id.toString())) {
            return BinaryXMLFilter.generateSessionId();
        }
        return id.toString();
    }

    static synchronized void refreshFolder() {
        Iterator sessionIds = session.keySet().iterator();
        while (sessionIds.hasNext()) {
            String id = sessionIds.next().toString();
            DataFolder folder = (DataFolder)session.get(id);
            if (folder.isSurvival()) continue;
            session.remove(id);
        }
        sessionIds = null;
    }

    class BinaryXMLEncodedServletResponse
    extends HttpServletResponseWrapper {
        private ResponseBuffer buffer;
        private String contentType;
        private String characterEncoding;
        private int contentLength;
        private boolean commited;
        private boolean expectGud;
        private int divideBufferSize;
        private long survivalTime;

        public BinaryXMLEncodedServletResponse(HttpServletResponse response) {
            super(response);
            this.contentLength = -1;
        }

        public String getCharacterEncoding() {
            if (this.characterEncoding == null) {
                return BinaryXMLFilter.DEFAULT_CHARSET;
            }
            return this.characterEncoding;
        }

        public boolean isCommitted() {
            return this.commited;
        }

        public void setContentLength(int contentLength) {
            this.contentLength = contentLength;
        }

        public void setContentType(String contentType) {
            log.debug((Object)("request Content-Type to: " + contentType));
            if (this.buffer != null && this.isCommitted()) {
                return;
            }
            log.debug((Object)("setting Content-Type to: " + contentType));
            Matcher m = CONTENT_TYPE_PATTERN.matcher(contentType);
            if (!m.matches()) {
                return;
            }
            this.contentType = m.group(1);
            if (!this.usingWriter()) {
                this.characterEncoding = m.group(3);
            }
            log.debug((Object)("buffer: " + (this.buffer != null)));
        }

        public ServletOutputStream getOutputStream() throws IOException {
            log.debug((Object)"getOutputStream");
            if (this.buffer == null) {
                this.buffer = new BufferedServletOutputStream();
            }
            if (this.usingWriter()) {
                throw new IllegalStateException("method getWriter() was already called.");
            }
            return (ServletOutputStream)this.buffer;
        }

        public PrintWriter getWriter() throws IOException {
            log.debug((Object)"getWriter");
            if (this.buffer == null) {
                this.buffer = new BufferedPrintWriter();
            }
            if (this.usingOutputStream()) {
                throw new IllegalStateException("method getOutputStream() was already called.");
            }
            return (PrintWriter)((Object)this.buffer);
        }

        public void commit() throws IOException, ParseException {
            log.debug((Object)("commited content-type: " + this.contentType));
            if (this.isXML()) {
                log.debug((Object)"commit xml content-type: application/gbxml");
                super.setContentType(BinaryXMLFilter.GBXML_CONTENT_TYPE);
            } else {
                log.debug((Object)("commit non-xml content-type: " + this.contentType));
                if (this.characterEncoding == null || this.characterEncoding.length() == 0) {
                    super.setContentType(this.contentType);
                } else {
                    super.setContentType(this.contentType + ";charset=" + this.characterEncoding);
                }
                if (this.contentLength > -1) {
                    super.setContentLength(this.contentLength);
                }
            }
            if (this.buffer != null) {
                this.buffer.commit();
            }
        }

        private boolean isXML() {
            if (this.contentType == null) {
                return false;
            }
            return XML_CONTENT_TYPE_PATTERN.matcher(this.contentType).lookingAt();
        }

        private boolean expectGud() {
            return this.expectGud;
        }

        private void setExpectGud(boolean expect) {
            this.expectGud = expect;
        }

        private boolean usingWriter() {
            if (this.buffer == null) {
                return false;
            }
            return this.buffer instanceof PrintWriter;
        }

        private boolean usingOutputStream() {
            if (this.buffer == null) {
                return false;
            }
            return this.buffer instanceof ServletOutputStream;
        }

        public int getDivideBufferSize() {
            return this.divideBufferSize;
        }

        public long getSurvivalTime() {
            return this.survivalTime;
        }

        public void setDivideBufferSize(int i) {
            this.divideBufferSize = i;
        }

        public void setSurvivalTime(long l) {
            this.survivalTime = l;
        }

        class BufferedPrintWriter
        extends PrintWriter
        implements ResponseBuffer {
            private CharArrayWriter buf;

            public BufferedPrintWriter() {
                super(new CharArrayWriter());
                this.buf = (CharArrayWriter)this.out;
            }

            public void commit() throws IOException, ParseException {
                if (BinaryXMLEncodedServletResponse.this.isXML()) {
                    log.debug((Object)"encoded commit");
                    BinaryXMLOutputter bxo = null;
                    if (BinaryXMLEncodedServletResponse.this.expectGud()) {
                        String xml = new String(this.buf.toCharArray()).trim();
                        log.debug((Object)xml);
                        GudConverter converter = new GudConverter(xml);
                        try {
                            String gud = converter.convert();
                            log.debug((Object)("gud=" + gud));
                            bxo = new BinaryXMLOutputter(gud);
                        }
                        catch (ParserConfigurationException e) {
                            throw new ParseException(e);
                        }
                        catch (SAXException saxe) {
                            throw new ParseException(saxe);
                        }
                        catch (GudTransformException e) {
                            throw new ParseException(e);
                        }
                    } else {
                        bxo = new BinaryXMLOutputter(this.buf.toCharArray());
                    }
                    ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                    log.debug((Object)("byteout=" + new String(byteOut.toByteArray())));
                    bxo.writeTo(byteOut);
                    this.flash(byteOut.toByteArray());
                } else {
                    log.debug((Object)"non encoded commit");
                    this.flash(new String(this.buf.toCharArray()).getBytes());
                }
            }

            public boolean isCharStream() {
                return true;
            }

            public void flash(byte[] data) throws IOException {
                log.debug((Object)("data Size=" + data.length));
                StringBuffer hex = new StringBuffer();
                for (int i = 0; i < data.length; ++i) {
                    hex.append("[" + Integer.toHexString(data[i]) + "]");
                }
                log.debug((Object)hex.toString());
                HttpServletResponse response = (HttpServletResponse)BinaryXMLEncodedServletResponse.this.getResponse();
                if (data.length > BinaryXMLEncodedServletResponse.this.getDivideBufferSize()) {
                    log.debug((Object)("Start Divide Transfer!: orgSize=" + data.length + "  divideSize=" + BinaryXMLEncodedServletResponse.this.getDivideBufferSize()));
                    String sessionId = BinaryXMLFilter.generateSessionId();
                    WriteFolder writeFolder = WriteFolder.createFolder(sessionId, data, BinaryXMLEncodedServletResponse.this.getDivideBufferSize());
                    writeFolder.setSurvivalTime(BinaryXMLEncodedServletResponse.this.getSurvivalTime());
                    session.put(sessionId, writeFolder);
                    log.debug((Object)("create Folder: sessionId=" + writeFolder.getSessionId()));
                    DividedData first = writeFolder.getDataAt(1);
                    response.setHeader(BinaryXMLFilter.DIVIDE_TRANSFER, "start");
                    response.setHeader(BinaryXMLFilter.DIVIDE_SESSION_ID, sessionId);
                    response.setHeader(BinaryXMLFilter.DIVIDE_MAX_DOUNT, String.valueOf(writeFolder.getMaxCount()));
                    response.setHeader(BinaryXMLFilter.DIVIDE_COUNT, "1");
                    response.setHeader(BinaryXMLFilter.DIVIDE_PROTOCOL_VERSION, BinaryXMLFilter.DIVIDE_PROTOCOL_VERSION_NO);
                    response.getOutputStream().write(first.getData());
                } else {
                    response.getOutputStream().write(data);
                }
            }
        }

        class BufferedServletOutputStream
        extends ServletOutputStream
        implements ResponseBuffer {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();

            BufferedServletOutputStream() {
            }

            public void commit() throws IOException, ParseException {
                if (BinaryXMLEncodedServletResponse.this.isXML()) {
                    BinaryXMLOutputter bxo = null;
                    if (BinaryXMLEncodedServletResponse.this.expectGud()) {
                        GudConverter converter = new GudConverter(this.buffer.toByteArray());
                        try {
                            String gud = converter.convert();
                            log.debug((Object)("gud=" + gud));
                            bxo = new BinaryXMLOutputter(gud);
                        }
                        catch (ParserConfigurationException e) {
                            throw new ParseException(e);
                        }
                        catch (SAXException saxe) {
                            throw new ParseException(saxe);
                        }
                        catch (GudTransformException e) {
                            throw new ParseException(e);
                        }
                    } else {
                        bxo = new BinaryXMLOutputter(this.buffer.toByteArray());
                    }
                    ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                    bxo.writeTo(byteOut);
                    this.flash(byteOut.toByteArray());
                } else {
                    log.debug((Object)"non encoded commit");
                    this.flash(this.buffer.toByteArray());
                }
            }

            public void flash(byte[] data) throws IOException {
                HttpServletResponse response = (HttpServletResponse)BinaryXMLEncodedServletResponse.this.getResponse();
                if (data.length > BinaryXMLEncodedServletResponse.this.getDivideBufferSize()) {
                    log.debug((Object)("Start Divide Transfer!: orgSize=" + data.length + "  divideSize=" + BinaryXMLEncodedServletResponse.this.getDivideBufferSize()));
                    String sessionId = BinaryXMLFilter.generateSessionId();
                    WriteFolder writeFolder = WriteFolder.createFolder(sessionId, data, BinaryXMLEncodedServletResponse.this.getDivideBufferSize());
                    writeFolder.setSurvivalTime(BinaryXMLEncodedServletResponse.this.getSurvivalTime());
                    session.put(sessionId, writeFolder);
                    log.debug((Object)("create Folder: sessionId=" + writeFolder.getSessionId()));
                    DividedData first = writeFolder.getDataAt(1);
                    response.setHeader(BinaryXMLFilter.DIVIDE_TRANSFER, "start");
                    response.setHeader(BinaryXMLFilter.DIVIDE_SESSION_ID, sessionId);
                    response.setHeader(BinaryXMLFilter.DIVIDE_MAX_DOUNT, String.valueOf(writeFolder.getMaxCount()));
                    response.setHeader(BinaryXMLFilter.DIVIDE_COUNT, "1");
                    response.setHeader(BinaryXMLFilter.DIVIDE_PROTOCOL_VERSION, BinaryXMLFilter.DIVIDE_PROTOCOL_VERSION_NO);
                    response.getOutputStream().write(first.getData());
                } else {
                    response.getOutputStream().write(data);
                }
            }

            public void write(int data) throws IOException {
                this.buffer.write(data);
            }

            public void close() throws IOException {
                this.buffer.close();
            }

            public boolean isCharStream() {
                return false;
            }
        }
    }

    class BinaryXMLEncodedServletRequest
    extends HttpServletRequestWrapper {
        private ServletInputStream inputStream;
        private BufferedReader reader;
        protected boolean initQueryString;
        protected Map extendHeader;
        protected Document gbxmlContent;
        protected InputStream bodyStream;
        protected InputStream headerStream;
        protected int contentLength;
        protected String queryString;
        protected String contentType;

        public BinaryXMLEncodedServletRequest(HttpServletRequest request) {
            super(request);
            this.contentLength = -1;
        }

        public int getContentLength() {
            try {
                if (this.contentLength == -1) {
                    this.initStream();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.contentLength;
        }

        public String getContentType() {
            if (this.contentType == null) {
                return super.getContentType();
            }
            return this.contentType;
        }

        public boolean isGBXMLContent() {
            return BinaryXMLFilter.GBXML_CONTENT_TYPE.equals(this.getContentType());
        }

        protected void initStream() throws IOException {
            if (!this.isGBXMLContent()) {
                this.bodyStream = new ByteArrayInputStream(new byte[0]);
                this.headerStream = new ByteArrayInputStream(new byte[0]);
                this.contentLength = super.getContentLength();
                return;
            }
            ServletInputStream is = super.getInputStream();
            PushbackInputStream pbIn = new PushbackInputStream((InputStream)is);
            ByteArrayOutputStream header = new ByteArrayOutputStream();
            ByteArrayOutputStream body = new ByteArrayOutputStream();
            byte[] buf = new byte[1];
            int LF = 10;
            log.debug((Object)"start read Header");
            while (pbIn.read(buf) != -1) {
                if (buf[0] == 10) {
                    byte[] next = new byte[1];
                    pbIn.read(next);
                    if (next[0] == 10) break;
                    pbIn.unread(next);
                }
                header.write(buf);
            }
            this.headerStream = new ByteArrayInputStream(header.toByteArray());
            log.debug((Object)"start read Body");
            while (pbIn.read(buf) != -1) {
                body.write(buf);
            }
            this.contentLength = body.toByteArray().length;
            this.bodyStream = new ByteArrayInputStream(body.toByteArray());
        }

        public InputStream getBodyStream() {
            return this.bodyStream;
        }

        public void acceptFolder(ReadFolder folder) throws IOException {
            byte[] bodyData = folder.toByteArray();
            log.debug((Object)("setBody: [" + bodyData.length + "]"));
            this.bodyStream = new ByteArrayInputStream(bodyData);
            this.contentType = folder.getContentType();
        }

        public void setBodyStream(InputStream stream) {
            this.bodyStream = stream;
        }

        protected void initExtendHeader() {
            this.extendHeader = new HashMap();
            try {
                if (this.headerStream == null) {
                    this.initStream();
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.headerStream));
                String oneLine = null;
                while ((oneLine = reader.readLine()) != null) {
                    if (oneLine.trim().equals("") || oneLine.indexOf(":") == -1) continue;
                    String key = oneLine.substring(0, oneLine.indexOf(":")).toLowerCase();
                    String value = oneLine.substring(oneLine.indexOf(":") + 1).trim();
                    if (this.extendHeader.containsKey(key)) {
                        ((Vector)this.extendHeader.get(key)).add(value);
                        continue;
                    }
                    Vector<String> vec = new Vector<String>();
                    vec.add(value);
                    this.extendHeader.put(key, vec);
                }
            }
            catch (IOException e) {
                log.warn((Object)e);
            }
        }

        public ServletInputStream getInputStream() throws IOException {
            log.debug((Object)"get input stream called.");
            if (this.bodyStream == null) {
                this.initStream();
            }
            if (this.reader != null) {
                throw new IllegalStateException("method getReader() was already called.");
            }
            if (this.inputStream == null) {
                if (this.isGBXMLContent()) {
                    XMLOutputter out = new XMLOutputter(this.bodyStream, BinaryXMLFilter.this.textEncoding);
                    this.inputStream = new BinaryXMLInputStream(out);
                } else {
                    this.inputStream = super.getInputStream();
                }
            }
            return this.inputStream;
        }

        public BufferedReader getReader() throws IOException {
            log.debug((Object)"get reader called.");
            if (this.bodyStream == null) {
                this.initStream();
            }
            if (this.inputStream != null) {
                throw new IllegalStateException("method getInputStream() was already called.");
            }
            if (this.reader == null) {
                if (this.isGBXMLContent()) {
                    XMLOutputter out = new XMLOutputter(this.bodyStream, BinaryXMLFilter.this.textEncoding);
                    this.reader = new BufferedReader(new BinaryXMLReader(out));
                } else {
                    this.reader = super.getReader();
                }
            }
            return this.reader;
        }

        public Document getDocument() throws ServletException {
            if (!this.isGBXMLContent()) {
                throw new UnsupportedOperationException("can't gbxml content");
            }
            DocumentBuilderFactory factory = DocumentBuilderFactoryImpl.newInstance();
            factory.setNamespaceAware(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            factory.setCoalescing(true);
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                return builder.parse(new InputSource(this.getReader()));
            }
            catch (ParserConfigurationException e) {
                throw new ServletException((Throwable)e);
            }
            catch (SAXException saxe) {
                throw new ServletException((Throwable)saxe);
            }
            catch (IOException ioe) {
                throw new ServletException((Throwable)ioe);
            }
        }

        public String getQueryString() {
            log.debug((Object)"getQueryString called");
            if (!this.isGBXMLContent()) {
                return super.getQueryString();
            }
            if (this.contentLength == 0) {
                return null;
            }
            log.debug((Object)"getQueryString not skipped");
            StringBuffer buffer = new StringBuffer();
            try {
                BufferedReader reader = new BufferedReader(this.getReader());
                String buf = null;
                while ((buf = reader.readLine()) != null) {
                    buffer.append(buf);
                }
                return buffer.toString();
            }
            catch (IOException e) {
                log.debug((Object)"Catch Exception!!");
                this.reader = null;
                log.error((Object)e.toString(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }

        public String getHeader(String key) {
            String value;
            if (this.extendHeader == null) {
                this.initExtendHeader();
            }
            if ((value = super.getHeader(key)) != null) {
                return value;
            }
            if (!this.extendHeader.containsKey(key.toLowerCase())) {
                return null;
            }
            Object obj = ((Vector)this.extendHeader.get(key.toLowerCase())).get(0);
            if (obj == null) {
                return null;
            }
            return obj.toString();
        }

        public Enumeration getHeaderNames() {
            if (this.extendHeader == null) {
                this.initExtendHeader();
            }
            Enumeration names = super.getHeaderNames();
            Set extendNames = this.extendHeader.keySet();
            if (extendNames == null || extendNames.size() == 0) {
                return names;
            }
            while (names.hasMoreElements()) {
                extendNames.add(names.nextElement());
            }
            return Collections.enumeration(extendNames);
        }

        public Enumeration getHeaders(String key) {
            if (this.extendHeader == null) {
                this.initExtendHeader();
            }
            Enumeration values = super.getHeaders(key);
            if (!this.extendHeader.containsKey(key.toLowerCase())) {
                return values;
            }
            Vector vec = (Vector)this.extendHeader.get(key);
            while (values.hasMoreElements()) {
                vec.add(values.nextElement());
            }
            return vec.elements();
        }

        public int getIntHeader(String key) {
            if (this.extendHeader == null) {
                this.initExtendHeader();
            }
            int value = super.getIntHeader(key);
            if (!this.extendHeader.containsKey(key.toLowerCase())) {
                return value;
            }
            return Integer.parseInt(this.getHeader(key));
        }

        public String getParameter(String key) {
            if (this.isGBXMLContent()) {
                throw new UnsupportedOperationException("please call getDocument() or getQueryString()");
            }
            return super.getParameter(key);
        }

        public Map getParameterMap() {
            if (this.isGBXMLContent()) {
                throw new UnsupportedOperationException("please call getDocument() or getQueryString()");
            }
            return super.getParameterMap();
        }

        public Enumeration getParameterNames() {
            if (this.isGBXMLContent()) {
                return new Vector().elements();
            }
            return super.getParameterNames();
        }

        public String[] getParameterValues(String arg0) {
            if (this.isGBXMLContent()) {
                throw new UnsupportedOperationException("please call getDocument() or getQueryString()");
            }
            return super.getParameterValues(arg0);
        }
    }

    static interface ResponseBuffer {
        public void close() throws IOException;

        public void commit() throws IOException, ParseException;

        public boolean isCharStream();
    }
}

