package jp.haw.grain.dom;

import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class ElementWrapper extends NodeWrapper implements Element {

	protected Element element;
	
	public ElementWrapper(Element e) {
		super(e);
		this.element = e;
	}

	public Element getElement() {
		return this.element;
	}

	public Node setParentNode(Node node) {
		this.parent = node;
		return node;
	}
	
	public Node appendChild(Node arg0) throws DOMException {
		if(arg0.getNodeType() == Node.ELEMENT_NODE) {
			Element e = (Element)arg0;
			if(!(arg0 instanceof ElementWrapper)) e = new ElementWrapper(e);
			Node parent = e.getParentNode();
			if(parent != null) this.parent = parent;
			((ElementWrapper)e).setParentNode(this);
		}
		this.children.add(arg0);
		this.element.appendChild(((NodeWrapper)arg0).getNode());
		return arg0;
	}

	public String getAttribute(String arg0) {
		return this.element.getAttribute(arg0);
	}

	public Attr getAttributeNode(String arg0) {
		return this.element.getAttributeNode(arg0);
	}

	public Attr getAttributeNodeNS(String arg0, String arg1) throws DOMException {
		return this.element.getAttributeNodeNS(arg0, arg1);
	}

	public String getAttributeNS(String arg0, String arg1) throws DOMException {
		return this.element.getAttributeNS(arg0, arg1);
	}

	public NodeList getElementsByTagName(String arg0) {
		return this.element.getElementsByTagName(arg0);
	}

	public NodeList getElementsByTagNameNS(String arg0, String arg1) throws DOMException {
		return this.element.getElementsByTagNameNS(arg0, arg1);
	}

	public TypeInfo getSchemaTypeInfo() {
		return this.element.getSchemaTypeInfo();
	}

	public String getTagName() {
		return this.element.getTagName();
	}

	public boolean hasAttribute(String arg0) {
		return this.element.hasAttribute(arg0);
	}

	public boolean hasAttributeNS(String arg0, String arg1) throws DOMException {
		return this.element.hasAttributeNS(arg0, arg1);
	}

	public void removeAttribute(String arg0) throws DOMException {
		this.element.removeAttribute(arg0);
	}

	public Attr removeAttributeNode(Attr arg0) throws DOMException {
		return this.element.removeAttributeNode(arg0);
	}

	public void removeAttributeNS(String arg0, String arg1) throws DOMException {
		this.element.removeAttributeNS(arg0, arg1);
		
	}

	public void setAttribute(String arg0, String arg1) throws DOMException {
		this.element.setAttribute(arg0, arg1);
	}

	public Attr setAttributeNode(Attr arg0) throws DOMException {
		return this.element.setAttributeNode(arg0);
	}

	public Attr setAttributeNodeNS(Attr arg0) throws DOMException {
		return this.element.setAttributeNodeNS(arg0);
	}

	public void setAttributeNS(String arg0, String arg1, String arg2) throws DOMException {
		this.element.setAttributeNS(arg0, arg1, arg2);
	}

	public void setIdAttribute(String arg0, boolean arg1) throws DOMException {
		this.element.setIdAttribute(arg0, arg1);
	}

	public void setIdAttributeNode(Attr arg0, boolean arg1) throws DOMException {
		this.element.setIdAttributeNode(arg0, arg1);
	}

	public void setIdAttributeNS(String arg0, String arg1, boolean arg2) throws DOMException {
		this.element.setIdAttributeNS(arg0, arg1, arg2);
	}

}
