/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/04/09 13:56:59
 * 
 */
package jp.haw.grain;

import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * TODO Formatter
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public class Formatter {
    
    public static String getComparision(byte[] expected, byte[] actual) {
        StringWriter buf = new StringWriter();
        PrintWriter out = new PrintWriter(buf);
        out.println("### expected ###");
        dumpBytesTo(expected, out);
        out.println("### actual ###");
        dumpBytesTo(actual, out);
        return buf.toString();
    }
    
    public static void dumpBytesTo(byte[] b, PrintWriter out){
        int of = 0;
        int len = 16;
        int max = b.length + len;
        int i = 0;
        while (of < max) {
            out.println("*** dump[" + i +"] : " + toHex(b, of, len) + " --- " + toAscii(b, of, len));
            of += len;            
        }
    }
    
    
    public static String toAscii(byte[] data, int offset, int len) {
        StringBuffer buf = new StringBuffer();
        for (int i = offset; i < offset + len; ++i) {
            if (i >= data.length) {
                buf.append("   ");
                continue;
            }
            int c = 0xff & data[i];
            if (c < 0x20 || 0x80 < c) {
                buf.append("\\").append(toHex(data[i]));
            } else {
                buf.append("  ").append((char)c);
            }
        }
        return buf.toString();
    }
    
    public static String toHex(byte[] data, int offset, int len) {
        StringBuffer buf = new StringBuffer();
        for (int i = offset; i < offset + len; ++i) {
            if (i % 4 == 0) buf.append(" ");
            if (i >= data.length) {
                buf.append("  ");
                continue;
            }
            buf.append(toHex(data[i]));
        }
        return buf.toString();
    }
    
    public static String toHex(byte data) {
        char[] hex = new char[2];
        hex[0] = getHexChar((data & 0xF0) >>> 4);        
        hex[1] = getHexChar(data & 0x0F);
        return String.valueOf(hex);
    }
    
    public static char getHexChar(int val) {
        if (val < 10) {
            return (char)('0' + val);
        } else {
            return (char)('a' + (val - 10));
        }
    }
}
