package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.TransformOperation;
import junit.framework.TestCase;

import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;


/**
 * @author nakajo
 */
public class Span2InlinegroupTest extends TestCase {
	
	/**
	 * bodyvf̎qvfłspan^OϊΏۂƂȂB
	 *
	 */
	public void testSimpleTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XHTML_NS, "body", null);
		Element body = simpleDoc.getDocumentElement();
		Element span = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "span");
		Element p = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "p");
		Element span2 = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "span");
		
		body.appendChild(p);
		body.appendChild(span);
		p.appendChild(span2);
		
		Span2Inlinegroup span2ing = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				NodeList nodes = df.getChildNodes();
				assertEquals("list length check", nodes.getLength(), 1);
				
				Node node = nodes.item(0);
				assertEquals("name check", node.getLocalName(), "inline-group"); 
				assertTrue("current is null check", t.getCurrentElement() != null);
			}
		};

		span2ing.apply(span, mockOperation);
		span2ing.apply(span2, mockOperation);
	}

	/**
	 * bodyvf̎qvfłspan^OϊΏۂƂȂB
	 * Rs[
	 *
	 */
	public void testAttrsCopy() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XHTML_NS, "body", null);
		Element body = simpleDoc.getDocumentElement();
		Element span = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "span");
		Element p = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "p");
		Element span2 = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "span");
		
		body.appendChild(p);
		body.appendChild(span);
		p.appendChild(span2);
		
		span.setAttribute("ev:event", "DOMActivate");
		span.setAttribute("id", "hog1");
		span.setAttribute("padding", "2px");
		
		span2.setAttribute("ev:event", "DOMActivate");
		span2.setAttribute("id", "hog1");
		span2.setAttribute("padding", "2px");
		
		Span2Inlinegroup span2ing = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				NodeList nodes = df.getChildNodes();
				assertEquals("list length check", nodes.getLength(), 1);
				
				Node node = nodes.item(0);
				assertEquals("name check", node.getLocalName(), "inline-group"); 
				assertTrue("current is null check", t.getCurrentElement() != null);

				NamedNodeMap attrs = node.getAttributes();
				assertEquals("attrs length check", attrs.getLength(), 3);
				Node event = attrs.getNamedItem("ev:event");
				Node id = attrs.getNamedItem("id");
				Node padding = attrs.getNamedItem("padding");
				
				assertTrue("event not null check", event != null);
				assertTrue("id not null check", id != null);
				assertTrue("padding not null check", padding != null);

				assertEquals("event same value check", event.getNodeValue(), "DOMActivate");
				assertEquals("id same value check", id.getNodeValue(), "hog1");
				assertEquals("padding same value check", padding.getNodeValue(), "2px");
			}
		};

		span2ing.apply(span, mockOperation);
		span2ing.apply(span2, mockOperation);
	}



	/**
	 * localnamespanȂ̂ŕϊΏۂɂȂȂ
	 *
	 */
	public void testNotXFormsTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XHTML_NS, "body", null);
		Element body = simpleDoc.getDocumentElement();
		Element span = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "span");
		Element p = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "p");
		Element span2 = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "span");
		
		body.appendChild(p);
		body.appendChild(span);
		p.appendChild(span2);
		
		Span2Inlinegroup span2ing = new MockTransformer(new GudBuilder(simpleDoc), false);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#createChildNodeOperation()
			 */
			public TransformOperation createChildNodeOperation() {
				assertEquals("transformer null check", this.transformer, null);
				// TODO ꂽ\bhEX^u
				return super.createChildNodeOperation();
			}

		};

		span2ing.apply(p, mockOperation);
		mockOperation.createChildNodeOperation();
	}

	/**
	 * c悪bodyȂ̂ŕϊΏۂɂȂȂB
	 *
	 */
	public void testNotBodyParent() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XHTML_NS, "html", null);
		Element body = simpleDoc.getDocumentElement();
		Element span = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "span");
		Element p = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "p");
		Element span2 = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "span");
		
		body.appendChild(p);
		body.appendChild(span);
		p.appendChild(span2);
		
		Span2Inlinegroup span2ing = new MockTransformer(new GudBuilder(simpleDoc), false);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#createChildNodeOperation()
			 */
			public TransformOperation createChildNodeOperation() {
				assertEquals("transformer null check", this.transformer, null);
				// TODO ꂽ\bhEX^u
				return super.createChildNodeOperation();
			}

		};

		span2ing.apply(span, mockOperation);
		mockOperation.createChildNodeOperation();
		span2ing.apply(span, mockOperation);
		mockOperation.createChildNodeOperation();
	}

	/**
	 * NSXHTMLȂ̂ŕϊΏۂɂȂȂB
	 *
	 */
	public void testWrongNS() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XHTML_NS, "body", null);
		Element body = simpleDoc.getDocumentElement();
		String testNS = "http://grain.jp/test/";

		Element span = simpleDoc.createElementNS(testNS, "span");
		Element p = simpleDoc.createElementNS(testNS, "p");
		Element span2 = simpleDoc.createElementNS(testNS, "span");
		
		body.appendChild(p);
		body.appendChild(span);
		p.appendChild(span2);
		
		Span2Inlinegroup span2ing = new MockTransformer(new GudBuilder(simpleDoc), false);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#createChildNodeOperation()
			 */
			public TransformOperation createChildNodeOperation() {
				assertEquals("transformer null check", this.transformer, null);
				// TODO ꂽ\bhEX^u
				return super.createChildNodeOperation();
			}

		};

		span2ing.apply(span, mockOperation);
		mockOperation.createChildNodeOperation();
		span2ing.apply(span2, mockOperation);
		mockOperation.createChildNodeOperation();
	}
	
	
	class MockTransformer extends Span2Inlinegroup {
		protected boolean targetResult;
		/**
		 * @param builder
		 */
		public MockTransformer(GudBuilder builder, boolean targetResult) {
			super(builder);
			this.targetResult = targetResult;
		}
		
		/* ( Javadoc)
		 * @see jp.haw.grain.transform.transformer.AbstractTransformer#isTarget(org.w3c.dom.Node)
		 */
		protected boolean isTarget(Node node) {
			assertEquals("apply check", super.isTarget(node), this.targetResult);
			return super.isTarget(node);
		}

	}
}
