/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/02/10 9:41:51
 * 
 */
package jp.grain.sprout.model;

import java.util.Vector;

import jp.grain.spike.Node;
import jp.grain.spike.event.Event;
import jp.grain.spike.event.EventListener;
import jp.grain.sprout.BindingElement;
import jp.grain.sprout.OperetionListener;
import jp.grain.sprout.SerializeOperation;
import jp.grain.sprout.action.Action;
import jp.grain.sprout.ui.Form;
import jp.grain.sprout.ui.FormContext;

/**
 * TODO Submission
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public class Submission extends BindingElement implements OperetionListener, EventListener {
    
    public static final String NAME = "submission"; 

    protected Bind bind;
	private Vector _actions = new Vector();
    
    /**
     * @param name
     */
    public Submission() {
        super(NAME);
    }
    
	protected void initChildren(Form form) {
    	if(_actions == null) return;
        for(int i=0; i<_actions.size(); i++) {
        	Action action = (Action)_actions.elementAt(i);
        	action.init(form);
        }
	}

    public void submit(FormContext ctx) {
        Event ev = new Event("xforms-submit", true, false);
        dispatchEvent(ev);
        if (ev.isPreventDefault()) return;
        SerializeOperation ope = ctx.createSubmissionOperation(this);
        ctx.execute(ope);
    }

    public boolean dispatchEvent(Event event) {
    	return false;
	}

	public String[] getHandleEvents() {
		// TODO ꂽ\bhEX^u
		return new String[0];
	}

	public boolean handleEvent(Event event) {
		// TODO ꂽ\bhEX^u
		return false;
	}

	public void preProcess(Node parent) {
		if(parent instanceof Model) {
			((Model)parent).addSubmission(this);
		}
	}

	/* (non-Javadoc)
     * @see jp.grain.sprout.OperetionObserver#statusChanged(jp.grain.sprout.SerializeOperation)
     */
    public void operationCompleted(SerializeOperation ope) {
            dispatchEvent(new Event("xforms-submit-done", true, false));
    }
    
    /* (non-Javadoc)
     * @see jp.grain.sprout.OperetionListener#operationFailure(jp.grain.sprout.SerializeOperation, java.lang.Exception)
     */
    public void operationFailure(SerializeOperation ope, Exception e) {
        ((Model)getParentElement()).dispatchEvent(new Event("xforms-submit-error", true, false));
    }

    /**
     * @return
     */
    public String getActionUrl() {
        return getAttribute("action");
    }

	public void addAction(Action action) {
		_actions.addElement(action);
		action.setParent(this);
	}

}
