/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/04/07 14:00:51
 * 
 */
package jp.grain.sprout.platform.doja;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import jp.grain.sprout.DataHandler;

import org.xmlpull.v1.XmlPullParserException;

/**
 * TODO DataLoadOperation
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public class DataLoadOperation extends HttpPostOperation {

    DataHandler _handler;
    
    /**
     * @param uri
     * @param contentType
     */
    public DataLoadOperation(String uri, DataHandler handler) {
        super(uri, "application/xml");
        _handler = handler;
    }

    /* (non-Javadoc)
     * @see jp.grain.sprout.SerializeOperation#doCompletion()
     */
    protected void doCompletion() throws Exception {
        // Nothing to do.
    }

    /* (non-Javadoc)
     * @see jp.grain.sprout.SerializeOperation#doException(java.lang.Exception)
     */
    protected void doException(Exception e) {
        // Nothing to do.
    }

    /* (non-Javadoc)
     * @see jp.grain.sprout.platform.doja.HttpPostOperation#writeRequest(java.io.OutputStream)
     */
    protected void writeRequest(OutputStream os) throws IOException {
        // Nothing to do.
    }

    /* (non-Javadoc)
     * @see jp.grain.sprout.platform.doja.HttpPostOperation#readResponse(java.io.InputStream)
     */
    protected void readResponse(InputStream is) throws IOException, XmlPullParserException {
        _handler.handleInputStream(is);        
    }

}
