/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2005/07/20 14:57:21
 * 
 */
package jp.grain.sprout.platform.doja.ui;

import java.io.IOException;
import java.io.InputStream;

import jp.grain.spike.CDataNode;
import jp.grain.sprout.DataHandler;
import jp.grain.sprout.SerializeOperation;
import jp.grain.sprout.model.InstanceElement;
import jp.grain.sprout.ui.DrawContext;
import jp.grain.sprout.ui.Form;
import jp.grain.sprout.ui.InlineComponent;

import com.nttdocomo.io.ConnectionException;
import com.nttdocomo.opt.ui.Graphics2;
import com.nttdocomo.ui.MediaImage;
import com.nttdocomo.ui.MediaManager;
import com.nttdocomo.ui.UIException;

/**
 * ImageNX
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public class Image extends InlineComponent implements DataHandler {

	public static final String NAME = "image";

	public static final String ATTR_SRC = "";

	public static final int DEFAULT_SIZE = 15;

	private com.nttdocomo.ui.Image _image;

	private MediaImage tmpImageResource = null;

	public Image() {
		super(NAME);
	}

	public void init(Form form) {
		String src = getAttribute(ATTR_SRC);
		if (src != null) {
			SerializeOperation ope = form.getContext().createDataLoadOperation(
					form.createCanonicalUrl(src), this);
			ope.execute(form.getContext());
		}
		super.init(form);
	}

	protected void applySelf(Form form) {
		InstanceElement srcNode;

		super.applySelf(form);
		if (tmpImageResource != null) {
			tmpImageResource.unuse();
			tmpImageResource.dispose();
			_image.dispose();
			_image = null;
		}
		if (_image == null) {
			srcNode = (InstanceElement) getBindingNode();
			if (srcNode != null) {
				if (srcNode.getChildCount() != 0) {
					tmpImageResource = MediaManager
							.getImage(((CDataNode) (srcNode.getChild(0)))
									.getData());
					try {
						tmpImageResource.use();
					} catch (ConnectionException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (UIException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
					_image = tmpImageResource.getImage();
				} else {
					_width = DEFAULT_SIZE;
					_height = DEFAULT_SIZE;
				}
			} else {
				_width = DEFAULT_SIZE;
				_height = DEFAULT_SIZE;
			}
		} 
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.haw.grain.sprout.Renderer#draw(jp.haw.grain.sprout.DrawContext)
	 */
	public void draw(DrawContext dc) {
		if(dc.getY() < 0 || dc.getY() > getOwnerForm().getContext().getHeight()) return ;
		Graphics2 g = (Graphics2) dc.getRawContext();
		if (_image == null) {
			g.setColor(0xFF0000);
			g.drawLine(0, 0, DEFAULT_SIZE, DEFAULT_SIZE);
			g.drawLine(DEFAULT_SIZE, 0, 0, DEFAULT_SIZE);
			g.setColor(0xCCCCCC);
			g.drawRect(0, 0, DEFAULT_SIZE, DEFAULT_SIZE);
		} else {
			g.drawScaledImage(_image, x, y, x + _width, y + _height, 
					0, 0, _image.getWidth(), _image.getHeight());
		}
	}

	public boolean hasOuterLabel() {
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.grain.sprout.DataHandler#handleInputStream(java.io.InputStream)
	 */
	public void handleInputStream(InputStream is) throws IOException {
		try {
			MediaImage mi = MediaManager.getImage(is);
			mi.use();
			_image = mi.getImage();
		} catch (UIException e) {
			// 2006.6.14
			throw e;
		}
	}

}
