package jp.grain.sprout.ui;

import java.util.Vector;

import jp.grain.spike.Node;
import jp.grain.sprout.model.InstanceElement;

public class Choices extends Inline implements ItemContainer {
	
    public static final String NAME = "choices";
    
    private Item[] _items;
    
	public Choices() {
		super(Choices.NAME);
	}
	
	protected void applySelf(Form form) {
		// TODO ꂽ\bhEX^u
		
	}

	public void draw(DrawContext dc) {
		// TODO ꂽ\bhEX^u
		
	}

	public void commitValue(InstanceElement element) {
		Vector values = new Vector();
		for (int i = 0; i < getItems().length; i++) {
			Item item = this._items[i];

			if (item.isSelected()) {
				values.addElement(item.getValue());
			}
		}
		
		element.setSimpleContent(joinSpace(values));
	}

	/**
	 * vectorString𔼊pXy[Xŋ؂Ԃ܂B
	 * 
	 * @param vector
	 * @return
	 */
	private String joinSpace(Vector vector) {
		StringBuffer result = new StringBuffer(vector.size());
		for (int i = 0; i < vector.size(); i++) {
			result.append(vector.elementAt(i).toString());
		}

		return result.toString();
	}

	public void DeselectAll() {
		for(int i=0; i<getChildCount(); i++) {
			((Item)getChild(i)).setSelected(false);
		}
	}

	public Item getItemAt(int index) {
		return (Item)getChild(index);
	}

	public Item[] getItems() {
		if(this._items == null) {
			this._items = new Item[getChildCount()];
			this._children.copyInto(this._items);
		}
		
		return this._items;
	}

	public void preProcess(Node parent) {
		if (parent instanceof SelectComponent) {
			this._parent = parent;
			SelectComponent sc = (SelectComponent)parent;
			sc.addChild(this);
			sc.setItemContainer(this);
		}
	}

	public void postProcess(Node parent) {
	}

}
