/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2005/11/20 13:53:44
 * 
 */
package jp.grain.sprout.ui;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

import jp.grain.spike.Document;
import jp.grain.spike.Element;
import jp.grain.spike.Node;
import jp.grain.spike.event.Event;
import jp.grain.spike.event.EventListener;
import jp.grain.spike.event.FocusListener;
import jp.grain.sprout.model.Instance;
import jp.grain.sprout.model.Model;

/**
 * TODO Session
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public class Form extends Document implements EventListener {

	public static final String NAME = "form";

	private Vector _models = new Vector();
	private Vector _handlers = new Vector();
	private String _url;
	private Hashtable _eventListenerMap = new Hashtable();

	private int _currentIndex;
	private int _nextNaviIndex;
	private boolean _enable = true;
	private Stack _bindingElements = new Stack();
	private FormContext _context;
	private Stack _ctxModelStack = new Stack();
	private Hashtable _ctxNodeMap = new Hashtable();

	/**
	 * @param dc
	 */
	public void draw(DrawContext dc) {
		dc.clearClip();
		clearBoundary(dc);
		getRootBlock().draw(dc);
		dc.drawFloating();
	}

	private void clearBoundary(DrawContext dc) {
		if (_handlers.size() == 0) return;
		Box component = (Box) _handlers.lastElement();
		int height = component.getHeight();
		dc.clearRect(0, height, 1000, 1000);
		/**
		 * Note: The function's primary purpose is to delete floating objects
		 * [see: ticket 17] (e.g. Choice's drop-down list). The floating objects
		 * may span multiple lines which is dependent on the GUD and screen
		 * size, therefore a value high enough is set to width and height (e.g.
		 * 1000, 1000 respectively), other appropriate values may be set.
		 */
	}

	/**
	 * @param uri
	 */
	public void setBaseUrl(String url) {
		_url = url;
	}

	public String getBaseUrl() {
		return _url;
	}

	public FormContext getContext() {
		return _context;
	}

	/**
	 * @param gud
	 */
	public void setRootBlock(Block block) {
		// if (!(block instanceof Element)) throw new
		// IllegalArgumentException();
		setRootElement((Element) block);
	}

	/**
	 * @return
	 */
	public Block getRootBlock() {
		return (Block) getRootElement();
	}

	/**
	 * @param writer
	 */
	public void toXml(OutputStreamWriter writer) {
		// TODO Auto-generated method stub
	}

	/**
	 * @throws IOException
	 * 
	 */
	public void init(FormContext context) throws IOException {
		System.out.println("FORM INIT: Called");
		_context = context;
		_context.formInitStart(true);

		/**
		 * processModelConstruct(); processModelConstructDone(); processReady();
		 */

		Event initEvent = new Event(Event.TYPE_XFORMS_MODEL_CONSTRUCT, this, null, true, false, context);
		notifyEvent(initEvent);
		initEvent.setType(Event.TYPE_XFORMS_MODEL_CONSTRUCT_DONE);
		notifyEvent(initEvent);
		initEvent.setType(Event.TYPE_XFORMS_READY);
		notifyEvent(initEvent);

		_context.formInitStart(false);
	}

	/**
	 * 
	 */
	public void layout() {
		System.out.println("SUBMISSION: FORM LAYOUT: this=" + this.getClass().getName() + "@" + this.hashCode());
		FocusListener current = getFocusedComponent();
		// navigationXgXV
		resetNavigation();
		getRootBlock().apply(this);
		_currentIndex = _handlers.indexOf(current);
		if (_currentIndex < 0) _currentIndex = 0;
		//SĂ̏ItH[JX^
		getFocusedComponent().handleEvent(new Event(Event.TYPE_DOMFOCUSIN, this, null, true, false, _context));
	}

	protected void resetNavigation() {
		for (int i = 0; i < _handlers.size(); i++) {
			FocusListener lis = (FocusListener) _handlers.elementAt(i);
			lis.setNavigationIndex(FocusListener.DEFAULT_NAVI_INDEX);
		}

		_handlers.removeAllElements();
		_nextNaviIndex = 0;
	}

	/**
	 * @return
	 */
	public int getModelCount() {
		return _models.size();
	}

	public Model getModel(int index) {
		System.out.println("get model : model size = " + _models.size());
		if (_models.size() == 0) return null;
		return (Model) _models.elementAt(index);
	}

	public void addModel(Model model) {
		_models.addElement(model);
		model.setParent(this);
	}

	/**
	 * CxgXi[o^܂B
	 * 
	 * @param listener
	 */
	public void addEventListener(EventListener listener) {
		String[] events = listener.getHandleEvents();
		if (events == null || events.length == 0) return;
		for (int i = 0; i < events.length; i++) {
			if (events[i] == null) continue;
			Vector listeners = (Vector) _eventListenerMap.get(events[i]);
			if (listeners == null) {
				listeners = new Vector();
				_eventListenerMap.put(events[i], listeners);
			}
			listeners.addElement(listener);
		}
	}

	/**
	 * Cxgo^Ă郊Xi[ɒʒm܂
	 * 
	 * @param event
	 */
	public void notifyEvent(Event event) {
		if (event == null) return;
		// 2006/06/06 nakajo CxǧSẴCxg͂珈
		System.out.println("NOTIFY: event=" + event.getType());
		Vector listeners = (Vector) _eventListenerMap.get(event.getType());
		if (listeners == null || listeners.size() == 0) return;
		System.out.println("NOTIFY: listeners=" + listeners.size());

		for (int i = 0; i < listeners.size(); i++) {
			System.out.println("NOTIFY: listeners=" + listeners.elementAt(i).getClass().getName());
			((EventListener) listeners.elementAt(i)).dispatchEvent(event);
		}
	}

	public boolean dispatchEvent(Event event) {
		return handleEvent(event);
	}

	public String[] getHandleEvents() {
		String[] events = new String[5];
		// ANVCxg
		events[0] = Event.TYPE_GRAIN_ACTION_EVENT;
		events[1] = Event.TYPE_XFORMS_MODEL_CONSTRUCT_DONE;
		events[2] = Event.TYPE_GRAIN_INPUT_COMMITED;
		events[3] = Event.TYPE_XFORMS_READY;
		events[4] = Event.TYPE_XFORMS_REFRESH;

		return events;
	}

	public boolean handleEvent(Event event) {

		if (event.getType() == Event.TYPE_GRAIN_ACTION_EVENT) {
			Event ev = event.getTriggerEvent();
			if (ev == null) return false;

			EventListener listener = getFocusedComponent();
			boolean handled = listener.dispatchEvent(ev);
			System.out.println("HANDLED: handle=" + handled + ": listener=" + listener.getClass().getName());
			System.out.println("HANDLED: form=" + this.getClass().getName() + "@" + this.hashCode());
			if (handled) return false;
			if (ev.getType() == Event.TYPE_XFORMS_NEXT || ev.getType() == Event.TYPE_XFORMS_PREVIOUS) {
				EventListener renewed = (ev.getType() == Event.TYPE_XFORMS_NEXT) ? nextNavigation() : previousNavigation();
				if (listener == renewed) return false;
				listener.dispatchEvent(new Event(Event.TYPE_DOMFOCUSOUT, this, ev));
				renewed.dispatchEvent(new Event(Event.TYPE_DOMFOCUSIN, this, ev));

			} else if (ev.getType() == Event.TYPE_GRAIN_CANCEL) {
			}
		} else if (event.getType() == Event.TYPE_XFORMS_FOCUS) {
			//ƓꏈHƂCxg̑S̓IɌBBBB
			EventListener listener = (EventListener)findNodeById(event.getTargetId());
			if(listener.handleEvent(event)) {
				Event focus = new Event(Event.TYPE_DOMFOCUSOUT, this, event);
				getFocusedComponent().dispatchEvent(focus);
				_currentIndex = _handlers.indexOf(listener);
				focus.setType(Event.TYPE_DOMFOCUSIN);
				listener.dispatchEvent(focus);
			}
		} else if (event.getType() == Event.TYPE_GRAIN_INPUT_COMMITED) {
			// IME-COMMITED̂Ƃ͏ɌĂ΂̂ŒlύXꂽǂ`FbN
			// ȊO͒lύXꂽƂ̂ݔ̂ł̂܂܏p
			Event ev = event.getTriggerEvent();
			EventListener listener = getFocusedComponent();
			Box box = (Box) listener;
			String content = box.getBindingSimpleContent();
			if (ev.getType() == Event.TYPE_GRAIN_IME_COMMITED) {
				if (content.equals(_context.getIMEText())) return false;
			}

			// 4.6.7 V[PXFtH[JX̕ύX𔺂l̕ύX
			// 1.xforms-recalculate
			Event valueChanged = new Event(Event.TYPE_XFORMS_RECALCULATE, this, event);
			notifyEvent(valueChanged);
			// 2.xforms-revalidate
			valueChanged.setType(Event.TYPE_XFORMS_REVALIDATE);
			notifyEvent(valueChanged);
			// 3.[n] xforms-valid/xforms-invalid;
			// xforms-enabled/xforms-disabled;
			// xforms-optional/xforms-required;
			// xforms-readonly/xforms-readwrite
			// modelʒm

			// 4.xforms-value-changed
			valueChanged.setType(Event.TYPE_XFORMS_VALUE_CHANGED);
			valueChanged.setBubbles(true);
			valueChanged.setCancelable(false);
			System.out.println("NOTIFY: event=" + event.getType());
			System.out.println("NOTIFY: listeners=" + listener.getClass().getName());
			listener.dispatchEvent(valueChanged);

			// 5.DOMFocusOut
			// 6.DOMFocusIn
			// 7.xforms-refresh
			valueChanged.setType(Event.TYPE_XFORMS_REFRESH);
			handleEvent(valueChanged);
		} else if (event.getType() == Event.TYPE_XFORMS_MODEL_CONSTRUCT_DONE) {
			getRootBlock().init(this);
		} else if (event.getType() == Event.TYPE_XFORMS_READY) {
		} else if (event.getType() == Event.TYPE_XFORMS_REFRESH) {
			getRootBlock().init(this);
			_context.requestRefresh();
			_context.requestRender();
		}

		_context.requestRender();
		return false;
	}

	/**
	 * Form̃irQ[VXgɓo^܂B
	 * componentnavigationIndexUĂȂꍇ͓o^ɊU܂B
	 * 2xڈȍ~̓o^ɂ͂̊UꂽnavigationIndexɓK؂ȃirQ[Vʒu o^܂B
	 * 
	 * @param index
	 * @param component
	 */
	public void registeNavigation(int index, FocusListener component) {
		System.out.println("NOTIFY: REGIST_NAVIGATION: component[" + component.getNavigationIndex() + "]=" + component.getClass().getName());

		// ROWInlineComponentapplyɂQxo^Ă܂̂ŁAłɓo^ς݂Ȃ̂
		// 폜邽߂̏B
		// ̂t@N^̂ł̂Ƃɂ͕sKvɂȂĂBBBB͂H
		if (_handlers.contains(component)) _handlers.removeElement(component);

		System.out.println("REGIST_NAVIGATION: remove size=" + _nextNaviIndex);

		if (component.getNavigationIndex() == FocusListener.DEFAULT_NAVI_INDEX) {
			component.setNavigationIndex(_nextNaviIndex);
			_handlers.addElement(component);
			_nextNaviIndex++;
		} else {
			// ̈ʒuɐzu邽߂navigationIndexr
			for (int i = 0; i < _handlers.size(); i++) {
				FocusListener lis = (FocusListener) _handlers.elementAt(i);
				if (lis.getNavigationIndex() > component.getNavigationIndex()) {
					_handlers.insertElementAt(component, i);
					return;
				}
			}

			_handlers.addElement(component);
		}

		System.out.println("NOTIFY: REGIST_NAVIGATION: add size=" + _nextNaviIndex);
	}

	/**
	 * Form̃irQ[Vvf폜܂B ̃\bh͎relevant=falsêƂɌĂ΂ׂłB
	 * 
	 * @param component
	 */
	public void removeNavigation(FocusListener component) {
		System.out.println("NOTIFY: REMOVE_NAVIGATION: component[" + component.getNavigationIndex() + "]=" + component.getClass().getName());

		_handlers.removeElement(component);
	}

	/**
	 * @param button
	 * @return
	 */
	public boolean isFocusingOn(FocusListener handler) {
		if (_handlers.isEmpty()) return false;
		FocusListener current = (FocusListener) _handlers.elementAt(_currentIndex);
		return handler == current;
	}

	public FocusListener nextNavigation() {
		if (_handlers.isEmpty()) return NullComponent.INSTANCE;
		int next = _currentIndex + 1;
		_currentIndex = next < _handlers.size() ? next : 0;
		return (FocusListener) _handlers.elementAt(_currentIndex);
	}

	public FocusListener previousNavigation() {
		if (_handlers.isEmpty()) return NullComponent.INSTANCE;
		int prev = _currentIndex - 1;
		_currentIndex = prev < 0 ? _handlers.size() - 1 : prev;
		return (FocusListener) _handlers.elementAt(_currentIndex);
	}

	public FocusListener getFocusedComponent() {
		System.out.println("NOTIFY: getFocusedComponent size=" + _handlers.size());
		if (_handlers.isEmpty()) return NullComponent.INSTANCE;
		FocusListener handl = (FocusListener) _handlers.elementAt(_currentIndex);
		System.out.println("NOTIFY: handl=" + handl.getClass().getName());
		return handl;
	}

	private void focusOn(FocusListener listener) {
		if(_handlers.isEmpty()) return;
		
		this._currentIndex = _handlers.indexOf(listener);
		
	}
	
	/**
	 * @param block
	 */
	public void pushContextNodeset(ContextNodeset contextNodeset) {
		_bindingElements.push(contextNodeset);
	}

	/**
	 * @param block
	 */
	public void popContextNodeset() {
		if (_bindingElements.isEmpty()) throw new RuntimeException();
		_bindingElements.pop();
	}

	public Model getContextModel(String id) {

		System.out.println("get context mode id = " + id);

		// 7.4-3-a: context model which 'model' atttibeute determines is used
		if (id != null) {
			Node node = findNodeById(id);
			if (node != null && node instanceof Model) return (Model) node;
		}

		// 7.4.3-b: The context model of immediately enclosing element is used
		if (!_bindingElements.isEmpty()) {
			ContextNodeset contextNodeset = (ContextNodeset) _bindingElements.peek();
			return contextNodeset.getModel();
		}

		// 7.4-3-c: The first model in document order is used (when no 'model'
		// attribute was supplied)
		return (Model) getModel(0);
	}

	public Stack getBindingElements() {
		return _bindingElements;
	}

	/**
	 * 
	 */
	public static void init() {
		FormBuilder.registerComponent(NAME, new Form().getClass());
	}

	public void setEnable(boolean enable) {
		_enable = enable;
	}

	public boolean getEnable() {
		return _enable;
	}

	public String createCanonicalUrl(String url) {
		String baseUrl = getBaseUrl();
		if (url.startsWith("http://")) return url;
		return baseUrl.substring(0, baseUrl.lastIndexOf('/') + 1) + url;
	}

	// 20060521ǉ
	private Model getContextModel() {
		if (_ctxModelStack.isEmpty()) {
			// 7.4-3-c: The first model in document order is used (when no
			// 'model' attribute was supplied)
			return (Model) getModel(0);
		} else {
			// 7.4.3-b: The context model of immediately enclosing element is
			// used
			return (Model) _ctxModelStack.peek();
		}
	}

	public void pushContextModel(Model model) {
		System.out.println("CTXMODEL: push id="+model.getAttribute("id"));
		_ctxModelStack.push(model);
	}

	public Model popContextModel() {
		System.out.println("CTXMODEL: pop id="+((Model)_ctxModelStack.peek()).getAttribute("id"));
		return (Model) _ctxModelStack.pop();
	}

	public Node getContextNode() {
		Model model = getContextModel();
		System.out.println("CTXMODEL: getContextNode() id="+model.getAttribute("id"));
		Stack stack = (Stack) _ctxNodeMap.get(model);
		System.out.println("CTXMODEL: stack="+stack);
		if (stack == null || stack.isEmpty()) {
			System.out.println("CTXMODEL: model="+model);
			Instance ins = model.getInstance();
			System.out.println("CTXMODEL: ins="+ins);
			Element element = ins.getRootElement();
			System.out.println("CTXMODEL: element="+element);
			return element;
		} else {
			System.out.println("CTXMODEL: stack="+stack.size());
			return (Node) stack.peek();
		}
	}

	public void pushContextNode(Node contextNode) {
		Model model = getContextModel();
		if (_ctxModelStack.isEmpty()) {
			_ctxModelStack.push(model);
		}
		Stack stack = (Stack) _ctxNodeMap.get(model);
		if (stack == null) {
			stack = new Stack();
			_ctxNodeMap.put(model, stack);
		}
		stack.push(contextNode);
	}

	public void popContextNode() {
		Model model = getContextModel();
		Stack stack = (Stack) _ctxNodeMap.get(model);
		stack.pop();
	}

	// /* (non-Javadoc)
	// * @see
	// jp.grain.sprout.ui.FormContext#execute(jp.grain.sprout.SerializeOperation)
	// */
	// public void execute(SerializeOperation op) {
	// Connection conn = null;
	// try {
	// conn = _context.createConnection(op);
	// op.execute(conn);
	// System.out.println("handling serialization");
	// } catch (IOException e) {
	// // skip error
	// _context.showErrorDialog("ʐMG[ɂtH[̎擾Ɏs܂B\n{ݒmFĂB\n", e);
	// } catch (XmlPullParserException e) {
	// _context.showErrorDialog("擾tH[̉͂͂ł܂B\n", e);
	// } finally {
	// try {
	// System.out.println("closing connection");
	// if (conn != null) conn.close();
	// } catch (IOException e) {
	// System.out.println("closing err");
	// e.printStackTrace();
	// }
	// }
	// }

}
