/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/01/23 10:22:55
 * 
 */
package jp.grain.sprout.ui;

import jp.grain.spike.Element;
import jp.grain.spike.Node;
import jp.grain.sprout.BindingElement;

/**
 * TODO Item
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public class Item extends Element {

    public static final String NAME = "item";
    protected BindingElement _label;
    protected BindingElement _value;
    protected boolean _selected;
    
    /**
     * @param name
     */
    public Item() {
        super(NAME);
    }

    public String getLabel() {
        return _label.getText();
    }
    
    public void setLabel(BindingElement label) {
        this._label = label;
    }
    
    public String getValue() {
        return _value.getText();
    }

    public BindingElement getValueElement() {
    	return this._value;
    }
    
    public void setValue(BindingElement value) {
        this._value = value;
    }
    
    public void setSelected(boolean bool) {
    	this._selected = bool;
    }
    
    public boolean isSelected() {
    	return this._selected;
    }
    
    /* (non-Javadoc)
     * @see jp.grain.spike.Node#preProcess(jp.grain.spike.Node)
     */
    public void preProcess(Node parent) {
        if (parent instanceof Choices) {
            ((Choices)parent).addChild(this);
        } else if (parent instanceof SelectComponent) {
                ((SelectComponent)parent).addChild(this);
        }
    }

    /* (non-Javadoc)
     * @see jp.grain.spike.Node#postProcess(jp.grain.spike.Node)
     */
    public void postProcess(Node parent) {
        // notihng to do
    }

	public int getNodeType() {
		return Node.NODE_TYPE_ELEMENT;
	}
}
