package jp.grain.sprout.ui;

import java.util.Hashtable;
import java.util.Vector;

import jp.grain.spike.Node;
import jp.grain.sprout.BindingElement;
import jp.grain.sprout.model.InstanceElement;

public class Itemset extends BindingElement implements ItemContainer {

	public static final String NAME = "itemset";

	private BindingElement _value;
	private BindingElement _label;
	private BindingElement _copy;
	private Item[] _items;
	private Hashtable _copyNodeMap = new Hashtable(); 

	public Itemset() {
		super(Itemset.NAME);
	}

	protected void initChildren(Form form) {
		if (getBindingNodeset() == null || getBindingNodeset().length == 0) {
			this._items = new Item[0];
			return;
		}
		
		Node[] nodeset = getBindingNodeset();
		
		Vector items = new Vector(nodeset.length);
		for (int i = 0; i < nodeset.length; i++) {
			form.pushContextNode(nodeset[i]);
			Item item = new Item();
			System.out.println("Itemset: label="+_label);
			GudAttribute name = null;
			if(_label != null) {
				name = new GudAttribute("name");
				name.setBindingExpr("ref", this._label.getBindingExpr());
				name.setText(_label.getSimpleContent());
			}

			System.out.println("Itemset: _value="+_value);
			System.out.println("Itemset: _copy="+_copy);
			GudAttribute value = new GudAttribute("value");
			if (this._value != null) {
				value.setBindingExpr("ref", this._value.getBindingExpr());
				value.setText(_value.getSimpleContent());
			} else if (this._copy != null) {
				value.setBindingExpr("ref", this._copy.getBindingExpr());
				value.setText(_copy.getSimpleContent());
			}

			if(name == null) {
				//labelw肳ĂȂƂvalue̒lg
				name = new GudAttribute("name");
				name.setBindingExpr("ref", value.getBindingExpr());
				name.setText(value.getText());
			}
			
			name.requestEvaluate();
			value.requestEvaluate();
			name.init(form);
			value.init(form);
			item.setLabel(name);
			item.setValue(value);
			items.addElement(item);

			form.popContextNode();
		}

		this._items = new Item[items.size()];
		items.copyInto(this._items);
	}

	public void postProcess(Node parent) {
	}

	public void preProcess(Node parent) {
		if (parent instanceof SelectComponent) {
			this._parent = parent;
			SelectComponent sc = (SelectComponent)parent;
			sc.addChild(this);
			sc.setItemContainer(this);
		}
	}

	public void commitValue(InstanceElement element) {
		if (this._items == null) return;
		if (this._copy != null) {
			for (int i = 0; i < this._items.length; i++) {
				Item item = this._items[i];
				Node bindingNode = item.getValueElement().getBindingNode();
				if(this._copyNodeMap.containsKey(item)) {
					element.removeChild((Node)this._copyNodeMap.get(item));
					this._copyNodeMap.remove(item);
				}
				if (item.isSelected()) {
					Node cloneNode = bindingNode.clone(bindingNode.getDocument());
					System.out.println("Itemset: clone="+cloneNode+": value="+cloneNode.getSimpleContent());
					this._copyNodeMap.put(item, cloneNode);
					element.addChild(cloneNode);
				}
			}
		} else if(this._value != null) {
			Vector values = new Vector();
			for (int i = 0; i < this._items.length; i++) {
				Item item = this._items[i];

				if (item.isSelected()) {
					values.addElement(item.getValue());
				}
			}
			
			element.setSimpleContent(joinSpace(values));
		}
	}

	/**
	 * vectorString𔼊pXy[Xŋ؂Ԃ܂B
	 * 
	 * @param vector
	 * @return
	 */
	private String joinSpace(Vector vector) {
		StringBuffer result = new StringBuffer(vector.size());
		for (int i = 0; i < vector.size(); i++) {
			result.append(vector.elementAt(i).toString());
		}

		return result.toString();
	}

	public void DeselectAll() {
		for(int i=0; i<this._items.length; i++) {
			this._items[i].setSelected(false);
		}
	}

	public Item getItemAt(int index) {
		return this._items[index];
	}

	public Item[] getItems() {
		return this._items;
	}

	public void setCopy(BindingElement copy) {
		if (this._value != null) return;
		this._copy = copy;
	}

	public void setLabel(BindingElement label) {
		this._label = label;
	}

	public void setValue(BindingElement value) {
		if (this._copy != null) return;
		this._value = value;
	}

}
