package jp.grain.sprout.ui;

import jp.grain.sprout.model.InstanceElement;

/**
 * @author nakajo
 */
public class Select extends SelectComponent {

	public static final String NAME = "select";

	public Select() {
		super(NAME);
		this._isMultiple = true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.haw.grain.sprout.Renderer#draw(jp.haw.grain.sprout.DrawContext)
	 */
	public void draw(DrawContext dc) {
		System.out.println("DRAW: this[dc.y="+dc.getY()+", box.y="+getBoxHeight()+"]="+this.getClass().getName());
		if(dc.getY()+getBoxHeight() < 0 || dc.getY() > getOwnerForm().getContext().getHeight()) return ;
		
		int sx, sy, sw, sh, tmpChildCount = 0;
		int childCount = this._itemContainer.getItems().length;
		dc.clearClip();
		sw = _width + (_padding + _border) * 2;

		// DavidHou
		if ((tmpChildCount = childCount) > SelectComponent.MAX_DISPLAY_CHILD_COUNT) tmpChildCount = SelectComponent.MAX_DISPLAY_CHILD_COUNT;

		sh = (_font.getHeight() + _padding * 2) * tmpChildCount + _border * 2;
		int spaceConstant = 8 + _font.getHeight();
		// FOCUS
		if (getOwnerForm().isFocusingOn(this) && !_activate) {
			dc.setColor(COLOR_FOCUS);
			dc.drawRect(0, 0, getBoxWidth() + spaceConstant + SIZE_ARROW - 1, sh);
		}

		dc.setColor(COLOR_BLACK);
		if (childCount == 0) return;
		// BOX
		dc.setEmbossParam(_border, COLOR_FIELD, COLOR_EDGE_DARK, COLOR_EDGE_LIGHT, false);
		dc.drawEmbossedRect(_margin, _margin, _width + (_padding + _border) * 2 + spaceConstant + SIZE_ARROW, sh - 1);
		InstanceElement node = getBindingInstanceElement();
		// disablȅ
		if (node != null && !node.isRelevant()) {
			dc.setColor(0xD2D2D2);
			dc.fillRect(_margin + _border, _margin + _border, _width - (_padding + _border) + spaceConstant + SIZE_ARROW, sh - (_border + _padding));
			dc.setColor(COLOR_BLACK);
		} else {
			// XN[o[̕`
			dc.setEmbossParam(SIZE_ARROW_EDGE, COLOR_BUTTON, COLOR_EDGE_LIGHT, COLOR_EDGE_DARK, _pressed || _activate);
			int ax = _width + (_padding + _border) * 2 + spaceConstant;
			int ay = _margin + _border;
			// XN[o[̕` ܂
			// XN[o[̃XN[
			int embossHeight = sh - (_padding + _border);
			int addHeight = 0;
			if (SelectComponent.MAX_DISPLAY_CHILD_COUNT < childCount) {
				int scrollStep = childCount - SelectComponent.MAX_DISPLAY_CHILD_COUNT;
				addHeight = embossHeight / childCount;
				embossHeight = embossHeight - (addHeight * scrollStep);
				System.out.println("CHOICE: maxHeight=" + (_height + _padding * 2));
				System.out.println("CHOICE: addHeight=" + addHeight);
			}
			int embossY = ay + (addHeight * this.displayStart);

			dc.drawEmbossedRect(ax, embossY, SIZE_ARROW, embossHeight);
			// XN[o[̃XN[ ܂
		}
		// ITEMS & SHADE
		sx = _border + spaceConstant;
		sy = _border;
		sw = _padding * 2 + _width;
		sh = _padding * 2 + _font.getHeight();

		// DavidHou
		for (int i = this.displayStart; i < this.displayEnd; ++i) {
			Item item = this._itemContainer.getItemAt(i);
			if (i == _currentIndex && _activate) {
				dc.setColor(COLOR_FOCUS);
				dc.fillRect(sx - spaceConstant + 1, sy + 1, sw + spaceConstant, sh);
				dc.setColor(COLOR_FIELD);
			} else {
				dc.setColor(COLOR_BLACK);
			}
			// CHECK
			if (item.isSelected()) {
				dc.drawLine(_padding + 5, _padding + _font.getHeight() + sy - 5, _padding + 7, _padding + _font.getHeight() + sy - 3); // \
				dc.drawLine(_padding + 7, _padding + _font.getHeight() + sy - 3, _padding + _font.getHeight() - 3, _padding + sy + 3); // /
			}
			// CHECKBOX
			dc.drawRect(_padding * 2, (sy + _padding), _font.getHeight(), _font.getHeight());
			dc.drawString(item.getLabel(), sx + _padding, sy + _padding);
			sy += sh;
		}

		// required̏
		if (node != null && node.isRequired()) {
			dc.setColor(0xFF0000);
			dc.drawString("*", _width + (_padding + _border) * 2 + spaceConstant + SIZE_ARROW + _margin, getContentY());
		}

	}

	//2006.6.19 //YC
    public int getBoxHeight() {
    	if(this.getChildCount()>=MAX_DISPLAY_CHILD_COUNT){
    		return super.getBoxHeight() + this._margin;
    	}else{
    		return super.getBoxHeight();
    	}
    }
}
