package jp.grain.sprout.ui;

import java.util.Vector;

import jp.grain.spike.event.Event;
import jp.grain.sprout.BindingElement;

/**
 * @author nakajo
 */
public abstract class SelectComponent extends InlineComponent {

	protected static final int COLOR_BLACK = 0x000000; // 
	protected static final int COLOR_BUTTON = 0x999999; // {^wi
	protected static final int COLOR_EDGE_DARK = 0x333333; // {^GbW(Áj
	protected static final int COLOR_EDGE_LIGHT = 0xCCCCCC; // {^GbW()
	protected static final int COLOR_FOCUS = 0xFF6666; // {^IIF
	protected static final int COLOR_FIELD = 0xFFFFFF; // wi
	protected static final int SIZE_BORDER = 1;
	protected static final int SIZE_MARGIN = 1;
	protected static final int SIZE_MINIMUM = SIZE_MARGIN + 3;
	protected static final int SIZE_PADDING = 2;
	protected static final int SIZE_ARROW = 7;
	protected static final int SIZE_ARROW_MARGIN = 1;
	protected static final int SIZE_ARROW_EDGE = 1;
	protected static final int MAX_DISPLAY_CHILD_COUNT = 5;
	
	protected String label;
	protected boolean _pressed;
	protected int _selectionIndex;
	protected int _currentIndex;
	protected boolean _isMultiple;
	protected Vector _selections;
	protected ItemContainer _itemContainer;

	// DavidHou
	protected int displayNum = 0;
	protected int displayStart = 0;
	protected int displayEnd = SelectComponent.MAX_DISPLAY_CHILD_COUNT;

	public SelectComponent(String name) {
		super(name);
		_margin = SIZE_MARGIN;
		_border = SIZE_BORDER;
		_padding = SIZE_PADDING;
	}

	public void init(Form form) {
		//itemvf݂̂̒`OKɂ邽߂ɁBBB
		if(this._itemContainer==null) {
			Choices itemContainer = new Choices();
			itemContainer.setChildren(this._children);
			this._children = new Vector();
			this._itemContainer = itemContainer;
			addChild(itemContainer);
		}
		super.init(form);
		initSelected();
	}

    public void initChildren(Form form) {
    	for(int i=0; i<getChildCount(); i++) {
    		((BindingElement)getChild(i)).init(form);
    	}
    }
    
	protected void initSelected() {
		if (getBindingNode() == null) return;
		Vector strs = splitSpace(getBindingNode().getSimpleContent());
		Item[] items = this._itemContainer.getItems();
		for (int i = 0; i < strs.size(); i++) {
			for (int j = 0; j < items.length; j++) {
				if (items[j] == null) continue;
				if (items[j].getValue().equals((String)strs.elementAt(i))) {
					items[j].setSelected(true);
					this._selectionIndex = j;
				}
			}
		}
		
		this._currentIndex = this._selectionIndex;
	}

	/**
	 * m[h̕𔼊pXy[Xŋ؂Ă̌ʂVectorɂĕԂ܂B
	 * 
	 * @param text
	 * @return
	 */
	private Vector splitSpace(String text) {
		if (text == null) return new Vector(0);
		text.trim();
		if (text.length() == 0) return new Vector(0);

		Vector list = new Vector();
		int space = 0;
		while (space != -1) {
			space = text.indexOf(" ");
			if (space == -1) {
				if (text.length() > 0) list.addElement(text);
			} else {
				list.addElement(text.substring(0, space).trim());
				text = text.substring(space, text.length()).trim();
			}
		}

		return list;
	}

	public void apply(Form form) {
		super.apply(form);
		int maxContentWidth = 0;
		_selections = new Vector();
		Item[] items = this._itemContainer.getItems();
		if (_width < 0) {
			for (int i = 0; i < items.length; ++i) {
				Item item = items[i];
				int contentWidth = _font.getWidth(item.getLabel());
				if (contentWidth > maxContentWidth) maxContentWidth = contentWidth;
			}
			_width = _isMultiple ? maxContentWidth : maxContentWidth + SIZE_ARROW;
		}
		if (_width < SIZE_MINIMUM) _width = SIZE_MINIMUM;
		if (_height < _font.getHeight()) _height = _font.getHeight();

		this.displayNum = (items.length > SelectComponent.MAX_DISPLAY_CHILD_COUNT) ? SelectComponent.MAX_DISPLAY_CHILD_COUNT : items.length;
		
		this.displayStart = this._currentIndex;
		this.displayEnd = this._currentIndex + this.displayNum;
		if(this.displayEnd > items.length) {
			int sub = this.displayEnd - items.length;
			this.displayEnd = items.length;
			this.displayStart -= sub;
		}
		
		// Davidhou
		if (_isMultiple) _height = (_height + _padding) * this.displayNum + (_margin + _border) * 2;

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.haw.grain.sprout.Renderer#draw(jp.haw.grain.sprout.DrawContext)
	 */
	public abstract void draw(DrawContext dc);

	public boolean handleEvent(Event event) {
		if (super.handleEvent(event)) return true;
		if (event.getType() == Event.TYPE_DOMACTIVATE) {
			if (_activate) {
				_activate = _isMultiple;
				_selectionIndex = _currentIndex;
				if (this._isMultiple) {
					Item selectItem = this._itemContainer.getItemAt(_currentIndex);
					selectItem.setSelected(!selectItem.isSelected());
					/*
					Integer index = new Integer(_selectionIndex);
					if (_selections.contains(index)) {
						_selections.removeElement(index);
					} else {
						_selections.addElement(index);
					}*/
				} else {
					this._itemContainer.DeselectAll();
					this._itemContainer.getItemAt(_currentIndex).setSelected(true);
					commit(event);
				}
			} else {
				_activate = true;
				_currentIndex = _selectionIndex;
			}
		} else if (event.getType() == Event.TYPE_GRAIN_CANCEL || event.getType() == Event.TYPE_GRAIN_RIGHT || event.getType() == Event.TYPE_GRAIN_LEFT) {
			if (_activate) {
				_activate = false;
				commit(event);
			}
		} else if (_activate && event.getType() == Event.TYPE_XFORMS_NEXT) {
			if (_currentIndex + 1 < this._itemContainer.getItems().length) {
				_currentIndex++;
				// DavidHou
				if (_currentIndex >= displayEnd) {
					if (displayStart < (this._itemContainer.getItems().length - SelectComponent.MAX_DISPLAY_CHILD_COUNT)) {
						displayStart++;
						displayEnd++;
					}
				}
			}
		} else if (_activate && event.getType() == Event.TYPE_XFORMS_PREVIOUS) {
			if (_currentIndex - 1 >= 0) {
				_currentIndex--;
				// DavidHou
				if (_currentIndex < displayStart) {
					displayStart--;
					displayEnd--;
				}

			}
		} else {
			return false;
		}

		event.getContext().requestRender();
		return _activate;
	}

	/**
	 * ͏ԂꂽĂ΂܂B
	 * Iꂽitem͌ʂm肳܂B
	 * 
	 * @param event
	 */
	protected void commit(Event event) {
		if (getBindingNode() == null) return;

		this._itemContainer.commitValue(getBindingInstanceElement());
		Event inputCommited = new Event(Event.TYPE_GRAIN_INPUT_COMMITED, this, event);
		((Form) getDocument()).notifyEvent(inputCommited);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.haw.grain.sprout.InlineElement#action(int, int)
	 */
	public boolean handleAction(FormContext view, int action, int selector) {
		super.handleAction(view, action, selector);
		switch (action) {
		case FormContext.ACT_PRESSED:
			if (selector == FormContext.SEL_SELECT) {
				_pressed = true;
			} else {
				return false;
			}
			break;
		case FormContext.ACT_RELEASED:
			if (selector == FormContext.SEL_SELECT) {
				_pressed = false;
				if (_activate) {
					_activate = false;
					_selectionIndex = _currentIndex;
					if (this._isMultiple) {
						Integer index = new Integer(_selectionIndex);
						if (_selections.contains(index)) {
							_selections.removeElement(index);
						} else {
							_selections.addElement(index);
						}
					}
				} else {
					_activate = true;
					_currentIndex = _selectionIndex;
				}
				// TODO change dispatch mothod
				// this.element.dispatchEvent(new Event("DOMActivate", true,
				// true));
			} else if (selector == FormContext.SEL_CANCEL || selector == FormContext.SEL_RIGHT || selector == FormContext.SEL_LEFT) {
				if (_activate) {
					_activate = false;
				}
			} else if (_activate && selector == FormContext.SEL_DOWN) {
				if (_currentIndex + 1 < this._itemContainer.getItems().length) {
					_currentIndex++;
					// DavidHou
					if (_currentIndex >= displayEnd) {
						if (displayStart < (this._itemContainer.getItems().length - SelectComponent.MAX_DISPLAY_CHILD_COUNT)) displayStart++;
						if (displayEnd < this._itemContainer.getItems().length) displayEnd++;
					}
				}
			} else if (_activate && selector == FormContext.SEL_UP) {
				if (_currentIndex - 1 >= 0) {
					_currentIndex--;
					// DavidHou
					if (_currentIndex < displayStart) {
						displayStart--;
						displayEnd--;
					}

				}
			} else {
				return false;
			}

			break;
		}
		view.requestRender();
		return true;
	}

	public void setItemContainer(ItemContainer container) {
		this._itemContainer = container;
	}
}
