/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2005/07/24 16:50:00 
 */
package jp.grain.sprout.ui;

import jp.grain.spike.event.Event;
import jp.grain.sprout.model.InstanceElement;




/**
 * TextBox
 * 
 * @version $Id: TextBox.java 392 2006-06-29 06:24:23Z nakajo $
 * @author Go Takahashi
 */
public class TextBox extends InlineComponent {

    public static final String NAME = "textbox";
    
    public static final int INPUT_DEVICE_IME = 0;
    public static final int INPUT_DEVICE_QR = 1;
        
    private static final int COLOR_BLACK = 0x000000; // 
    private static final int COLOR_FIELD = 0xFFFFFF; // wi
    private static final int COLOR_EDGE_DARK = 0x333333; // GbW(Áj
    private static final int COLOR_EDGE_LIGHT = 0xCCCCCC; // GbW()
    private static final int COLOR_FOCUS = 0xFF6666; // IIF
    private static final int SIZE_BORDER = 1;
    private static final int SIZE_MARGIN = 1;
    private static final int SIZE_MINIMUM = SIZE_MARGIN + 3;
    private static final int SIZE_PADDING = 2;
    private static final int SIZE_DEFAULT = 50;
        
    private String inputMode;
    private int inputDevice;
    private boolean isSecret;
    private boolean isMultiLine;
    /**
     * 
     */
    public TextBox() {
        super(NAME);
        _margin = SIZE_MARGIN;
        _border = SIZE_BORDER;
        _padding = SIZE_PADDING;   
      
    }
    
    public void apply(Form form) {
        super.apply(form);
        if (_width < 0) _width = SIZE_DEFAULT;
        if (_width < SIZE_MINIMUM) _width = SIZE_MINIMUM;
        if (_height < _font.getHeight()) _height = _font.getHeight();
    }

    /* (non-Javadoc)
     * @see jp.haw.grain.sprout.Renderer#draw(jp.haw.grain.sprout.DrawContext)
     */
    public void draw(DrawContext dc) {
		System.out.println("DRAW: this[dc.y="+dc.getY()+", box.y="+getBoxHeight()+"]="+this.getClass().getName());
		if(dc.getY()+getBoxHeight() < 0 || dc.getY() > getOwnerForm().getContext().getHeight()) return ;
        dc.setEmbossParam(_border, COLOR_FIELD, COLOR_EDGE_DARK, COLOR_EDGE_LIGHT, false);
        dc.drawEmbossedRect(_margin, _margin, _width + (_padding + _border) * 2, _height + (_padding + _border) * 2);
        if (this._focusin) {
            dc.setColor(COLOR_FOCUS);
            dc.drawRect(0, 0, getBoxWidth() - 1, getBoxHeight() - 1);
        }
        dc.setColor(COLOR_BLACK);
        String text = getBindingSimpleContent();
        text = (text != null) ? text : "";
        
        //2006.6.14
        dc.setFont(_font);
        
        if(!isMultiLine) { // g
            int ndx = text.indexOf("\\n");
            if(ndx != -1) text = text.substring(0, ndx);
        }
        
      String flag;
      if((flag = this.getAttribute("secret"))!=null && flag.equals("true"))
      	this.isSecret = true;
        
        
        if(isSecret) {
            int secret = text.length();
            StringBuffer secChar = new StringBuffer(secret);
            for(int i=0; i<secret; i++) secChar.append("*");
            text = secChar.toString();
        }

        InstanceElement node = getBindingInstanceElement();
        //disablȅ
        if(node != null && !node.isRelevant()) {
            dc.setColor(0xD2D2D2);
            dc.fillRect(0, 0, getBoxWidth(), getBoxHeight());
        }
        dc.setColor(COLOR_BLACK);
        dc.clipRect(getContentX(), getContentY(), getWidth(), getHeight());
        dc.drawString((text != null) ? text : "", getContentX(), getContentY());
        dc.clearClip();
        
        //required̏
        if(node != null && node.isRequired()) {
        	dc.setColor(0xFF0000);
        	dc.drawString("*", _width + (_padding + _border) * 2 + _margin, getContentY());
        	dc.setColor(COLOR_BLACK);
        }

    }

    /* (non-Javadoc)
     * @see jp.haw.grain.sprout.InlineElement#action(int, int)
     */
    public boolean handleAction(FormContext view, int action, int selector) {
        if(super.handleAction(view, action, selector)) return true;
        if (action == FormContext.ACT_RELEASED) {
            if (selector == FormContext.SEL_SELECT) {
                if (this.inputDevice == INPUT_DEVICE_QR) {
                    view.launchCodeReader();                    
                } else {
                    view.launchIME(getBindingSimpleContent(), this.inputMode, isSecret);
                }
            }
        } else if (action == FormContext.ACT_IME_RESULT) {
            if (selector == FormContext.SEL_IME_COMMIT) {
                setBindingSimpleContent(view.getIMEText());
                view.requestRender();
                //TODO dispatch event
                //fce.dispatchEvent(new Event("xforms-value-changed", true, false));
                return true;
            }
        }
        return false;
    }

    public boolean handleEvent(Event event) {
    	if(super.handleEvent(event)) return true;
    	if(event.getType() == Event.TYPE_DOMACTIVATE) {
            if (this.inputDevice == INPUT_DEVICE_QR) {
                event.getContext().launchCodeReader();                    
            } else {
            	event.getContext().launchIME(getBindingSimpleContent(), this.inputMode, isSecret);
            }
            return true;
    	} else if(event.getType() == Event.TYPE_XFORMS_VALUE_CHANGED) {
            setBindingSimpleContent(event.getContext().getIMEText());
    	}

		event.getContext().requestRender();
    	return false;
    }
    
    public void setSecret(boolean secret) {
        isSecret = secret;
    }
    
    public boolean getSecret() {
        return isSecret;
    }
    
    public void setMultiline(boolean multiline) {
        isMultiLine = multiline;
    }
    
    public boolean getMultiline() {
        return isMultiLine;
    }
    
    public void setInputDevice(int mode) {
        inputDevice = mode;
    }
    
    public int getInputDevice() {
        return inputDevice;
    }
}
