package jp.grain.sprout.model;

import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestMethod;
import j2meunit.framework.TestSuite;

import java.io.IOException;
import java.io.InputStream;

import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.InputConnection;

import jp.grain.spike.BinaryXMLParser;
import jp.grain.spike.Document;
import jp.grain.spike.Node;
import jp.grain.sprout.Initializer;
import jp.grain.sprout.OperetionListener;
import jp.grain.sprout.SerializeOperation;
import jp.grain.sprout.platform.doja.FormContextImpl;
import jp.grain.sprout.platform.doja.GrainApp;
import jp.grain.sprout.ui.Form;
import jp.grain.sprout.ui.FormBuilder;
import jp.grain.sprout.ui.FormContext;
import jp.grain.sprout.ui.TextBox;

import org.xmlpull.v1.XmlPullParserException;

public class BindTest extends TestCase {

    private Form form;
    
    public BindTest() {
    }

    public BindTest(String name, TestMethod method) {
        super(name, method);
    }
    
    protected void setUp() throws Exception {
        // gbxml rev 154 06/02/02
        MockSproutApp app = new MockSproutApp("resource:///bind_test.gbxml");
        app.start();
        
        FormContextImpl ctx = (FormContextImpl) app.getFormContext();
        ctx.getInitializer().join();
        form = ctx.getForm();
    }

    public void testBindElementCheck() {
    	Model model = form.getModel(0);
    	Instance instance = model.getInstance();
    	Document doc = instance.getInstanceDocument();
    	InstanceElement cc = (InstanceElement)doc.getElementsByTagName("cc").elementAt(0);
    	System.out.println("TESTCASE: cc="+cc);
    	Bind bind_cc = (Bind)form.findNodeById("bind_cc");
    	
        assertEquals("bind object equal", "true", String.valueOf(bind_cc.equals(cc._readonlyProperty)));
    }

    public void testRelevantFalse() {
    	Model model = form.getModel(0);
    	Instance instance = model.getInstance();
    	Document doc = instance.getInstanceDocument();
    	InstanceElement expires = (InstanceElement)doc.getElementsByTagName("expires").elementAt(0);

        assertEquals("relevant is false", "false", String.valueOf(expires.isRelevant()));
    }

    //relevantTrueeXg
    public void testRelevantTrue() {
    	Model model = form.getModel(0);
    	Instance instance = model.getInstance();
    	Document doc = instance.getInstanceDocument();
    	InstanceElement method = (InstanceElement)doc.getElementsByTagName("method").elementAt(0);
    	InstanceElement expires = (InstanceElement)doc.getElementsByTagName("expires").elementAt(0);

    	method.setText("credit");
    	
    	Bind bind_expires = (Bind)form.findNodeById("bind_expires");
    	bind_expires.checkRelevant();

        assertEquals("bind object equal", "true", String.valueOf(bind_expires.equals(expires._relevantProperty)));
        assertEquals("relevant is true", "true", String.valueOf(expires.isRelevant()));
    }

    //calculateeXg
    public void testCalculate() {
    	Model model = form.getModel(0);
    	Instance instance = model.getInstance();
    	Document doc = instance.getInstanceDocument();
    	InstanceElement cost = (InstanceElement)doc.getElementsByTagName("cost").elementAt(0);
    	InstanceElement amount = (InstanceElement)doc.getElementsByTagName("amount").elementAt(0);

    	Bind bind_cost = (Bind)form.findNodeById("bind_cost");

    	//costamount*1 ܂ cost=amount
    	amount.setText("300");
    	bind_cost.reCalculate();
    	
        assertEquals("cost is 300", new Integer(300), new Integer(cost.calculate()));

    	amount.setText("1000");
    	bind_cost.reCalculate();
    	
        assertEquals("cost is 1000", new Integer(1000), new Integer(cost.calculate()));
    }

    //readonlyeXg
    //calculatew肳ĂΏreadonly=trueƂȂ
    public void testReadonlyTrue() {
    	Model model = form.getModel(0);
    	Instance instance = model.getInstance();
    	Document doc = instance.getInstanceDocument();
    	InstanceElement cost = (InstanceElement)doc.getElementsByTagName("cost").elementAt(0);
    	
    	Bind bind_cost = (Bind)form.findNodeById("bind_cost");

        assertEquals("bind object equal", String.valueOf(bind_cost.equals(cost._calculateProperty)), "true" );
        assertEquals("relevant is true", String.valueOf(cost.isReadonly()), "true");
    }

    //relevantpeXg
    //erelevantfalsełfalseɂȂ
    public void testExtendsRelevant() {
    	Model model = form.getModel(0);
    	Instance instance = model.getInstance();
    	Document doc = instance.getInstanceDocument();
    	InstanceElement cost = (InstanceElement)doc.getElementsByTagName("cost").elementAt(0);
    	InstanceElement total = (InstanceElement)doc.getElementsByTagName("total").elementAt(0);

        assertEquals("total relevant is false", String.valueOf(total.isRelevant()), "false");
        assertEquals("child cost relevant is false", String.valueOf(cost.isRelevant()), "false");
    }

    //bindoRnodeset擾
    public void testNodesetFromBind() {
    	Model model = form.getModel(0);
    	Instance instance = model.getInstance();
    	Document doc = instance.getInstanceDocument();
    	TextBox textbox = (TextBox)form.findNodeById("textbox_cc");
    	
    	System.out.println("TESTCASE: textbox="+textbox);
    	
    	Node textbox_nodeset = textbox.getBindingNode();
    	System.out.println("TESTCASE: textbox_nodeset="+textbox_nodeset);
    	
    	InstanceElement cc = (InstanceElement)doc.getElementsByTagName("cc").elementAt(0);

        assertEquals("textbox node eqaulty cc", "true", String.valueOf(cc.equals(textbox_nodeset)));
    }
    
    public Test suite() {
        TestSuite suite = new TestSuite();

        suite.addTest(new BindTest("testBindElementCheck", new TestMethod() {
            public void run(TestCase tc) { ((BindTest)tc).testBindElementCheck(); }
        }));

        suite.addTest(new BindTest("testRelevantFalse", new TestMethod() {
            public void run(TestCase tc) { ((BindTest)tc).testRelevantFalse(); }
        }));

        suite.addTest(new BindTest("testRelevantTrue", new TestMethod() {
            public void run(TestCase tc) { ((BindTest)tc).testRelevantTrue(); }
        }));

        suite.addTest(new BindTest("testCalculate", new TestMethod() {
            public void run(TestCase tc) { ((BindTest)tc).testCalculate(); }
        }));

        suite.addTest(new BindTest("testReadonlyTrue", new TestMethod() {
            public void run(TestCase tc) { ((BindTest)tc).testReadonlyTrue(); }
        }));

        suite.addTest(new BindTest("testExtendsRelevant", new TestMethod() {
            public void run(TestCase tc) { ((BindTest)tc).testExtendsRelevant(); }
        }));

        suite.addTest(new BindTest("testNodesetFromBind", new TestMethod() {
            public void run(TestCase tc) { ((BindTest)tc).testNodesetFromBind(); }
        }));
        return suite;
    }

    /**
     * Mock Classes 
     */
    class MockSproutApp extends GrainApp {

        Throwable error;
        String defaultUri;
        
        MockSproutApp(String defaultUri) {
            setDefaultFormUrl(defaultUri);
            setDefaultFormLocation(DEFAULT_FORM_LOC_HTTP);
            _context = new MockFormContextImpl(this);
        }
        
        public void loadBasicPref() {
        }
        
        public FormContext getFormContext() {
            return _context;
        }
    }
    
    class MockFormContextImpl extends FormContextImpl {

        MockFormContextImpl(GrainApp app) {
            super(app);
        }
                
        public SerializeOperation createSubmissionOperation(String url) {
            return new MockSubmissionOperation(url, this);
        }

        public SerializeOperation createSubmissionOperation(Submission element) {
            if (element == null) {
                return new MockSubmissionOperation(_app.getDefaultFormUrl(), this);
            } else {
                Form f = (Form)element.getDocument();
                return new MockSubmissionOperation(f.createCanonicalUrl(element.getActionUrl()), this);
            }
        }
        
        public SerializeOperation createExternalInstanceLoadOperation(Instance element) {
            return super.createExternalInstanceLoadOperation(element);
        }
    }
    
    class MockSubmissionOperation extends SerializeOperation {

        private String url;
        private Form form;
        private Initializer initializer;
        
        MockSubmissionOperation(String url, FormContext context) {
            this.url = url;
            this.initializer = new Initializer(context);
        }

        public String getConnectionString() {
            return this.url;
        }

        public int getMode() {
            return Connector.READ;
        }

        public Document getInstanceDocument() {
            return null;
        }

        /* (non-Javadoc)
         * @see jp.grain.sprout.FormSerializeOperation#setListener(jp.grain.sprout.OperetionListener)
         */
        public void setListener(OperetionListener observer) {
            // TODO Auto-generated method stub
        }

        /* (non-Javadoc)
         * @see jp.grain.sprout.SerializeOperation#doExecute(javax.microedition.io.Connection)
         */
        protected void doExecute(Connection conn) throws Exception {
            InputStream is = null;
            try {
                is = ((InputConnection)conn).openInputStream();
                BinaryXMLParser parser = BinaryXMLParser.newInstance(is, "SJIS");
                FormBuilder builder = new FormBuilder(parser, getConnectionString(), true);
                builder.build();
                this.form = (Form)builder.getDocument();
            } catch (IOException e) {
                e.printStackTrace();
                throw e;
            } catch (XmlPullParserException e) {
                e.printStackTrace();
            } finally {
                if (is != null) is.close();
            }
        }

        /* (non-Javadoc)
         * @see jp.grain.sprout.SerializeOperation#doCompletion()
         */
        protected void doCompletion() throws Exception {
            this.initializer.init(this.form);
            this.initializer.start();
        }

        /* (non-Javadoc)
         * @see jp.grain.sprout.SerializeOperation#doException(java.lang.Exception)
         */
        protected void doException(Exception e) {
            // TODO Auto-generated method stub
            
        }
    }
}
