/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2005/07/09 15:30:31
 * 
 */
package jp.grain.sprout.platform.doja;

import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestMethod;
import j2meunit.framework.TestSuite;
import jp.grain.sprout.ui.Block;
import jp.grain.sprout.ui.CharactorSequence;
import jp.grain.sprout.ui.DrawContext;
import jp.grain.sprout.ui.Font;
import jp.grain.sprout.ui.Form;
import jp.grain.sprout.ui.FormContext;
import jp.grain.sprout.ui.InlineBlock;
import jp.grain.sprout.ui.Row;

import com.nttdocomo.ui.Canvas;
import com.nttdocomo.ui.Graphics;

/**
 * A test of CharacterSequence
 * 
 * @version $Id: CharactorSequenceTest.java 395 2006-06-30 03:02:57Z nakajo $
 * @author Go Takahashi
 */
public class CharactorSequenceTest extends TestCase {

	public CharactorSequenceTest() {
	}

	public CharactorSequenceTest(String name, TestMethod method) {
		super(name, method);
	}

	public void testAlphabetSeq() {
		Form form = new MockForm();
		
		String text = "this is test string of testAlphabetSeq. I like test driven development. And you're done?";
		Font.setDefaultFont(new FontImpl(com.nttdocomo.ui.Font.getDefaultFont()));
		CharactorSequence cs = new CharactorSequence(text);
		Block rootBlock = new Block();
		InlineBlock inlineB = new InlineBlock();
		inlineB.addChild(cs);
		rootBlock.addChild(inlineB);
		form.setRootBlock(rootBlock);
		
		try {
			cs.init(form);
			Row row1 = new Row(240);
			assertTrue("fit1", cs.fitWithIn(row1));
			assertTrue("continue1", cs.isContinue());
			row1.apply(form);
			Row row2 = new Row(200);
			assertTrue("fit2", cs.fitWithIn(row2));
			assertTrue("continue2", cs.isContinue());
			row2.apply(form);
			Row row3 = new Row(240);
			assertTrue("fit3", cs.fitWithIn(row3));
			assertTrue("continue3", !cs.isContinue());
			row3.apply(form);

			inlineB.addChild(row1);
			inlineB.addChild(row2);
			inlineB.addChild(row3);
			
			MockDrawContext dc = new MockDrawContext(new MockCanvas().getGraphics(), 0, 0);
			row1.draw(dc);
			assertEquals("width", 240, row1.getChildInline(0).getWidth());
			assertEquals("height", 12, row1.getChildInline(0).getHeight());
			assertEquals("toString", "this is test string of testAlphabetSeq. ", dc.drawnString);
			row2.draw(dc);
			assertEquals("width", 198, row2.getChildInline(0).getWidth());
			assertEquals("height", 12, row2.getChildInline(0).getHeight());
			assertEquals("toString", "I like test driven development. A", dc.drawnString);
			row3.draw(dc);
			assertEquals("width", 90, row3.getChildInline(0).getWidth());
			assertEquals("height", 12, row3.getChildInline(0).getHeight());
			assertEquals("toString", "nd you're done?", dc.drawnString);
		} catch (Exception e) {
			e.printStackTrace();
			fail(e.toString());
		}
	}

	public Test suite() {
		TestSuite suite = new TestSuite();
		suite.addTest(new CharactorSequenceTest("testAlphabetSeq", new TestMethod() {
			public void run(TestCase tc) {
				((CharactorSequenceTest) tc).testAlphabetSeq();
			}
		}));
		return suite;
	}

	class MockDrawContext extends DrawContextImpl {

		String drawnString;
		Graphics grp;

		public MockDrawContext(Graphics grp, int x, int y) {
			super(grp, 0, 0);
			this.grp = grp;
		}

		public void drawString(String sub, int x, int y) {
			this.drawnString = sub;
		}

		public DrawContext createContext(int x, int y) {
			return this;
		}

		public DrawContext moveTo(int x, int y) {
			return this;
		}

	}

	class MockFormContext extends FormContextImpl {

		public MockFormContext() {
			super(new MockApp());
		}

		public int getHeight() {
			return 240;
		}
		
	}
	
	class MockForm extends Form {
		
		protected FormContext _context;
		public MockForm() {
			_context = new MockFormContext();
		}
		public FormContext getContext() {
			return _context;
		}
		
		
	}
	class MockApp extends GrainApp {
		
	}
	
	class MockCanvas extends Canvas {

		public void paint(Graphics arg0) {
		}

	}
}
