package jp.grain.sprout.platform.doja;

import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestMethod;
import j2meunit.framework.TestSuite;

import java.io.IOException;
import java.io.InputStream;

import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.InputConnection;

import jp.grain.spike.BinaryXMLParser;
import jp.grain.spike.Document;
import jp.grain.sprout.Initializer;
import jp.grain.sprout.OperetionListener;
import jp.grain.sprout.SerializeOperation;
import jp.grain.sprout.model.Instance;
import jp.grain.sprout.model.Submission;
import jp.grain.sprout.ui.Block;
import jp.grain.sprout.ui.Box;
import jp.grain.sprout.ui.Choice;
import jp.grain.sprout.ui.Form;
import jp.grain.sprout.ui.FormBuilder;
import jp.grain.sprout.ui.FormContext;
import jp.grain.sprout.ui.TabBlock;
import jp.grain.sprout.ui.TextBox;

import org.xmlpull.v1.XmlPullParserException;

/**
 * A test of Form
 * 
 * @version $Id: FormTest.java 2006-05-25 10:00 NC $
 * @author NC
 * 
 */
public class FormTest extends TestCase {

	private Form form;
	private Box tabBlockBox;
	private Box inlineBlockBox;
	private Box blockBox;
	private Box subInlineBlockBox;
	private Box inLineBox;

	public FormTest() {
		// TODO Auto-generated constructor stub
	}

	public FormTest(String name, TestMethod method) {
		super(name, method);
	}

	protected void setUp() throws Exception {
		MockSproutApp app = new MockSproutApp("resource:///form_test.gbxml");
		app.start();

		FormContextImpl ctx = (FormContextImpl) app.getFormContext();
		ctx.getInitializer().join();
		form = ctx.getForm();
	}

	public void testRegisterNavigation() {
		try {
			tabBlockBox = form.getRootBlock().getChildBox(1);
			inlineBlockBox = form.getRootBlock().getChildBox(2);
			blockBox = ((TabBlock) tabBlockBox).getChildBox(0);
			subInlineBlockBox = ((Block) blockBox).getChildBox(0);

			assertEquals("Total components in the sub inline-block are : " + subInlineBlockBox.getChildCount(), 6, subInlineBlockBox.getChildCount());
			assertEquals("Unique component in lastest inline-block is : " + inlineBlockBox.getChild(0).getClass().getName(), "jp.grain.sprout.ui.Button",
					inlineBlockBox.getChild(0).getClass().getName());
		} catch (Exception e) {
			fail(e.toString());
			e.printStackTrace();
		}
	}

	public void testGetFocusedComponent() {
		try {
			// Kvȕ
			inlineBlockBox = form.getRootBlock().getChildBox(1);
			// eXgs
			assertEquals("Current focused component is : " + inlineBlockBox.getClass().getName(), inlineBlockBox.getClass().getName(), form
					.getFocusedComponent().getClass().getName());
		} catch (Exception e) {
			fail(e.toString());
			e.printStackTrace();
		}
	}

	public void testNavigation() {
		try {
			// Kvȕ
			tabBlockBox = form.getRootBlock().getChildBox(1);
			inlineBlockBox = form.getRootBlock().getChildBox(2);
			blockBox = ((TabBlock) tabBlockBox).getChildBox(0);
			subInlineBlockBox = ((Block) blockBox).getChildBox(0);
			// eXgs
			// ւ̃eXg
			assertEquals("Current focused component after go Next is : " + form.nextNavigation().getClass().getName(), "jp.grain.sprout.ui.Choice", form
					.getFocusedComponent().getClass().getName());
			assertEquals("Current focused component after go Next is : " + form.nextNavigation().getClass().getName(), "jp.grain.sprout.ui.TextBox", form
					.getFocusedComponent().getClass().getName());
			TextBox currentTextBox = (TextBox) form.getFocusedComponent();
			assertEquals("Current focused component Label is : " + currentTextBox.getLabel().getText(), "TEL", currentTextBox.getLabel().getText());
			currentTextBox = (TextBox) form.nextNavigation();
			assertEquals("Current focused component Label is : " + currentTextBox.getLabel().getText(), "̶", currentTextBox.getLabel().getText());
			// ߂̃eXg
			currentTextBox = (TextBox) form.previousNavigation();
			assertEquals("Current focused component Label is : " + currentTextBox.getLabel().getText(), "TEL", currentTextBox.getLabel().getText());
			Choice currentChoice = (Choice) form.previousNavigation();
			assertEquals("Current focused component Label is : " + currentChoice.getLabel().getText(), "{", currentChoice.getLabel().getText());
		} catch (Exception e) {
			fail(e.toString());
			e.printStackTrace();
		}
	}

	public Test suite() {
		TestSuite suite = new TestSuite();

		suite.addTest(new FormTest("testRegisterNavigation", new TestMethod() {
			public void run(TestCase tc) {
				((FormTest) tc).testRegisterNavigation();
			}
		}));
		suite.addTest(new FormTest("testGetFocusedComponent", new TestMethod() {
			public void run(TestCase tc) {
				((FormTest) tc).testGetFocusedComponent();
			}
		}));
		suite.addTest(new FormTest("testNavigation", new TestMethod() {
			public void run(TestCase tc) {
				((FormTest) tc).testNavigation();
			}
		}));
		return suite;
	}

	/**
	 * Mock Classes
	 */
	class MockSproutApp extends GrainApp {

		Throwable error;
		String defaultUri;

		MockSproutApp(String defaultUri) {
			setDefaultFormUrl(defaultUri);
			setDefaultFormLocation(DEFAULT_FORM_LOC_HTTP);
			_context = new MockFormContextImpl(this);
		}

		public void loadBasicPref() {
		}

		public FormContext getFormContext() {
			return _context;
		}
	}

	class MockFormContextImpl extends FormContextImpl {

		MockFormContextImpl(GrainApp app) {
			super(app);
		}

		public SerializeOperation createSubmissionOperation(String url) {
			return new MockSubmissionOperation(url, this);
		}

		public SerializeOperation createSubmissionOperation(Submission element) {
			if (element == null) {
				return new MockSubmissionOperation(_app.getDefaultFormUrl(), this);
			} else {
				return new MockSubmissionOperation(element.getActionUrl(), this);
			}
		}

		public SerializeOperation createExternalInstanceLoadOperation(Instance element) {
			return super.createExternalInstanceLoadOperation(element);
		}
	}

	class MockSubmissionOperation extends SerializeOperation {

		private String url;
		private Form form;
		private Initializer initializer;

		MockSubmissionOperation(String url, FormContext context) {
			this.url = url;
			this.initializer = new Initializer(context);
		}

		public String getConnectionString() {
			return this.url;
		}

		public int getMode() {
			return Connector.READ;
		}

		public Document getInstanceDocument() {
			return null;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see jp.grain.sprout.FormSerializeOperation#setListener(jp.grain.sprout.OperetionListener)
		 */
		public void setListener(OperetionListener observer) {
			// TODO Auto-generated method stub
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see jp.grain.sprout.SerializeOperation#doExecute(javax.microedition.io.Connection)
		 */
		protected void doExecute(Connection conn) throws Exception {
			InputStream is = null;
			try {
				is = ((InputConnection) conn).openInputStream();
				BinaryXMLParser parser = BinaryXMLParser.newInstance(is, "SJIS");
				FormBuilder builder = new FormBuilder(parser, getConnectionString(), true);
				builder.build();
				this.form = (Form) builder.getDocument();
			} catch (IOException e) {
				e.printStackTrace();
				throw e;
			} catch (XmlPullParserException e) {
				e.printStackTrace();
			} finally {
				if (is != null) is.close();
			}
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see jp.grain.sprout.SerializeOperation#doCompletion()
		 */
		protected void doCompletion() throws Exception {
			this.initializer.init(this.form);
			this.initializer.start();
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see jp.grain.sprout.SerializeOperation#doException(java.lang.Exception)
		 */
		protected void doException(Exception e) {
			// TODO Auto-generated method stub

		}
	}

}
