/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/03/30 7:18:42
 * 
 */
package jp.grain.sprout;

import java.io.IOException;

import jp.grain.spike.Document;
import jp.grain.sprout.model.Instance;
import jp.grain.sprout.model.Model;
import jp.grain.sprout.ui.Form;
import jp.grain.sprout.ui.FormContext;

/**
 * TODO FormInitializer
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public class Initializer extends Thread {
    
    public static final int ERROR_ILLEGAL_DATA_FORMAT = 1;
    public static final int ERROR_UNEXPECTED = 0;
    
    
    private FormContext _context;
    private Instance _instance;
    private Document _doc;
    
    /**
     * @param context
     */
    public Initializer(FormContext context) {
        _context = context;        
    }
    
    public void init(Form replaceForm) {
        System.out.println("init: replace form = " + replaceForm);
        _context.setInitializer(this);
        _instance = null;
        _doc = replaceForm;
    }

    public void init(Instance target, Document replaceDocument) {
        _context.setInitializer(this);
        _instance = target;
        _doc = replaceDocument;
    }
    
    public FormContext getContext() {
        return _context;
    }
    
    
    /* (non-Javadoc)
     * @see java.lang.Thread#run()
     */
    public void run() {
        try {
            if (_instance == null) {
                replaceForm();
            } else {
                replaceInstanceDocument();
            }
            _context.init();
            _context.requestRefresh();
            _context.requestRender();
            _context.refresh();
           // System.out.println("NOTIFY: INITIALIZER RUN: init context");
            _context.render();
        } catch (InitializeException e) {
            _context.notifyInitializeError(e.getCode(), e);            
        } catch (Exception e) {
            System.out.println("Initializer Error :");
            e.printStackTrace();
            _context.notifyInitializeError(ERROR_UNEXPECTED, e);
        }
    }

    /**
     * @throws InitializeException 
     * 
     */
    private void replaceForm() throws InitializeException {
        if (_doc == null) throw new InitializeException(ERROR_ILLEGAL_DATA_FORMAT);
        Form saved = _context.getForm();
        Form form = (Form)_doc;
        _context.setForm(form);
       // try {
            //System.out.println("replace form : form = " + form);
            //System.out.println("NOTIFY: INITIALIZER replaceForm: init Form");
            //form.init(_context);
            //form.layout();
        //} catch (IOException e) {
            //e.printStackTrace();
        //}
    }
    
    /**
     * @throws InitializeException 
     * 
     */
    private void replaceInstanceDocument() throws InitializeException {
        if (_doc == null) throw new InitializeException(ERROR_ILLEGAL_DATA_FORMAT);
        _instance.setInstanceDocument(_doc);
        try {
            Model model = (Model)_instance.getParentElement();
            model.rebuild();
            model.recalculate();
            model.revalidate();
            System.out.println("INITIALIZER replaceInstanceDocument: init Form");
            _context.getForm().init(_context);
        } catch (IOException e) {
            e.printStackTrace();
        }        
    }    
    
}
