package jp.grain.sprout.model;

import java.util.Vector;

import jp.grain.spike.Attribute;
import jp.grain.spike.Document;
import jp.grain.spike.Element;
import jp.grain.spike.Node;
import jp.grain.spike.xpath.XPathExpr;

public class InstanceElement extends Element {

	public static final String XSD_ID = "id";

	protected Bind _typeProperty = Bind.DEFAULT_BIND;
	protected Bind _readonlyProperty = Bind.DEFAULT_BIND;
	protected Bind _requiredProperty = Bind.DEFAULT_BIND;
	protected Bind _relevantProperty = Bind.DEFAULT_BIND;
	protected Bind _constraintProperty = Bind.DEFAULT_BIND;
	protected Bind _calculateProperty = Bind.DEFAULT_BIND;
	protected Vector _exprs = new Vector();
	
	public InstanceElement(String name, String prefix, String namespace) {
		super(name, prefix, namespace);
	}

	public InstanceElement(String name) {
		super(name);
	}

	public int getNodeType() {
		return Node.NODE_TYPE_ELEMENT;
	}

	public InstanceElement getParentInstanceElement() {
		if(this._parent instanceof InstanceElement) return (InstanceElement)this._parent;
		return null;
	}
	
	public void postProcess(Node parent) {
		// TODO ꂽ\bhEX^u
		
	}

	public void preProcess(Node parent) {
        if (parent instanceof Element) {
        	((Element)parent).addChild(this);
        } else if (parent instanceof Document) {
            ((Document)parent).setRootElement(this);
        }
	}

	/**
	 * 
	 * 6.1.2 The readonly Property
	 * Description: describes whether the value is restricted from changing.
	 * Computed Expression: Yes.
	 * Legal Values: Any expression that is convertible to XPath boolean with boolean().
	 * Default Value: false(), unless a calculate property is specified, then true().
	 * Inheritance Rules: If any ancestor node evaluates to true, this value is treated as true. Otherwise, the local value is used.
	 * 
	 * @param node
	 * @return
	 */
	public boolean isReadonly() {
		if(this._calculateProperty != Bind.DEFAULT_BIND) return true;
		InstanceElement parent = getParentInstanceElement();
		if(parent != null && parent.isReadonly()) return true;
		
		return this._readonlyProperty.isReadonly();
	}
	
	public boolean isRequired() {
		return this._requiredProperty.isRequired();
	}
	
	/**
	 * 6.1.4 The relevant Property
	 * Description: indicates whether the model item is currently relevant. Instance data nodes with this property evaluating to false are not serialized for submission.
	 * Computed Expression: Yes.
	 * Legal Values: Any expression that is convertible to XPath boolean with boolean().
	 * Default Value: true().
	 * Inheritance Rules: If any ancestor node evaluates to XPath false, this value is treated as false. Otherwise, the local value is used.
	 * 
	 * @param node
	 * @return
	 */
	public boolean isRelevant() {
		InstanceElement parent = getParentInstanceElement();
		if(parent != null && !parent.isRelevant()) return false;
		
		return this._relevantProperty.isRelevant();
	}
	
	public boolean isConstraint() {
		return this._constraintProperty.isConstraint();
	}

	public int calculate() {
		return this._calculateProperty.calculate();
	}
	
	public boolean validate() {
		if(this._typeProperty.getType().equals(Bind.TYPE_NUMBER)) {
			try {
				Integer.parseInt(this.getText());
			} catch (NumberFormatException e) {
				return false;
			}
		} else if(this._typeProperty.getType().equals(Bind.TYPE_BOOLEAN)) {
			if(!("true".equals(getText()) || "false".equals(getText()))) return false;
		}
		
		return this._constraintProperty.isConstraint();
	}
	
	public void setTypeProperty(Bind property) {
		if(this._typeProperty == Bind.DEFAULT_BIND) {
			this._typeProperty = property;
			return;
		}
		
		throw new RuntimeException("Duplicate Type Property!");
	}

	public Bind getTypeProperty() {
		return this._typeProperty;
	}
	
	public void setReadonlyProperty(Bind property) {
		if(this._readonlyProperty == Bind.DEFAULT_BIND) {
			this._readonlyProperty = property;
			return;
		}
		
		throw new RuntimeException("Duplicate Readonly Property!");
	}

	public Bind getReadonlyProperty() {
		return this._readonlyProperty;
	}
	
	public void setRequiredProperty(Bind property) {
		if(this._requiredProperty == Bind.DEFAULT_BIND) {
			this._requiredProperty = property;
			return;
		}
		
		throw new RuntimeException("Duplicate Required Property!");
	}

	public Bind getRequiredProperty() {
		return this._requiredProperty;
	}
	
	public void setRelevantProperty(Bind property) {
		if(this._relevantProperty == Bind.DEFAULT_BIND) {
			this._relevantProperty = property;
			return;
		}
		
		throw new RuntimeException("Duplicate Relevant Property!");
	}

	public Bind getRelevantProperty() {
		return this._relevantProperty;
	}
	
	public void setConstraintProperty(Bind property) {
		if(this._constraintProperty == Bind.DEFAULT_BIND) {
			this._constraintProperty = property;
			return;
		}
		
		throw new RuntimeException("Duplicate Constraint Property!");
	}

	public Bind getConstraintProperty() {
		return this._constraintProperty;
	}
	
	public void setCalculateProperty(Bind property) {
		if(this._calculateProperty == Bind.DEFAULT_BIND) {
			this._calculateProperty = property;
			return;
		}
		
		throw new RuntimeException("Duplicate Calculate Property!");
	}

	public Bind getCalculateProperty() {
		return this._calculateProperty;
	}

    public Node clone(Document doc) {
        Element elem = createElement();
        if (_attributes != null) {
            for (int i = 0; i < _attributes.size(); ++i) {
                Attribute src = (Attribute)_attributes.elementAt(i);
                if (XSD_ID.equals(src._name) && src._namespace == null) {
                    doc.registerNode(src._value, elem);
                }
                elem.addAttribute(src._name, src._prefix, src._namespace, src._value);
            }
        }
        for (int i = 0; i < getChildCount(); ++i) {
            Object child = getChild(i);
            if (child instanceof Node) {
                elem.addChild(((Node)child).clone(doc));
            } else if (child instanceof String) {
                elem.setText((String)child);
            }
        }
        return elem;
    }
    
    public Element createElement() {
        InstanceElement elem = new InstanceElement(_name, _prefix, _namespace);
        elem.setTypeProperty(this._typeProperty);
        elem.setReadonlyProperty(this._readonlyProperty);
        elem.setRequiredProperty(this._requiredProperty);
        elem.setRelevantProperty(this._relevantProperty);
        elem.setCalculateProperty(this._calculateProperty);
        elem.setConstraintProperty(this._constraintProperty);
        return elem;
    }

    public void addXPathExpr(XPathExpr expr) {
    	if(!this._exprs.contains(expr)) 
    		this._exprs.addElement(expr);
    }

    public void exprRefresh() {
    	for(int i=0; i<_exprs.size(); i++) {
    		XPathExpr expr = (XPathExpr)_exprs.elementAt(i);
    		expr.requestEvaluate();
    	}
    	
    	//qɂʒm
    	for(int i=0; i<getChildCount(); i++) {
    		if(getChildElement(i) == null) continue;
    		Element child = getChildElement(i);
    		if(child instanceof InstanceElement) {
    			((InstanceElement)child).exprRefresh();
    		}
    	}
    }
    
	public Element addChild(int index, Node child) {
		exprRefresh();
		return super.addChild(index, child);
	}

	public Element addChild(Node child) {
		exprRefresh();
		return super.addChild(child);
	}

	public Element addChildText(String text) {
		exprRefresh();
		return super.addChildText(text);
	}

	public void removeChild(int index) {
		exprRefresh();
		super.removeChild(index);
	}

	public void removeChild(Node node) {
		exprRefresh();
		super.removeChild(node);
	}

	public void replace(Node src, Node dst) {
		exprRefresh();
		super.replace(src, dst);
	}

	public void setChildren(Vector children) {
		exprRefresh();
		super.setChildren(children);
	}

	public void setSimpleContent(String content) {
		//exprRefresh();
		super.setSimpleContent(content);
	}

	public Element setText(String text) {
		//exprRefresh();
		return super.setText(text);
	}
    
    
}
