/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/01/15 8:36:47
 * 
 */
package jp.grain.spike.xpath;

import java.util.Vector;

import jp.grain.spike.DefaultElement;
import jp.grain.spike.Node;
import jp.grain.sprout.BindingElement;
import jp.grain.sprout.ui.ContextNodeset;

/**
 * TODO XPathLocator
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public class XPathExpr extends DefaultElement {

    public static final String NAME = "expr";
    
    private ContextNodeset _contextNodeset;
    private boolean _filterd;
    private boolean _requestEvaluate;
    
    private Node[] _cache;
    private Vector _operands = new Vector();

    public XPathExpr() {
        super(NAME);
        _requestEvaluate = true;
    }

    /**
     * @return
     */
    public ContextNodeset createContextNodeset() {
        return new ContextNodeset(_contextNodeset.getModel(), _cache);
    }


    
    public XPathEvaluator.Result evaluate(Node context) {
        return XPathEvaluator.evaluate(context, this);
    }

    public void addOperand(Object[] operand) {
        _operands.addElement(operand); 
    }
    
    public void addPredicate(Object[] operand) {
    	this._filterd = true;
    	addOperand(operand);
    }
    
    public void postProcess(Node parent) {
        if (parent instanceof BindingElement) {
            ((BindingElement)parent).setBindingExpr(getAttribute("name"), this);
        }
    }

    public Object[] getOperands() {
        Object[] operands = new Object[_operands.size()];
        _operands.copyInto(operands);
        
        //ꂪĂ΂̂EvaluatêƂ݂̂Ȃ̂łŃtO𗎂Ƃ
    	System.out.println("XPATHEXPR: getOperands()"+this.hashCode());
        _requestEvaluate = false;
        
        return operands;
    }
    
    public static Object[] createOperand(String name) {
        Object[] operand = { name };
        return operand;
    }
    
    public static Object[] createOperand(String name, Object param0) {
        Object[] operand = { name, param0 };
        return operand;
    }
    
    public static Object[] createOperand(String name, Object param0, Object param1) {
        Object[] operand = { name, param0, param1 };
        return operand;
    }

    public static Object[] createOperand(String name, Object param0, Object param1, Object param2) {
        Object[] operand = { name, param0, param1, param2 };
        return operand;
    }

    public void requestEvaluate() {
    	System.out.println("XPATHEXPR: requestEvaluate()"+this.hashCode());
    	this._requestEvaluate = true;
    }
    
    public boolean needEvaluate() {
    	return _filterd || _requestEvaluate;
    }
}
