/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2005/02/05
 * 
 */
package jp.grain.sprout;

import java.io.IOException;

import javax.microedition.io.Connection;

import jp.grain.sprout.ui.FormContext;

/**
 * hLg̃VACY̊NX
 * 
 * @version $Id: SerializeOperation.java 245 2006-04-09 12:25:24Z go $
 * @author Go Takahashi
 */
public abstract class SerializeOperation {
    
    protected OperetionListener _listener;
    protected Throwable _error;
    
	abstract public String getConnectionString();
	abstract public int getMode();
    
	public void execute(FormContext ctx) {
        Connection conn = null;
        try {
            System.out.println("SerializeOperation.execute");
            conn = ctx.createConnection(this);
            doExecute(conn);
            if (_listener != null) _listener.operationCompleted(this);
            doCompletion();
        } catch (Exception e) {
            e.printStackTrace();
            _error = e;
            if (_listener != null) _listener.operationFailure(this, e);
            doException(e);
        } finally {
            System.out.println("SerializeOperation.execute.finally");
            try {
                if (conn != null) conn.close();
            } catch (IOException e) {
            }
        }
    }
    
    abstract protected void doExecute(Connection conn) throws Exception;
    abstract protected void doCompletion() throws Exception;
    abstract protected void doException(Exception e);

    /**
     * @return
     */
    public Object getData() {
        return null;
    }
    
    public boolean hasError() {
        return _error != null; 
    }

    public Throwable getError() {
        return _error;
    }

}