/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/01/22 6:09:30
 * 
 */
package jp.grain.sprout.ui;

import java.util.Vector;

import jp.grain.spike.Document;
import jp.grain.spike.Node;
import jp.grain.spike.event.Event;
import jp.grain.spike.event.FocusListener;
import jp.grain.sprout.action.Action;
import jp.grain.sprout.model.InstanceElement;

/**
 * TODO Component
 * 
 * @version $Id: InlineComponent.java 399 2006-06-30 10:53:41Z nakajo $
 * @author Go Takahashi
 */
public abstract class InlineComponent extends Inline implements FocusListener {

    /** ̃hLg̐\\zFormUirQ[Vp̘A */
    protected int _navigationIndex = FocusListener.DEFAULT_NAVI_INDEX;
    /** ̃R|[lgɃtH[JXĂ邩ǂ */
    protected boolean _focusin;
    /** ̃R|[lgActionqvf */
    protected Vector _actions = new Vector();
    
    /**
     * @param name
     */
    public InlineComponent(String name) {
        super(name);
    }

    protected boolean _activate;

    public void requestEvaluate() {
		super.requestEvaluate();
		//x̓hLgc[ɓĂȂ̂ŖIɌĂяoKv
		if(_label != null) _label.requestEvaluate();
		//actionl
    	if(_actions == null) return;
        for(int i=0; i<_actions.size(); i++) {
        	Action action = (Action)_actions.elementAt(i);
        	action.requestEvaluate();
        }
	}

	public void initChildren(Form form) {
    	if(_actions == null) return;
        for(int i=0; i<_actions.size(); i++) {
        	Action action = (Action)_actions.elementAt(i);
        	action.init(form);
        }
        super.initChildren(form);
    }
    
    protected void applySelf(Form form) {
    	//System.out.println("CALL REGIST_NAVIGATION this="+this.getClass().getName());
    	//navigationIndex擾邽߂ɖňx͓o^B
        form.registeNavigation(this._navigationIndex, this);
        //fړɉnavigationvf폜
        if(getBindingInstanceElement() != null) {
        	InstanceElement instanceNode = getBindingInstanceElement();
        	if(!instanceNode.isRelevant() || instanceNode.isReadonly()) {
        		System.out.println("NAVIGATION: applyself relevent="+instanceNode.isRelevant()+": readonly="+instanceNode.isReadonly());
        		getOwnerForm().removeNavigation(this);
        	}
        }
        
        int maxWidth = ((Box)_parent).getBoxWidth() - (_margin+_padding+_border)*2;
        _width = (_preferedWidth > maxWidth) ? maxWidth : _preferedWidth;
        _height = _preferedHeight;
        if (_label != null) _label.apply(form);
    }
    
    public int getHeight() {
    	return _height + (_margin + _padding + _border) * 2;
    }
    
    public boolean fitWithIn(Row row) {
        if (hasOuterLabel() && _label != null) {
            if (!_label.fitWithIn(row)) return false;
        }
        return super.fitWithIn(row);
    }
        
    public boolean handleAction(FormContext ctx, int action, int selector) {
    	InstanceElement node = (InstanceElement)getBindingNode();
    	if(node != null && !node.isRelevant()) {
    		System.out.println("HANDLE: "+this+" relevant is false");
    		return true;
    	}
		System.out.println("HANDLE: "+this+" relevant is true");
    	
        if (action == FormContext.ACT_FOCUS_IN) {
    //TODO dispatch event
    //      if (this.element instanceof FormControlElement) {
    //          ((FormControlElement)this.element).dispatchEvent(new Event("DOMFocusIn", true, false));
    //      }
        } else if (action == FormContext.ACT_FOCUS_OUT) {
    //TODO dispatch event
    //      if (this.element instanceof FormControlElement) {
    //          ((FormControlElement)this.element).dispatchEvent(new Event("DOMFocusOut", true, false));
    //      }
        }
        return false;
    }
    
    /**
     * @return
     */
    public boolean isCaptureEnable() {
        return _activate;
    }

    /**
     * @param label
     */
    public void setLabel(Inline label) {
        _label = label;
        _label.setParent(this);
    }
    
    public boolean hasOuterLabel() {
        return true;
    }
    
    public boolean isBindingElement() {
        return true;
    }

	public int getNavigationIndex() {
		return this._navigationIndex;
	}

	public void setNavigationIndex(int navigationIndex) {
		this._navigationIndex = navigationIndex;
	}

	public String[] getHandleEvents() {
		String[] events = new String[14];
		//4.2 Cxg
		//events[0] = Event.TYPE_XFORMS_MODEL_CONSTRUCT_DONE;
		//4.3 ݍpCxg
		events[1] = Event.TYPE_XFORMS_HELP;
		events[2] = Event.TYPE_XFORMS_HINT;
		//4.4 ʒmCxg
		events[3] = Event.TYPE_XFORMS_VALUE_CHANGED;
		events[4] = Event.TYPE_XFORMS_VALID;
		events[5] = Event.TYPE_XFORMS_INVALID;
		events[6] = Event.TYPE_XFORMS_READONLY;
		events[7] = Event.TYPE_XFORMS_READWRITE;
		events[8] = Event.TYPE_XFORMS_REQUIRED;
		events[9] = Event.TYPE_XFORMS_OPTIONAL;
		events[10] = Event.TYPE_XFORMS_ENABLED;
		events[11] = Event.TYPE_XFORMS_DISABLED;
		events[12] = Event.TYPE_XFORMS_IN_RANGE;
		events[13] = Event.TYPE_XFORMS_OUT_OF_RANGE;
		
		//g Rg[Cxg
		//events[14] = Event.TYPE_GRAIN_ACTION_EVENT;
		
		return events;
	}

    public boolean dispatchEvent(Event event) {
    	for(int i=0; i<_actions.size(); i++) {
    		Action action = (Action)_actions.elementAt(i);
    		if(action.isHandlableEvent(event.getType())) {
    			action.handleEvent(event);
    		}
    	}
    	return handleEvent(event);
    }

	public boolean handleEvent(Event event) {
		if(event.getType() == Event.TYPE_XFORMS_MODEL_CONSTRUCT_DONE) {
			System.out.println("HANDLE EVENT: TYPE_XFORMS_MODEL_CONSTRUCT_DONE this="+this);
			init((Form)event.getOwner());
		} else if(event.getType() == Event.TYPE_DOMFOCUSIN) {
			this._focusin = true;
			event.getContext().moveTo(0, getAbsoluteCenterY(), getHeight());
		} else if(event.getType() == Event.TYPE_DOMFOCUSOUT) {
			this._focusin = false;
		} else if(event.getType() == Event.TYPE_XFORMS_ENABLED) {
			if(getBindingNode() == null) return false;
			if(event.getOwner() == ((InstanceElement)getBindingNode()).getRelevantProperty()) {
				getOwnerForm().registeNavigation(getNavigationIndex(), this);
			}
		} else if(event.getType() == Event.TYPE_XFORMS_DISABLED) {
			if(getBindingNode() == null) return false;
			if(event.getOwner() == ((InstanceElement)getBindingNode()).getRelevantProperty()) {
				getOwnerForm().removeNavigation(this);
			}
		} else if(event.getType() == Event.TYPE_XFORMS_READWRITE) {
			if(getBindingNode() == null) return false;
			if(event.getOwner() == ((InstanceElement)getBindingNode()).getReadonlyProperty()) {
				getOwnerForm().registeNavigation(getNavigationIndex(), this);
			}
		} else if(event.getType() == Event.TYPE_XFORMS_READONLY) {
			if(getBindingNode() == null) return false;
			if(event.getOwner() == ((InstanceElement)getBindingNode()).getReadonlyProperty()) {
				getOwnerForm().removeNavigation(this);
			}
		} else if(event.getType() == Event.TYPE_XFORMS_FOCUS) {
			if(getBindingNode() != null) {
				return (!getBindingInstanceElement().isReadonly() && getBindingInstanceElement().isRelevant());
			}
		}
		return false;
	}

	public void addAction(Action action) {
		addChild(action);
		this._actions.addElement(action);
	}

	public Node clone(Document doc) {
		InlineComponent clone = (InlineComponent)super.clone(doc);
		if(this.getLabel() != null) {
			clone.setLabel((Inline)this.getLabel().clone(doc));
		}
		if(!this._actions.isEmpty()) {
			for(int i=0; i<this._actions.size(); i++) {
				Action action = (Action)this._actions.elementAt(i);
				clone.addAction((Action)action.clone(doc));
				//clone.addAction((Action)this._actions.elementAt(i));
			}
		}
		return clone;
	}
	
}
